/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.blogs.internal.change.tracking.spi.reference;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.model.BlogsEntryTable;
import com.liferay.blogs.service.persistence.BlogsEntryPersistence;
import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.change.tracking.spi.reference.builder.ChildTableReferenceInfoBuilder;
import com.liferay.change.tracking.spi.reference.builder.ParentTableReferenceInfoBuilder;
import com.liferay.friendly.url.model.FriendlyURLEntryTable;
import com.liferay.portal.kernel.model.UserTable;
import com.liferay.portal.kernel.service.persistence.BasePersistence;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Cheryl Tang
 */
@Component(service = TableReferenceDefinition.class)
public class BlogsEntryTableReferenceDefinition
	implements TableReferenceDefinition<BlogsEntryTable> {

	@Override
	public void defineChildTableReferences(
		ChildTableReferenceInfoBuilder<BlogsEntryTable>
			childTableReferenceInfoBuilder) {

		childTableReferenceInfoBuilder.assetEntryReference(
			BlogsEntryTable.INSTANCE.entryId, BlogsEntry.class
		).classNameReference(
			BlogsEntryTable.INSTANCE.entryId,
			FriendlyURLEntryTable.INSTANCE.classPK, BlogsEntry.class
		).resourcePermissionReference(
			BlogsEntryTable.INSTANCE.entryId, BlogsEntry.class
		);
	}

	@Override
	public void defineParentTableReferences(
		ParentTableReferenceInfoBuilder<BlogsEntryTable>
			parentTableReferenceInfoBuilder) {

		parentTableReferenceInfoBuilder.groupedModel(
			BlogsEntryTable.INSTANCE
		).singleColumnReference(
			BlogsEntryTable.INSTANCE.userId, UserTable.INSTANCE.userId
		);
	}

	@Override
	public BasePersistence<?> getBasePersistence() {
		return _blogsEntryPersistence;
	}

	@Override
	public BlogsEntryTable getTable() {
		return BlogsEntryTable.INSTANCE;
	}

	@Reference
	private BlogsEntryPersistence _blogsEntryPersistence;

}