/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.service.persistence.impl;

import com.liferay.blogs.model.BlogsStatsUser;
import com.liferay.blogs.model.impl.BlogsStatsUserImpl;
import com.liferay.blogs.service.persistence.BlogsStatsUserFinder;
import com.liferay.blogs.service.persistence.BlogsStatsUserUtil;
import com.liferay.blogs.service.persistence.impl.BlogsStatsUserFinderBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BlogsStatsUserFinder.class})
public class BlogsStatsUserFinderImpl
extends BlogsStatsUserFinderBaseImpl
implements BlogsStatsUserFinder {
    public static final String COUNT_BY_ORGANIZATION_IDS = BlogsStatsUserFinder.class.getName() + ".countByOrganizationIds";
    public static final String FIND_BY_GROUP_IDS = BlogsStatsUserFinder.class.getName() + ".findByGroupIds";
    public static final String FIND_BY_ORGANIZATION_IDS = BlogsStatsUserFinder.class.getName() + ".findByOrganizationIds";
    @Reference
    private CustomSQL _customSQL;

    public int countByOrganizationId(long organizationId) {
        return this.countByOrganizationIds(ListUtil.fromArray((Object[])new Long[]{organizationId}));
    }

    public int countByOrganizationIds(List<Long> organizationIds) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_ORGANIZATION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            for (Long organizationId : organizationIds) {
                queryPos.add(organizationId);
            }
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsStatsUser> findByGroupIds(long companyId, long groupId, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_GROUP_IDS);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("userId", Type.LONG);
            sqlQuery.addScalar("lastPostDate", Type.TIMESTAMP);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(groupId);
            queryPos.add(groupId);
            queryPos.add(groupId);
            ArrayList<BlogsStatsUser> statsUsers = new ArrayList<BlogsStatsUser>();
            Iterator iterator = QueryUtil.iterate((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            while (iterator.hasNext()) {
                Date lastPostDate;
                Object[] array = (Object[])iterator.next();
                long userId = (Long)array[0];
                List curStatsUsers = BlogsStatsUserUtil.findByU_L((long)userId, (Date)(lastPostDate = (Date)array[1]));
                if (curStatsUsers.isEmpty()) continue;
                BlogsStatsUser statsUser = (BlogsStatsUser)curStatsUsers.get(0);
                statsUsers.add(statsUser);
            }
            ArrayList<BlogsStatsUser> arrayList = statsUsers;
            return arrayList;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsStatsUser> findByOrganizationId(long organizationId, int start, int end, OrderByComparator<BlogsStatsUser> orderByComparator) {
        return this.findByOrganizationIds(ListUtil.fromArray((Object[])new Long[]{organizationId}), start, end, orderByComparator);
    }

    public List<BlogsStatsUser> findByOrganizationIds(List<Long> organizationIds, int start, int end, OrderByComparator<BlogsStatsUser> orderByComparator) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_ORGANIZATION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            sql = this._customSQL.replaceOrderBy(sql, orderByComparator);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("BlogsStatsUser", BlogsStatsUserImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            for (Long organizationId : organizationIds) {
                queryPos.add(organizationId);
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getOrganizationIds(List<Long> organizationIds) {
        if (organizationIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(organizationIds.size() * 2 - 1);
        for (int i = 0; i < organizationIds.size(); ++i) {
            sb.append("Users_Orgs.organizationId = ? ");
            if (i + 1 == organizationIds.size()) continue;
            sb.append("OR ");
        }
        return sb.toString();
    }
}

