/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.service.impl;

import com.liferay.blogs.exception.NoSuchStatsUserException;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.model.BlogsStatsUser;
import com.liferay.blogs.service.base.BlogsStatsUserLocalServiceBaseImpl;
import com.liferay.blogs.util.comparator.EntryDisplayDateComparator;
import com.liferay.blogs.util.comparator.StatsUserLastPostDateComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.blogs.model.BlogsStatsUser"}, service={AopService.class})
public class BlogsStatsUserLocalServiceImpl
extends BlogsStatsUserLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(BlogsStatsUserLocalServiceImpl.class);

    public void deleteStatsUser(BlogsStatsUser statsUsers) {
        this.blogsStatsUserPersistence.remove((BaseModel)statsUsers);
    }

    public void deleteStatsUser(long statsUserId) throws PortalException {
        BlogsStatsUser statsUsers = this.blogsStatsUserPersistence.findByPrimaryKey(statsUserId);
        this.deleteStatsUser(statsUsers);
    }

    public void deleteStatsUserByGroupId(long groupId) {
        List statsUsers = this.blogsStatsUserPersistence.findByGroupId(groupId);
        for (BlogsStatsUser statsUser : statsUsers) {
            this.deleteStatsUser(statsUser);
        }
    }

    public void deleteStatsUserByUserId(long userId) {
        List statsUsers = this.blogsStatsUserPersistence.findByUserId(userId);
        for (BlogsStatsUser statsUser : statsUsers) {
            this.deleteStatsUser(statsUser);
        }
    }

    public BlogsStatsUser fetchStatsUser(long groupId, long userId) {
        return this.blogsStatsUserPersistence.fetchByG_U(groupId, userId);
    }

    public List<BlogsStatsUser> getCompanyStatsUsers(long companyId, int start, int end) {
        return this.blogsStatsUserPersistence.findByC_NotE(companyId, 0, start, end, (OrderByComparator)new StatsUserLastPostDateComparator());
    }

    public List<BlogsStatsUser> getCompanyStatsUsers(long companyId, int start, int end, OrderByComparator<BlogsStatsUser> obc) {
        return this.blogsStatsUserPersistence.findByC_NotE(companyId, 0, start, end, obc);
    }

    public int getCompanyStatsUsersCount(long companyId) {
        return this.blogsStatsUserPersistence.countByC_NotE(companyId, 0);
    }

    public List<BlogsStatsUser> getGroupsStatsUsers(long companyId, long groupId, int start, int end) {
        return this.blogsStatsUserFinder.findByGroupIds(companyId, groupId, start, end);
    }

    public List<BlogsStatsUser> getGroupStatsUsers(long groupId, int start, int end) {
        return this.blogsStatsUserPersistence.findByG_NotE(groupId, 0, start, end, (OrderByComparator)new StatsUserLastPostDateComparator());
    }

    public List<BlogsStatsUser> getGroupStatsUsers(long groupId, int start, int end, OrderByComparator<BlogsStatsUser> obc) {
        return this.blogsStatsUserPersistence.findByG_NotE(groupId, 0, start, end, obc);
    }

    public int getGroupStatsUsersCount(long groupId) {
        return this.blogsStatsUserPersistence.countByG_NotE(groupId, 0);
    }

    public List<BlogsStatsUser> getOrganizationStatsUsers(long organizationId, int start, int end) {
        return this.blogsStatsUserFinder.findByOrganizationId(organizationId, start, end, (OrderByComparator)new StatsUserLastPostDateComparator());
    }

    public List<BlogsStatsUser> getOrganizationStatsUsers(long organizationId, int start, int end, OrderByComparator<BlogsStatsUser> obc) {
        return this.blogsStatsUserFinder.findByOrganizationId(organizationId, start, end, obc);
    }

    public int getOrganizationStatsUsersCount(long organizationId) {
        return this.blogsStatsUserFinder.countByOrganizationId(organizationId);
    }

    public BlogsStatsUser getStatsUser(long groupId, long userId) throws PortalException {
        BlogsStatsUser statsUser = this.blogsStatsUserPersistence.fetchByG_U(groupId, userId);
        if (statsUser == null) {
            Group group = this.groupLocalService.getGroup(groupId);
            long statsUserId = this.counterLocalService.increment();
            statsUser = this.blogsStatsUserPersistence.create(statsUserId);
            statsUser.setGroupId(groupId);
            statsUser.setCompanyId(group.getCompanyId());
            statsUser.setUserId(userId);
            statsUser = (BlogsStatsUser)this.blogsStatsUserPersistence.update((BaseModel)statsUser);
        }
        return statsUser;
    }

    public void updateStatsUser(long groupId, long userId) throws PortalException {
        this.updateStatsUser(groupId, userId, null);
    }

    public void updateStatsUser(long groupId, long userId, Date displayDate) throws PortalException {
        Date now = new Date();
        int entryCount = this.blogsEntryPersistence.countByG_U_LtD_S(groupId, userId, now, 0);
        if (entryCount == 0) {
            block11: {
                try {
                    this.blogsStatsUserPersistence.removeByG_U(groupId, userId);
                }
                catch (NoSuchStatsUserException noSuchStatsUserException) {
                    if (!_log.isWarnEnabled()) break block11;
                    _log.warn((Object)noSuchStatsUserException, (Throwable)noSuchStatsUserException);
                }
            }
            return;
        }
        BlogsStatsUser statsUser = this.getStatsUser(groupId, userId);
        statsUser.setEntryCount(entryCount);
        BlogsEntry blogsEntry = this.blogsEntryPersistence.findByG_U_LtD_S_First(groupId, userId, now, 0, (OrderByComparator)new EntryDisplayDateComparator());
        Date lastDisplayDate = blogsEntry.getDisplayDate();
        Date lastPostDate = statsUser.getLastPostDate();
        if (displayDate != null && displayDate.before(now)) {
            if (lastPostDate == null) {
                statsUser.setLastPostDate(displayDate);
            } else if (displayDate.after(lastPostDate)) {
                statsUser.setLastPostDate(displayDate);
            } else if (lastDisplayDate.before(lastPostDate)) {
                statsUser.setLastPostDate(lastDisplayDate);
            }
        } else if (lastPostDate == null || lastPostDate.before(lastDisplayDate)) {
            statsUser.setLastPostDate(lastDisplayDate);
        }
        this.blogsStatsUserPersistence.update((BaseModel)statsUser);
    }

    public BlogsStatsUser updateStatsUser(long groupId, long userId, int ratingsTotalEntries, double ratingsTotalScore, double ratingsAverageScore) throws PortalException {
        BlogsStatsUser blogsStatsUser = this.getStatsUser(groupId, userId);
        blogsStatsUser.setRatingsTotalEntries(ratingsTotalEntries);
        blogsStatsUser.setRatingsTotalScore(ratingsTotalScore);
        blogsStatsUser.setRatingsAverageScore(ratingsAverageScore);
        return (BlogsStatsUser)this.blogsStatsUserPersistence.update((BaseModel)blogsStatsUser);
    }
}

