/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.blogs.model.impl;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.model.BlogsEntryModel;
import com.liferay.blogs.model.BlogsEntrySoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the BlogsEntry service. Represents a row in the &quot;BlogsEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>BlogsEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BlogsEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see BlogsEntryImpl
 * @generated
 */
@JSON(strict = true)
public class BlogsEntryModelImpl
	extends BaseModelImpl<BlogsEntry> implements BlogsEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a blogs entry model instance should use the <code>BlogsEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "BlogsEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"entryId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"title", Types.VARCHAR},
		{"subtitle", Types.VARCHAR}, {"urlTitle", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"content", Types.CLOB},
		{"displayDate", Types.TIMESTAMP}, {"allowPingbacks", Types.BOOLEAN},
		{"allowTrackbacks", Types.BOOLEAN}, {"trackbacks", Types.CLOB},
		{"coverImageCaption", Types.VARCHAR},
		{"coverImageFileEntryId", Types.BIGINT},
		{"coverImageURL", Types.VARCHAR}, {"smallImage", Types.BOOLEAN},
		{"smallImageFileEntryId", Types.BIGINT}, {"smallImageId", Types.BIGINT},
		{"smallImageURL", Types.VARCHAR}, {"lastPublishDate", Types.TIMESTAMP},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("entryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("subtitle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("urlTitle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("content", Types.CLOB);
		TABLE_COLUMNS_MAP.put("displayDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("allowPingbacks", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("allowTrackbacks", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("trackbacks", Types.CLOB);
		TABLE_COLUMNS_MAP.put("coverImageCaption", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("coverImageFileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("coverImageURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("smallImage", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("smallImageFileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("smallImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("smallImageURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table BlogsEntry (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,entryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,title VARCHAR(150) null,subtitle STRING null,urlTitle VARCHAR(255) null,description STRING null,content TEXT null,displayDate DATE null,allowPingbacks BOOLEAN,allowTrackbacks BOOLEAN,trackbacks TEXT null,coverImageCaption STRING null,coverImageFileEntryId LONG,coverImageURL STRING null,smallImage BOOLEAN,smallImageFileEntryId LONG,smallImageId LONG,smallImageURL STRING null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table BlogsEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY blogsEntry.displayDate DESC, blogsEntry.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY BlogsEntry.displayDate DESC, BlogsEntry.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	public static final long DISPLAYDATE_COLUMN_BITMASK = 2L;

	public static final long GROUPID_COLUMN_BITMASK = 4L;

	public static final long STATUS_COLUMN_BITMASK = 8L;

	public static final long URLTITLE_COLUMN_BITMASK = 16L;

	public static final long USERID_COLUMN_BITMASK = 32L;

	public static final long UUID_COLUMN_BITMASK = 64L;

	public static final long CREATEDATE_COLUMN_BITMASK = 128L;

	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
		_entityCacheEnabled = entityCacheEnabled;
	}

	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
		_finderCacheEnabled = finderCacheEnabled;
	}

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static BlogsEntry toModel(BlogsEntrySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		BlogsEntry model = new BlogsEntryImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setUuid(soapModel.getUuid());
		model.setEntryId(soapModel.getEntryId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setTitle(soapModel.getTitle());
		model.setSubtitle(soapModel.getSubtitle());
		model.setUrlTitle(soapModel.getUrlTitle());
		model.setDescription(soapModel.getDescription());
		model.setContent(soapModel.getContent());
		model.setDisplayDate(soapModel.getDisplayDate());
		model.setAllowPingbacks(soapModel.isAllowPingbacks());
		model.setAllowTrackbacks(soapModel.isAllowTrackbacks());
		model.setTrackbacks(soapModel.getTrackbacks());
		model.setCoverImageCaption(soapModel.getCoverImageCaption());
		model.setCoverImageFileEntryId(soapModel.getCoverImageFileEntryId());
		model.setCoverImageURL(soapModel.getCoverImageURL());
		model.setSmallImage(soapModel.isSmallImage());
		model.setSmallImageFileEntryId(soapModel.getSmallImageFileEntryId());
		model.setSmallImageId(soapModel.getSmallImageId());
		model.setSmallImageURL(soapModel.getSmallImageURL());
		model.setLastPublishDate(soapModel.getLastPublishDate());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<BlogsEntry> toModels(BlogsEntrySoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<BlogsEntry> models = new ArrayList<BlogsEntry>(soapModels.length);

		for (BlogsEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public BlogsEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _entryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _entryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return BlogsEntry.class;
	}

	@Override
	public String getModelClassName() {
		return BlogsEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<BlogsEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<BlogsEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<BlogsEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((BlogsEntry)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<BlogsEntry, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<BlogsEntry, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(BlogsEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<BlogsEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<BlogsEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<BlogsEntry, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<BlogsEntry, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<BlogsEntry, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<BlogsEntry, Object>>();
		Map<String, BiConsumer<BlogsEntry, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<BlogsEntry, ?>>();

		attributeGetterFunctions.put("mvccVersion", BlogsEntry::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<BlogsEntry, Long>)BlogsEntry::setMvccVersion);
		attributeGetterFunctions.put("uuid", BlogsEntry::getUuid);
		attributeSetterBiConsumers.put(
			"uuid", (BiConsumer<BlogsEntry, String>)BlogsEntry::setUuid);
		attributeGetterFunctions.put("entryId", BlogsEntry::getEntryId);
		attributeSetterBiConsumers.put(
			"entryId", (BiConsumer<BlogsEntry, Long>)BlogsEntry::setEntryId);
		attributeGetterFunctions.put("groupId", BlogsEntry::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId", (BiConsumer<BlogsEntry, Long>)BlogsEntry::setGroupId);
		attributeGetterFunctions.put("companyId", BlogsEntry::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<BlogsEntry, Long>)BlogsEntry::setCompanyId);
		attributeGetterFunctions.put("userId", BlogsEntry::getUserId);
		attributeSetterBiConsumers.put(
			"userId", (BiConsumer<BlogsEntry, Long>)BlogsEntry::setUserId);
		attributeGetterFunctions.put("userName", BlogsEntry::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<BlogsEntry, String>)BlogsEntry::setUserName);
		attributeGetterFunctions.put("createDate", BlogsEntry::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<BlogsEntry, Date>)BlogsEntry::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", BlogsEntry::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<BlogsEntry, Date>)BlogsEntry::setModifiedDate);
		attributeGetterFunctions.put("title", BlogsEntry::getTitle);
		attributeSetterBiConsumers.put(
			"title", (BiConsumer<BlogsEntry, String>)BlogsEntry::setTitle);
		attributeGetterFunctions.put("subtitle", BlogsEntry::getSubtitle);
		attributeSetterBiConsumers.put(
			"subtitle",
			(BiConsumer<BlogsEntry, String>)BlogsEntry::setSubtitle);
		attributeGetterFunctions.put("urlTitle", BlogsEntry::getUrlTitle);
		attributeSetterBiConsumers.put(
			"urlTitle",
			(BiConsumer<BlogsEntry, String>)BlogsEntry::setUrlTitle);
		attributeGetterFunctions.put("description", BlogsEntry::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<BlogsEntry, String>)BlogsEntry::setDescription);
		attributeGetterFunctions.put("content", BlogsEntry::getContent);
		attributeSetterBiConsumers.put(
			"content", (BiConsumer<BlogsEntry, String>)BlogsEntry::setContent);
		attributeGetterFunctions.put("displayDate", BlogsEntry::getDisplayDate);
		attributeSetterBiConsumers.put(
			"displayDate",
			(BiConsumer<BlogsEntry, Date>)BlogsEntry::setDisplayDate);
		attributeGetterFunctions.put(
			"allowPingbacks", BlogsEntry::getAllowPingbacks);
		attributeSetterBiConsumers.put(
			"allowPingbacks",
			(BiConsumer<BlogsEntry, Boolean>)BlogsEntry::setAllowPingbacks);
		attributeGetterFunctions.put(
			"allowTrackbacks", BlogsEntry::getAllowTrackbacks);
		attributeSetterBiConsumers.put(
			"allowTrackbacks",
			(BiConsumer<BlogsEntry, Boolean>)BlogsEntry::setAllowTrackbacks);
		attributeGetterFunctions.put("trackbacks", BlogsEntry::getTrackbacks);
		attributeSetterBiConsumers.put(
			"trackbacks",
			(BiConsumer<BlogsEntry, String>)BlogsEntry::setTrackbacks);
		attributeGetterFunctions.put(
			"coverImageCaption", BlogsEntry::getCoverImageCaption);
		attributeSetterBiConsumers.put(
			"coverImageCaption",
			(BiConsumer<BlogsEntry, String>)BlogsEntry::setCoverImageCaption);
		attributeGetterFunctions.put(
			"coverImageFileEntryId", BlogsEntry::getCoverImageFileEntryId);
		attributeSetterBiConsumers.put(
			"coverImageFileEntryId",
			(BiConsumer<BlogsEntry, Long>)BlogsEntry::setCoverImageFileEntryId);
		attributeGetterFunctions.put(
			"coverImageURL", BlogsEntry::getCoverImageURL);
		attributeSetterBiConsumers.put(
			"coverImageURL",
			(BiConsumer<BlogsEntry, String>)BlogsEntry::setCoverImageURL);
		attributeGetterFunctions.put("smallImage", BlogsEntry::getSmallImage);
		attributeSetterBiConsumers.put(
			"smallImage",
			(BiConsumer<BlogsEntry, Boolean>)BlogsEntry::setSmallImage);
		attributeGetterFunctions.put(
			"smallImageFileEntryId", BlogsEntry::getSmallImageFileEntryId);
		attributeSetterBiConsumers.put(
			"smallImageFileEntryId",
			(BiConsumer<BlogsEntry, Long>)BlogsEntry::setSmallImageFileEntryId);
		attributeGetterFunctions.put(
			"smallImageId", BlogsEntry::getSmallImageId);
		attributeSetterBiConsumers.put(
			"smallImageId",
			(BiConsumer<BlogsEntry, Long>)BlogsEntry::setSmallImageId);
		attributeGetterFunctions.put(
			"smallImageURL", BlogsEntry::getSmallImageURL);
		attributeSetterBiConsumers.put(
			"smallImageURL",
			(BiConsumer<BlogsEntry, String>)BlogsEntry::setSmallImageURL);
		attributeGetterFunctions.put(
			"lastPublishDate", BlogsEntry::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<BlogsEntry, Date>)BlogsEntry::setLastPublishDate);
		attributeGetterFunctions.put("status", BlogsEntry::getStatus);
		attributeSetterBiConsumers.put(
			"status", (BiConsumer<BlogsEntry, Integer>)BlogsEntry::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", BlogsEntry::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<BlogsEntry, Long>)BlogsEntry::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", BlogsEntry::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<BlogsEntry, String>)BlogsEntry::setStatusByUserName);
		attributeGetterFunctions.put("statusDate", BlogsEntry::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<BlogsEntry, Date>)BlogsEntry::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public long getEntryId() {
		return _entryId;
	}

	@Override
	public void setEntryId(long entryId) {
		_entryId = entryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public void setTitle(String title) {
		_title = title;
	}

	@JSON
	@Override
	public String getSubtitle() {
		if (_subtitle == null) {
			return "";
		}
		else {
			return _subtitle;
		}
	}

	@Override
	public void setSubtitle(String subtitle) {
		_subtitle = subtitle;
	}

	@JSON
	@Override
	public String getUrlTitle() {
		if (_urlTitle == null) {
			return "";
		}
		else {
			return _urlTitle;
		}
	}

	@Override
	public void setUrlTitle(String urlTitle) {
		_columnBitmask |= URLTITLE_COLUMN_BITMASK;

		if (_originalUrlTitle == null) {
			_originalUrlTitle = _urlTitle;
		}

		_urlTitle = urlTitle;
	}

	public String getOriginalUrlTitle() {
		return GetterUtil.getString(_originalUrlTitle);
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		_description = description;
	}

	@JSON
	@Override
	public String getContent() {
		if (_content == null) {
			return "";
		}
		else {
			return _content;
		}
	}

	@Override
	public void setContent(String content) {
		_content = content;
	}

	@JSON
	@Override
	public Date getDisplayDate() {
		return _displayDate;
	}

	@Override
	public void setDisplayDate(Date displayDate) {
		_columnBitmask = -1L;

		if (_originalDisplayDate == null) {
			_originalDisplayDate = _displayDate;
		}

		_displayDate = displayDate;
	}

	public Date getOriginalDisplayDate() {
		return _originalDisplayDate;
	}

	@JSON
	@Override
	public boolean getAllowPingbacks() {
		return _allowPingbacks;
	}

	@JSON
	@Override
	public boolean isAllowPingbacks() {
		return _allowPingbacks;
	}

	@Override
	public void setAllowPingbacks(boolean allowPingbacks) {
		_allowPingbacks = allowPingbacks;
	}

	@JSON
	@Override
	public boolean getAllowTrackbacks() {
		return _allowTrackbacks;
	}

	@JSON
	@Override
	public boolean isAllowTrackbacks() {
		return _allowTrackbacks;
	}

	@Override
	public void setAllowTrackbacks(boolean allowTrackbacks) {
		_allowTrackbacks = allowTrackbacks;
	}

	@JSON
	@Override
	public String getTrackbacks() {
		if (_trackbacks == null) {
			return "";
		}
		else {
			return _trackbacks;
		}
	}

	@Override
	public void setTrackbacks(String trackbacks) {
		_trackbacks = trackbacks;
	}

	@JSON
	@Override
	public String getCoverImageCaption() {
		if (_coverImageCaption == null) {
			return "";
		}
		else {
			return _coverImageCaption;
		}
	}

	@Override
	public void setCoverImageCaption(String coverImageCaption) {
		_coverImageCaption = coverImageCaption;
	}

	@JSON
	@Override
	public long getCoverImageFileEntryId() {
		return _coverImageFileEntryId;
	}

	@Override
	public void setCoverImageFileEntryId(long coverImageFileEntryId) {
		_coverImageFileEntryId = coverImageFileEntryId;
	}

	@JSON
	@Override
	public String getCoverImageURL() {
		if (_coverImageURL == null) {
			return "";
		}
		else {
			return _coverImageURL;
		}
	}

	@Override
	public void setCoverImageURL(String coverImageURL) {
		_coverImageURL = coverImageURL;
	}

	@JSON
	@Override
	public boolean getSmallImage() {
		return _smallImage;
	}

	@JSON
	@Override
	public boolean isSmallImage() {
		return _smallImage;
	}

	@Override
	public void setSmallImage(boolean smallImage) {
		_smallImage = smallImage;
	}

	@JSON
	@Override
	public long getSmallImageFileEntryId() {
		return _smallImageFileEntryId;
	}

	@Override
	public void setSmallImageFileEntryId(long smallImageFileEntryId) {
		_smallImageFileEntryId = smallImageFileEntryId;
	}

	@JSON
	@Override
	public long getSmallImageId() {
		return _smallImageId;
	}

	@Override
	public void setSmallImageId(long smallImageId) {
		_smallImageId = smallImageId;
	}

	@JSON
	@Override
	public String getSmallImageURL() {
		if (_smallImageURL == null) {
			return "";
		}
		else {
			return _smallImageURL;
		}
	}

	@Override
	public void setSmallImageURL(String smallImageURL) {
		_smallImageURL = smallImageURL;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		_columnBitmask |= STATUS_COLUMN_BITMASK;

		if (!_setOriginalStatus) {
			_setOriginalStatus = true;

			_originalStatus = _status;
		}

		_status = status;
	}

	public int getOriginalStatus() {
		return _originalStatus;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(BlogsEntry.class.getName()));
	}

	@Override
	public com.liferay.trash.kernel.model.TrashEntry getTrashEntry()
		throws PortalException {

		if (!isInTrash()) {
			return null;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return trashEntry;
		}

		com.liferay.portal.kernel.trash.TrashHandler trashHandler =
			getTrashHandler();

		if (Validator.isNotNull(
				trashHandler.getContainerModelClassName(getPrimaryKey()))) {

			ContainerModel containerModel = null;

			try {
				containerModel = trashHandler.getParentContainerModel(this);
			}
			catch (NoSuchModelException noSuchModelException) {
				return null;
			}

			while (containerModel != null) {
				if (containerModel instanceof TrashedModel) {
					TrashedModel trashedModel = (TrashedModel)containerModel;

					return trashedModel.getTrashEntry();
				}

				trashHandler =
					com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
						getTrashHandler(
							trashHandler.getContainerModelClassName(
								containerModel.getContainerModelId()));

				if (trashHandler == null) {
					return null;
				}

				containerModel = trashHandler.getContainerModel(
					containerModel.getParentContainerModelId());
			}
		}

		return null;
	}

	@Override
	public long getTrashEntryClassPK() {
		return getPrimaryKey();
	}

	/**
	 * @deprecated As of Judson (7.1.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public com.liferay.portal.kernel.trash.TrashHandler getTrashHandler() {
		return com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
			getTrashHandler(getModelClassName());
	}

	@Override
	public boolean isInTrash() {
		if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInTrashContainer() {
		com.liferay.portal.kernel.trash.TrashHandler trashHandler =
			getTrashHandler();

		if ((trashHandler == null) ||
			Validator.isNull(
				trashHandler.getContainerModelClassName(getPrimaryKey()))) {

			return false;
		}

		try {
			ContainerModel containerModel =
				trashHandler.getParentContainerModel(this);

			if (containerModel == null) {
				return false;
			}

			if (containerModel instanceof TrashedModel) {
				return ((TrashedModel)containerModel).isInTrash();
			}
		}
		catch (Exception exception) {
		}

		return false;
	}

	@Override
	public boolean isInTrashExplicitly() {
		if (!isInTrash()) {
			return false;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return true;
		}

		return false;
	}

	@Override
	public boolean isInTrashImplicitly() {
		if (!isInTrash()) {
			return false;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return false;
		}

		return true;
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), BlogsEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public BlogsEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, BlogsEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		BlogsEntryImpl blogsEntryImpl = new BlogsEntryImpl();

		blogsEntryImpl.setMvccVersion(getMvccVersion());
		blogsEntryImpl.setUuid(getUuid());
		blogsEntryImpl.setEntryId(getEntryId());
		blogsEntryImpl.setGroupId(getGroupId());
		blogsEntryImpl.setCompanyId(getCompanyId());
		blogsEntryImpl.setUserId(getUserId());
		blogsEntryImpl.setUserName(getUserName());
		blogsEntryImpl.setCreateDate(getCreateDate());
		blogsEntryImpl.setModifiedDate(getModifiedDate());
		blogsEntryImpl.setTitle(getTitle());
		blogsEntryImpl.setSubtitle(getSubtitle());
		blogsEntryImpl.setUrlTitle(getUrlTitle());
		blogsEntryImpl.setDescription(getDescription());
		blogsEntryImpl.setContent(getContent());
		blogsEntryImpl.setDisplayDate(getDisplayDate());
		blogsEntryImpl.setAllowPingbacks(isAllowPingbacks());
		blogsEntryImpl.setAllowTrackbacks(isAllowTrackbacks());
		blogsEntryImpl.setTrackbacks(getTrackbacks());
		blogsEntryImpl.setCoverImageCaption(getCoverImageCaption());
		blogsEntryImpl.setCoverImageFileEntryId(getCoverImageFileEntryId());
		blogsEntryImpl.setCoverImageURL(getCoverImageURL());
		blogsEntryImpl.setSmallImage(isSmallImage());
		blogsEntryImpl.setSmallImageFileEntryId(getSmallImageFileEntryId());
		blogsEntryImpl.setSmallImageId(getSmallImageId());
		blogsEntryImpl.setSmallImageURL(getSmallImageURL());
		blogsEntryImpl.setLastPublishDate(getLastPublishDate());
		blogsEntryImpl.setStatus(getStatus());
		blogsEntryImpl.setStatusByUserId(getStatusByUserId());
		blogsEntryImpl.setStatusByUserName(getStatusByUserName());
		blogsEntryImpl.setStatusDate(getStatusDate());

		blogsEntryImpl.resetOriginalValues();

		return blogsEntryImpl;
	}

	@Override
	public int compareTo(BlogsEntry blogsEntry) {
		int value = 0;

		value = DateUtil.compareTo(
			getDisplayDate(), blogsEntry.getDisplayDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		value = DateUtil.compareTo(getCreateDate(), blogsEntry.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof BlogsEntry)) {
			return false;
		}

		BlogsEntry blogsEntry = (BlogsEntry)object;

		long primaryKey = blogsEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return _entityCacheEnabled;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return _finderCacheEnabled;
	}

	@Override
	public void resetOriginalValues() {
		_originalUuid = _uuid;

		_originalGroupId = _groupId;

		_setOriginalGroupId = false;

		_originalCompanyId = _companyId;

		_setOriginalCompanyId = false;

		_originalUserId = _userId;

		_setOriginalUserId = false;

		_setModifiedDate = false;

		_originalUrlTitle = _urlTitle;

		_originalDisplayDate = _displayDate;

		_originalStatus = _status;

		_setOriginalStatus = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<BlogsEntry> toCacheModel() {
		BlogsEntryCacheModel blogsEntryCacheModel = new BlogsEntryCacheModel();

		blogsEntryCacheModel.mvccVersion = getMvccVersion();

		blogsEntryCacheModel.uuid = getUuid();

		String uuid = blogsEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			blogsEntryCacheModel.uuid = null;
		}

		blogsEntryCacheModel.entryId = getEntryId();

		blogsEntryCacheModel.groupId = getGroupId();

		blogsEntryCacheModel.companyId = getCompanyId();

		blogsEntryCacheModel.userId = getUserId();

		blogsEntryCacheModel.userName = getUserName();

		String userName = blogsEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			blogsEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			blogsEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			blogsEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			blogsEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			blogsEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		blogsEntryCacheModel.title = getTitle();

		String title = blogsEntryCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			blogsEntryCacheModel.title = null;
		}

		blogsEntryCacheModel.subtitle = getSubtitle();

		String subtitle = blogsEntryCacheModel.subtitle;

		if ((subtitle != null) && (subtitle.length() == 0)) {
			blogsEntryCacheModel.subtitle = null;
		}

		blogsEntryCacheModel.urlTitle = getUrlTitle();

		String urlTitle = blogsEntryCacheModel.urlTitle;

		if ((urlTitle != null) && (urlTitle.length() == 0)) {
			blogsEntryCacheModel.urlTitle = null;
		}

		blogsEntryCacheModel.description = getDescription();

		String description = blogsEntryCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			blogsEntryCacheModel.description = null;
		}

		blogsEntryCacheModel.content = getContent();

		String content = blogsEntryCacheModel.content;

		if ((content != null) && (content.length() == 0)) {
			blogsEntryCacheModel.content = null;
		}

		Date displayDate = getDisplayDate();

		if (displayDate != null) {
			blogsEntryCacheModel.displayDate = displayDate.getTime();
		}
		else {
			blogsEntryCacheModel.displayDate = Long.MIN_VALUE;
		}

		blogsEntryCacheModel.allowPingbacks = isAllowPingbacks();

		blogsEntryCacheModel.allowTrackbacks = isAllowTrackbacks();

		blogsEntryCacheModel.trackbacks = getTrackbacks();

		String trackbacks = blogsEntryCacheModel.trackbacks;

		if ((trackbacks != null) && (trackbacks.length() == 0)) {
			blogsEntryCacheModel.trackbacks = null;
		}

		blogsEntryCacheModel.coverImageCaption = getCoverImageCaption();

		String coverImageCaption = blogsEntryCacheModel.coverImageCaption;

		if ((coverImageCaption != null) && (coverImageCaption.length() == 0)) {
			blogsEntryCacheModel.coverImageCaption = null;
		}

		blogsEntryCacheModel.coverImageFileEntryId = getCoverImageFileEntryId();

		blogsEntryCacheModel.coverImageURL = getCoverImageURL();

		String coverImageURL = blogsEntryCacheModel.coverImageURL;

		if ((coverImageURL != null) && (coverImageURL.length() == 0)) {
			blogsEntryCacheModel.coverImageURL = null;
		}

		blogsEntryCacheModel.smallImage = isSmallImage();

		blogsEntryCacheModel.smallImageFileEntryId = getSmallImageFileEntryId();

		blogsEntryCacheModel.smallImageId = getSmallImageId();

		blogsEntryCacheModel.smallImageURL = getSmallImageURL();

		String smallImageURL = blogsEntryCacheModel.smallImageURL;

		if ((smallImageURL != null) && (smallImageURL.length() == 0)) {
			blogsEntryCacheModel.smallImageURL = null;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			blogsEntryCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			blogsEntryCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		blogsEntryCacheModel.status = getStatus();

		blogsEntryCacheModel.statusByUserId = getStatusByUserId();

		blogsEntryCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = blogsEntryCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			blogsEntryCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			blogsEntryCacheModel.statusDate = statusDate.getTime();
		}
		else {
			blogsEntryCacheModel.statusDate = Long.MIN_VALUE;
		}

		return blogsEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<BlogsEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<BlogsEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<BlogsEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((BlogsEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<BlogsEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<BlogsEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<BlogsEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((BlogsEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, BlogsEntry>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					BlogsEntry.class, ModelWrapper.class);

	}

	private static boolean _entityCacheEnabled;
	private static boolean _finderCacheEnabled;

	private long _mvccVersion;
	private String _uuid;
	private String _originalUuid;
	private long _entryId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _title;
	private String _subtitle;
	private String _urlTitle;
	private String _originalUrlTitle;
	private String _description;
	private String _content;
	private Date _displayDate;
	private Date _originalDisplayDate;
	private boolean _allowPingbacks;
	private boolean _allowTrackbacks;
	private String _trackbacks;
	private String _coverImageCaption;
	private long _coverImageFileEntryId;
	private String _coverImageURL;
	private boolean _smallImage;
	private long _smallImageFileEntryId;
	private long _smallImageId;
	private String _smallImageURL;
	private Date _lastPublishDate;
	private int _status;
	private int _originalStatus;
	private boolean _setOriginalStatus;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;
	private long _columnBitmask;
	private BlogsEntry _escapedModel;

}