/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.blogs.internal.security.permission;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.portal.kernel.security.permission.PermissionUpdateHandler;
import com.liferay.portal.kernel.util.GetterUtil;

import java.util.Date;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Gergely Mathe
 */
@Component(
	property = "model.class.name=com.liferay.blogs.model.BlogsEntry",
	service = PermissionUpdateHandler.class
)
public class BlogsEntryPermissionUpdateHandler
	implements PermissionUpdateHandler {

	@Override
	public void updatedPermission(String primKey) {
		BlogsEntry blogsEntry = _blogsEntryLocalService.fetchBlogsEntry(
			GetterUtil.getLong(primKey));

		if (blogsEntry == null) {
			return;
		}

		blogsEntry.setModifiedDate(new Date());

		_blogsEntryLocalService.updateBlogsEntry(blogsEntry);
	}

	@Reference
	private BlogsEntryLocalService _blogsEntryLocalService;

}