/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.blogs.internal.model.listener;

import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;

import java.util.List;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Marcell Gyöpös
 */
@Component(immediate = true, service = ModelListener.class)
public class UserGroupModelListener extends BaseModelListener<UserGroup> {

	@Override
	public void onAfterRemoveAssociation(
			Object userGroupId, String associationClassName,
			Object associationClassPK)
		throws ModelListenerException {

		try {
			if (associationClassName.equals(User.class.getName())) {
				_unsubscribeUserFromUserGroupGroups(
					(long)associationClassPK, (long)userGroupId);
			}
		}
		catch (PortalException portalException) {
			throw new ModelListenerException(portalException);
		}

		try {
			if (associationClassName.equals(Group.class.getName())) {
				_unsubscribeUserGroupUsersFromGroup(
					(long)associationClassPK, (long)userGroupId);
			}
		}
		catch (PortalException portalException) {
			throw new ModelListenerException(portalException);
		}
	}

	private void _unsubscribeUserFromUserGroupGroups(
			long userId, long userGroupId)
		throws PortalException {

		List<Group> userGroupGroups = _groupLocalService.getUserGroupGroups(
			userGroupId);

		userGroupGroups.removeAll(
			_groupLocalService.getUserGroups(userId, true));

		for (Group group : userGroupGroups) {
			_blogsEntryLocalService.unsubscribe(userId, group.getGroupId());
		}
	}

	private void _unsubscribeUserGroupUsersFromGroup(
			long groupId, long userGroupId)
		throws PortalException {

		for (long userId :
				_userGroupLocalService.getUserPrimaryKeys(userGroupId)) {

			if (!_groupLocalService.hasUserGroup(userId, groupId)) {
				_blogsEntryLocalService.unsubscribe(userId, groupId);
			}
		}
	}

	@Reference
	private BlogsEntryLocalService _blogsEntryLocalService;

	@Reference
	private GroupLocalService _groupLocalService;

	@Reference
	private UserGroupLocalService _userGroupLocalService;

}