/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.verify;

import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.verify.VerifyProcess;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.blogs.service"}, service={VerifyProcess.class})
public class BlogsServiceVerifyProcess
extends VerifyProcess {
    private GroupLocalService _groupLocalService;
    @Reference
    private Staging _staging;

    protected void doVerify() throws Exception {
        this.updateStagedPortletNames();
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    protected void updateStagedPortletNames() throws PortalException {
        ActionableDynamicQuery groupActionableDynamicQuery = this._groupLocalService.getActionableDynamicQuery();
        groupActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property siteProperty = PropertyFactoryUtil.forName((String)"site");
            dynamicQuery.add(siteProperty.eq((Object)Boolean.TRUE));
        });
        groupActionableDynamicQuery.setPerformActionMethod(group -> {
            UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
            if (typeSettingsProperties == null) {
                return;
            }
            String propertyKey = this._staging.getStagedPortletId("com_liferay_blogs_web_portlet_BlogsPortlet");
            String propertyValue = typeSettingsProperties.getProperty(propertyKey);
            if (Validator.isNull((String)propertyValue)) {
                return;
            }
            typeSettingsProperties.remove((Object)propertyKey);
            propertyKey = this._staging.getStagedPortletId("com_liferay_blogs_web_portlet_BlogsAdminPortlet");
            typeSettingsProperties.put(propertyKey, propertyValue);
            group.setTypeSettingsProperties(typeSettingsProperties);
            this._groupLocalService.updateGroup(group);
        });
        groupActionableDynamicQuery.performActions();
    }
}

