/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.util;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.DuplicateCommentException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperThreadLocal;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.IdentityServiceContextFunction;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xmlrpc.Method;
import com.liferay.portal.kernel.xmlrpc.Response;
import com.liferay.portal.kernel.xmlrpc.XmlRpcUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.TextExtractor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Method.class})
public class PingbackMethodImpl
implements Method {
    public static final int ACCESS_DENIED = 49;
    public static final int GENERIC_FAULT = 0;
    public static final int PINGBACK_ALREADY_REGISTERED = 48;
    public static final int SERVER_ERROR = 50;
    public static final int SOURCE_URI_DOES_NOT_EXIST = 16;
    public static final int SOURCE_URI_INVALID = 17;
    public static final int TARGET_URI_DOES_NOT_EXIST = 32;
    public static final int TARGET_URI_INVALID = 33;
    private static final Log _log = LogFactoryUtil.getLog(PingbackMethodImpl.class);
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;
    private PortletLocalService _portletLocalService;
    private String _sourceURI;
    private String _targetURI;
    private UserLocalService _userLocalService;

    public Response execute(long companyId) {
        try {
            Response response = this.addPingback(companyId);
            if (response != null) {
                return response;
            }
            return XmlRpcUtil.createSuccess((String)"Pingback accepted");
        }
        catch (DuplicateCommentException dce) {
            return XmlRpcUtil.createFault((int)48, (String)("Pingback is already registered: " + dce.getMessage()));
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return XmlRpcUtil.createFault((int)33, (String)"Unable to parse target URI");
        }
    }

    public String getMethodName() {
        return "pingback.ping";
    }

    public String getToken() {
        return "pingback";
    }

    public boolean setArguments(Object[] arguments) {
        try {
            this._sourceURI = (String)arguments[0];
            this._targetURI = (String)arguments[1];
            return true;
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return false;
        }
    }

    protected Response addPingback(long companyId) throws Exception {
        if (!PropsValues.BLOGS_PINGBACK_ENABLED) {
            return XmlRpcUtil.createFault((int)-32601, (String)"Pingbacks are disabled");
        }
        BlogsEntry entry = this.getBlogsEntry(companyId);
        if (!entry.isAllowPingbacks() || Validator.isNull((String)entry.getUrlTitle())) {
            return XmlRpcUtil.createFault((int)-32601, (String)"Pingbacks are disabled");
        }
        Response response = this.validateSource();
        if (response != null) {
            return response;
        }
        long userId = this._userLocalService.getDefaultUserId(companyId);
        long groupId = entry.getGroupId();
        String className = BlogsEntry.class.getName();
        long classPK = entry.getEntryId();
        String body = StringBundler.concat((String[])new String[]{"[...] ", this.getExcerpt(), " [...] <a href=", this._sourceURI, ">", LanguageUtil.get((Locale)LocaleUtil.getSiteDefault(), (String)"read-more"), "</a>"});
        ServiceContext serviceContext = this.buildServiceContext(companyId, groupId, entry.getUrlTitle());
        this._commentManager.addComment(userId, groupId, className, classPK, body, (Function)new IdentityServiceContextFunction(serviceContext));
        return null;
    }

    protected ServiceContext buildServiceContext(long companyId, long groupId, String urlTitle) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        String pingbackUserName = LanguageUtil.get((Locale)LocaleUtil.getSiteDefault(), (String)"pingback");
        serviceContext.setAttribute("pingbackUserName", (Serializable)((Object)pingbackUserName));
        String portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        if (Validator.isNull((String)portletId)) {
            return serviceContext;
        }
        StringBundler sb = new StringBundler(5);
        String layoutFullURL = this._portal.getLayoutFullURL(groupId, portletId);
        sb.append(layoutFullURL);
        sb.append("/-/");
        Portlet portlet = this._portletLocalService.getPortletById(companyId, portletId);
        sb.append(portlet.getFriendlyURLMapping());
        sb.append("/");
        sb.append(urlTitle);
        serviceContext.setAttribute("redirect", (Serializable)((Object)sb.toString()));
        serviceContext.setLayoutFullURL(layoutFullURL);
        return serviceContext;
    }

    protected BlogsEntry getBlogsEntry(long companyId) throws Exception {
        BlogsEntry entry = null;
        URL url = new URL(this._targetURI);
        String friendlyURL = url.getPath();
        int end = friendlyURL.indexOf("/-/");
        if (end != -1) {
            friendlyURL = friendlyURL.substring(0, end);
        }
        long plid = this._portal.getPlidFromFriendlyURL(companyId, friendlyURL);
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        FriendlyURLMapperThreadLocal.setPRPIdentifiers(new HashMap());
        String portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        Portlet portlet = this._portletLocalService.getPortletById(portletId);
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        friendlyURL = url.getPath();
        end = friendlyURL.indexOf("/-/");
        if (end != -1) {
            friendlyURL = friendlyURL.substring(end + "/-/".length() - 1);
        }
        HashMap requestContext = new HashMap();
        friendlyURLMapper.populateParams(friendlyURL, params, requestContext);
        String param = this.getParam(params, "entryId");
        if (Validator.isNotNull((String)param)) {
            long entryId = GetterUtil.getLong((String)param);
            entry = this._blogsEntryLocalService.getEntry(entryId);
        } else {
            long groupId = this._portal.getScopeGroupId(plid);
            String urlTitle = this.getParam(params, "urlTitle");
            entry = this._blogsEntryLocalService.getEntry(groupId, urlTitle);
        }
        return entry;
    }

    protected String getExcerpt() throws IOException {
        String html = this._http.URLtoString(this._sourceURI);
        Source source = new Source((CharSequence)html);
        source.fullSequentialParse();
        List elements = source.getAllElements("a");
        for (Element element : elements) {
            String href = GetterUtil.getString((String)element.getAttributeValue("href"));
            if (!href.equals(this._targetURI)) continue;
            TextExtractor textExtractor = new TextExtractor((Segment)(element = element.getParentElement()));
            String body = textExtractor.toString();
            if (body.length() < PropsValues.BLOGS_LINKBACK_EXCERPT_LENGTH && (element = element.getParentElement()) != null) {
                textExtractor = new TextExtractor((Segment)element);
                body = textExtractor.toString();
            }
            return StringUtil.shorten((String)body, (int)PropsValues.BLOGS_LINKBACK_EXCERPT_LENGTH);
        }
        return "";
    }

    protected String getParam(Map<String, String[]> params, String name) {
        Object[] paramArray = params.get(name);
        if (paramArray == null) {
            String portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
            String namespace = this._portal.getPortletNamespace(portletId);
            paramArray = params.get(namespace + name);
        }
        if (ArrayUtil.isNotEmpty((Object[])paramArray)) {
            return paramArray[0];
        }
        return null;
    }

    @Reference(unbind="-")
    protected void setBlogsEntryLocalService(BlogsEntryLocalService blogsEntryLocalService) {
        this._blogsEntryLocalService = blogsEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this._portletLocalService = portletLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected Response validateSource() throws Exception {
        if (this._isSourceURILocalNetwork()) {
            return XmlRpcUtil.createFault((int)49, (String)"Access Denied");
        }
        Source source = null;
        try {
            String html = this._http.URLtoString(this._sourceURI);
            source = new Source((CharSequence)html);
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return XmlRpcUtil.createFault((int)16, (String)"Error accessing source URI");
        }
        List startTags = source.getAllStartTags("a");
        for (StartTag startTag : startTags) {
            String href = GetterUtil.getString((String)startTag.getAttributeValue("href"));
            if (!href.equals(this._targetURI)) continue;
            return null;
        }
        return XmlRpcUtil.createFault((int)17, (String)"Unable to find target URI in source");
    }

    private boolean _isSourceURILocalNetwork() {
        try {
            URL url = new URL(this._sourceURI);
            return InetAddressUtil.isLocalInetAddress((InetAddress)InetAddressUtil.getInetAddressByName((String)url.getHost()));
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return true;
        }
    }
}

