/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.util;

import com.liferay.blogs.internal.util.BlogsEntryAttachmentFileEntryReferenceAdapter;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portlet.blogs.BlogsEntryAttachmentFileEntryReference;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlogsEntryAttachmentFileEntryUtil {
    private static final int _UNIQUE_FILE_NAME_TRIES = 50;
    private static final Log _log = LogFactoryUtil.getLog(BlogsEntryAttachmentFileEntryUtil.class);

    public static List<BlogsEntryAttachmentFileEntryReference> addBlogsEntryAttachmentFileEntries(long groupId, long userId, long blogsEntryId, long folderId, List<FileEntry> tempFileEntries) throws PortalException {
        ArrayList<BlogsEntryAttachmentFileEntryReference> blogsEntryAttachmentFileEntryReferences = new ArrayList<BlogsEntryAttachmentFileEntryReference>();
        for (FileEntry tempFileEntry : tempFileEntries) {
            FileEntry blogsEntryAttachmentFileEntry = BlogsEntryAttachmentFileEntryUtil.addBlogsEntryAttachmentFileEntry(groupId, userId, blogsEntryId, folderId, tempFileEntry.getTitle(), tempFileEntry.getMimeType(), tempFileEntry.getContentStream());
            blogsEntryAttachmentFileEntryReferences.add(new BlogsEntryAttachmentFileEntryReferenceAdapter(tempFileEntry.getFileEntryId(), blogsEntryAttachmentFileEntry));
        }
        return blogsEntryAttachmentFileEntryReferences;
    }

    public static FileEntry addBlogsEntryAttachmentFileEntry(long groupId, long userId, long blogsEntryId, long folderId, String fileName, String mimeType, byte[] bytes) throws PortalException {
        String uniqueFileName = BlogsEntryAttachmentFileEntryUtil._getUniqueFileName(groupId, fileName, folderId);
        return PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)BlogsEntry.class.getName(), (long)blogsEntryId, (String)"com.liferay.blogs", (long)folderId, (byte[])bytes, (String)uniqueFileName, (String)mimeType, (boolean)true);
    }

    public static FileEntry addBlogsEntryAttachmentFileEntry(long groupId, long userId, long blogsEntryId, long folderId, String fileName, String mimeType, File file) throws PortalException {
        String uniqueFileName = BlogsEntryAttachmentFileEntryUtil._getUniqueFileName(groupId, fileName, folderId);
        return PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)BlogsEntry.class.getName(), (long)blogsEntryId, (String)"com.liferay.blogs", (long)folderId, (File)file, (String)uniqueFileName, (String)mimeType, (boolean)true);
    }

    public static FileEntry addBlogsEntryAttachmentFileEntry(long groupId, long userId, long blogsEntryId, long folderId, String fileName, String mimeType, InputStream is) throws PortalException {
        String uniqueFileName = BlogsEntryAttachmentFileEntryUtil._getUniqueFileName(groupId, fileName, folderId);
        return PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)BlogsEntry.class.getName(), (long)blogsEntryId, (String)"com.liferay.blogs", (long)folderId, (InputStream)is, (String)uniqueFileName, (String)mimeType, (boolean)true);
    }

    public static List<FileEntry> getTempBlogsEntryAttachmentFileEntries(String content) throws PortalException {
        ArrayList<FileEntry> tempBlogsEntryAttachmentFileEntries = new ArrayList<FileEntry>();
        Pattern pattern = Pattern.compile("data-image-id=.(\\d+)");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            long fileEntryId = GetterUtil.getLong((String)matcher.group(1));
            FileEntry tempFileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)fileEntryId);
            tempBlogsEntryAttachmentFileEntries.add(tempFileEntry);
        }
        return tempBlogsEntryAttachmentFileEntries;
    }

    private static FileEntry _fetchPortletFileEntry(long groupId, String fileName, long folderId) {
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)groupId, (long)folderId, (String)fileName);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
    }

    private static String _getUniqueFileName(long groupId, String fileName, long folderId) throws PortalException {
        FileEntry fileEntry = BlogsEntryAttachmentFileEntryUtil._fetchPortletFileEntry(groupId, fileName = FileUtil.stripParentheticalSuffix((String)fileName), folderId);
        if (fileEntry == null) {
            return fileName;
        }
        int suffix = 1;
        for (int i = 0; i < 50; ++i) {
            String curFileName = FileUtil.appendParentheticalSuffix((String)fileName, (String)String.valueOf(suffix));
            fileEntry = BlogsEntryAttachmentFileEntryUtil._fetchPortletFileEntry(groupId, curFileName, folderId);
            if (fileEntry == null) {
                return curFileName;
            }
            ++suffix;
        }
        throw new PortalException(StringBundler.concat((Object[])new Object[]{"Unable to get a unique file name for ", fileName, " in folder ", folderId}));
    }
}

