/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.security.permission.resource.definition;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.model.BlogsEntryModel;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.StagedModelPermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.WorkflowedModelPermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.definition.ModelResourcePermissionDefinition;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermission;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelResourcePermissionDefinition.class})
public class BlogsEntryModelResourcePermissionDefinition
implements ModelResourcePermissionDefinition<BlogsEntry> {
    @Reference
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(resource.name=com.liferay.blogs)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private StagingPermission _stagingPermission;
    @Reference
    private WorkflowPermission _workflowPermission;

    public BlogsEntry getModel(long entryId) throws PortalException {
        return this._blogsEntryLocalService.getBlogsEntry(entryId);
    }

    public Class<BlogsEntry> getModelClass() {
        return BlogsEntry.class;
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }

    public long getPrimaryKey(BlogsEntry blogsEntry) {
        return blogsEntry.getEntryId();
    }

    public void registerModelResourcePermissionLogics(ModelResourcePermission<BlogsEntry> modelResourcePermission, Consumer<ModelResourcePermissionLogic<BlogsEntry>> modelResourcePermissionLogicConsumer) {
        modelResourcePermissionLogicConsumer.accept((ModelResourcePermissionLogic<BlogsEntry>)new StagedModelPermissionLogic(this._stagingPermission, "com_liferay_blogs_web_portlet_BlogsPortlet", BlogsEntryModel::getEntryId));
        modelResourcePermissionLogicConsumer.accept((ModelResourcePermissionLogic<BlogsEntry>)new WorkflowedModelPermissionLogic(this._workflowPermission, modelResourcePermission, this._groupLocalService, BlogsEntryModel::getEntryId));
    }
}

