/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.blogs.exception.EntryContentException;
import com.liferay.blogs.exception.EntryCoverImageCropException;
import com.liferay.blogs.exception.EntryDisplayDateException;
import com.liferay.blogs.exception.EntrySmallImageNameException;
import com.liferay.blogs.exception.EntrySmallImageScaleException;
import com.liferay.blogs.exception.EntryTitleException;
import com.liferay.blogs.exception.EntryUrlTitleException;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.base.BlogsEntryLocalServiceBaseImpl;
import com.liferay.blogs.settings.BlogsGroupServiceSettings;
import com.liferay.blogs.util.comparator.EntryDisplayDateComparator;
import com.liferay.blogs.util.comparator.EntryIdComparator;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelectorProcessor;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupSubscriptionCheckSubscriptionSender;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.linkback.LinkbackProducerUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.util.LayoutURLUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.subscription.util.UnsubscribeHelper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.upload.UniqueFileNameProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

public class BlogsEntryLocalServiceImpl
extends BlogsEntryLocalServiceBaseImpl {
    @ServiceReference(type=ClassNameLocalService.class)
    protected ClassNameLocalService classNameLocalService;
    @ServiceReference(type=CommentManager.class)
    protected CommentManager commentManager;
    @ServiceReference(type=FriendlyURLEntryLocalService.class)
    protected FriendlyURLEntryLocalService friendlyURLEntryLocalService;
    @ServiceReference(type=SubscriptionLocalService.class)
    protected SubscriptionLocalService subscriptionLocalService;
    @ServiceReference(type=TrashEntryLocalService.class)
    protected TrashEntryLocalService trashEntryLocalService;
    @ServiceReference(type=UniqueFileNameProvider.class)
    protected UniqueFileNameProvider uniqueFileNameProvider;
    @ServiceReference(type=UnsubscribeHelper.class)
    protected UnsubscribeHelper unsubscribeHelper;
    private static final String _COVER_IMAGE_FOLDER_NAME = "Cover Image";
    private static final String _SMALL_IMAGE_FOLDER_NAME = "Small Image";
    private static final int _UNIQUE_FILE_NAME_TRIES = 50;
    private static final Log _log = LogFactoryUtil.getLog(BlogsEntryLocalServiceImpl.class);

    public FileEntry addAttachmentFileEntry(BlogsEntry blogsEntry, long userId, String fileName, String mimeType, InputStream is) throws PortalException {
        Folder folder = this.addAttachmentsFolder(userId, blogsEntry.getGroupId());
        String uniqueFileName = this.uniqueFileNameProvider.provide(fileName, curFileName -> this._attachmentExists(blogsEntry.getGroupId(), folder.getFolderId(), (String)curFileName));
        return PortletFileRepositoryUtil.addPortletFileEntry((long)blogsEntry.getGroupId(), (long)userId, null, (long)0L, (String)"com.liferay.blogs", (long)folder.getFolderId(), (InputStream)is, (String)uniqueFileName, (String)mimeType, (boolean)true);
    }

    public Folder addAttachmentsFolder(long userId, long groupId) throws PortalException {
        return this.doAddFolder(userId, groupId, "com.liferay.blogs");
    }

    public void addCoverImage(long entryId, ImageSelector imageSelector) throws PortalException {
        if (imageSelector == null) {
            return;
        }
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        String coverImageURL = "";
        long coverImageFileEntryId = 0L;
        if (Validator.isNotNull((String)imageSelector.getImageURL())) {
            coverImageURL = imageSelector.getImageURL();
        } else if (imageSelector.getImageBytes() != null) {
            coverImageFileEntryId = this.addCoverImageFileEntry(entry.getUserId(), entry.getGroupId(), entryId, imageSelector);
        }
        entry.setCoverImageFileEntryId(coverImageFileEntryId);
        entry.setCoverImageURL(coverImageURL);
        this.blogsEntryPersistence.update((BaseModel)entry);
    }

    public BlogsEntry addEntry(long userId, String title, String content, Date displayDate, ServiceContext serviceContext) throws PortalException {
        return this.blogsEntryLocalService.addEntry(userId, title, "", "", content, displayDate, true, true, new String[0], "", null, null, serviceContext);
    }

    public BlogsEntry addEntry(long userId, String title, String content, ServiceContext serviceContext) throws PortalException {
        return this.blogsEntryLocalService.addEntry(userId, title, "", "", content, new Date(), true, true, new String[0], "", null, null, serviceContext);
    }

    @Deprecated
    public BlogsEntry addEntry(long userId, String title, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, boolean smallImage, String smallImageURL, String smallImageFileName, InputStream smallImageInputStream, ServiceContext serviceContext) throws PortalException {
        ImageSelector smallImageImageSelector = null;
        if (smallImage) {
            if (Validator.isNotNull((String)smallImageFileName) && smallImageInputStream != null) {
                try {
                    byte[] bytes = FileUtil.getBytes((InputStream)smallImageInputStream);
                    smallImageImageSelector = new ImageSelector(bytes, smallImageFileName, MimeTypesUtil.getContentType((String)smallImageFileName), null);
                }
                catch (IOException ioe) {
                    _log.error((Object)"Unable to create image selector", (Throwable)ioe);
                }
            } else if (Validator.isNotNull((String)smallImageURL)) {
                smallImageImageSelector = new ImageSelector(smallImageURL);
            }
        }
        return this.blogsEntryLocalService.addEntry(userId, title, "", description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, "", null, smallImageImageSelector, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BlogsEntry addEntry(long userId, String title, String subtitle, String description, String content, Date displayDate, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, String coverImageCaption, ImageSelector coverImageImageSelector, ImageSelector smallImageImageSelector, ServiceContext serviceContext) throws PortalException {
        return this.blogsEntryLocalService.addEntry(userId, title, subtitle, "", description, content, displayDate, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
    }

    public BlogsEntry addEntry(long userId, String title, String subtitle, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, String coverImageCaption, ImageSelector coverImageImageSelector, ImageSelector smallImageImageSelector, ServiceContext serviceContext) throws PortalException {
        return this.blogsEntryLocalService.addEntry(userId, title, subtitle, "", description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BlogsEntry addEntry(long userId, String title, String subtitle, String urlTitle, String description, String content, Date displayDate, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, String coverImageCaption, ImageSelector coverImageImageSelector, ImageSelector smallImageImageSelector, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        int status = 2;
        this.validate(title, urlTitle, content, status);
        long entryId = this.counterLocalService.increment();
        if (Validator.isNotNull((String)urlTitle)) {
            long classNameId = this.classNameLocalService.getClassNameId(BlogsEntry.class);
            this.friendlyURLEntryLocalService.validate(groupId, user.getCompanyId(), classNameId, urlTitle);
        }
        BlogsEntry entry = this.blogsEntryPersistence.create(entryId);
        entry.setUuid(serviceContext.getUuid());
        entry.setGroupId(groupId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setTitle(title);
        entry.setSubtitle(subtitle);
        if (Validator.isNull((String)urlTitle)) {
            urlTitle = this._getUniqueUrlTitle(entry);
        }
        if (!ExportImportThreadLocal.isImportInProcess()) {
            FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.addFriendlyURLEntry(groupId, BlogsEntry.class, entryId, urlTitle, serviceContext);
            urlTitle = friendlyURLEntry.getUrlTitle();
        }
        entry.setUrlTitle(urlTitle);
        entry.setDescription(description);
        entry.setContent(content);
        entry.setDisplayDate(displayDate);
        entry.setAllowPingbacks(allowPingbacks);
        entry.setAllowTrackbacks(allowTrackbacks);
        entry.setStatus(status);
        entry.setStatusByUserId(userId);
        entry.setStatusDate(serviceContext.getModifiedDate(null));
        entry.setExpandoBridgeAttributes(serviceContext);
        this.blogsEntryPersistence.update((BaseModel)entry);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addEntryResources(entry, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addEntryResources(entry, serviceContext.getModelPermissions());
        }
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        long coverImageFileEntryId = 0L;
        String coverImageURL = null;
        if (coverImageImageSelector != null) {
            coverImageURL = coverImageImageSelector.getImageURL();
            if (coverImageImageSelector.getImageBytes() != null) {
                coverImageFileEntryId = this.addCoverImageFileEntry(userId, groupId, entryId, coverImageImageSelector);
            }
        }
        long smallImageFileEntryId = 0L;
        String smallImageURL = null;
        if (smallImageImageSelector != null) {
            smallImageURL = smallImageImageSelector.getImageURL();
            if (smallImageImageSelector.getImageBytes() != null) {
                smallImageFileEntryId = this.addSmallImageFileEntry(userId, groupId, entryId, smallImageImageSelector);
            }
        }
        this.validate(smallImageFileEntryId);
        entry.setCoverImageCaption(coverImageCaption);
        entry.setCoverImageFileEntryId(coverImageFileEntryId);
        entry.setCoverImageURL(coverImageURL);
        if (smallImageFileEntryId != 0L || Validator.isNotNull((String)smallImageURL)) {
            entry.setSmallImage(true);
        }
        entry.setSmallImageFileEntryId(smallImageFileEntryId);
        entry.setSmallImageURL(smallImageURL);
        this.blogsEntryPersistence.update((BaseModel)entry);
        if (ArrayUtil.isNotEmpty((Object[])trackbacks)) {
            serviceContext.setAttribute("trackbacks", (Serializable)trackbacks);
        } else {
            serviceContext.setAttribute("trackbacks", null);
        }
        return this.startWorkflowInstance(userId, entry, serviceContext);
    }

    public BlogsEntry addEntry(long userId, String title, String subtitle, String urlTitle, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, String coverImageCaption, ImageSelector coverImageImageSelector, ImageSelector smallImageImageSelector, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), EntryDisplayDateException.class);
        return this.blogsEntryLocalService.addEntry(userId, title, subtitle, urlTitle, description, content, displayDate, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
    }

    public void addEntryResources(BlogsEntry entry, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BlogsEntry.class.getName(), entry.getEntryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addEntryResources(BlogsEntry entry, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BlogsEntry.class.getName(), entry.getEntryId(), modelPermissions);
    }

    public void addEntryResources(long entryId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, addGroupPermissions, addGuestPermissions);
    }

    public void addEntryResources(long entryId, ModelPermissions modelPermissions) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, modelPermissions);
    }

    public long addOriginalImageFileEntry(long userId, long groupId, long entryId, ImageSelector imageSelector) throws PortalException {
        byte[] imageBytes = imageSelector.getImageBytes();
        if (imageBytes == null) {
            return 0L;
        }
        Folder folder = this.addAttachmentsFolder(userId, groupId);
        FileEntry originalFileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, null, (long)0L, (String)"com.liferay.blogs", (long)folder.getFolderId(), (byte[])imageBytes, (String)this._getUniqueFileName(groupId, imageSelector.getImageTitle(), folder.getFolderId()), (String)imageSelector.getImageMimeType(), (boolean)true);
        return originalFileEntry.getFileEntryId();
    }

    public void addSmallImage(long entryId, ImageSelector imageSelector) throws PortalException {
        if (imageSelector == null) {
            return;
        }
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        boolean smallImage = false;
        long smallImageFileEntryId = 0L;
        String smallImageURL = "";
        if (Validator.isNotNull((String)imageSelector.getImageURL())) {
            smallImage = true;
            smallImageURL = imageSelector.getImageURL();
        } else if (imageSelector.getImageBytes() != null) {
            smallImage = true;
            smallImageFileEntryId = this.addSmallImageFileEntry(entry.getUserId(), entry.getGroupId(), entryId, imageSelector);
        }
        entry.setSmallImage(smallImage);
        entry.setSmallImageFileEntryId(smallImageFileEntryId);
        entry.setSmallImageURL(smallImageURL);
        this.blogsEntryPersistence.update((BaseModel)entry);
    }

    public void checkEntries() throws PortalException {
        Date now = new Date();
        int count = this.blogsEntryPersistence.countByLtD_S(now, 7);
        if (count == 0) {
            return;
        }
        List entries = this.blogsEntryPersistence.findByLtD_S(now, 7);
        for (BlogsEntry entry : entries) {
            ServiceContext serviceContext = new ServiceContext();
            String[] trackbacks = StringUtil.split((String)entry.getTrackbacks());
            serviceContext.setAttribute("trackbacks", (Serializable)trackbacks);
            serviceContext.setCommand("update");
            String portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
            if (Validator.isNotNull((String)portletId)) {
                String layoutFullURL = PortalUtil.getLayoutFullURL((long)entry.getGroupId(), (String)portletId);
                serviceContext.setLayoutFullURL(layoutFullURL);
            }
            serviceContext.setScopeGroupId(entry.getGroupId());
            this.blogsEntryLocalService.updateStatus(entry.getStatusByUserId(), entry.getEntryId(), 0, serviceContext, new HashMap());
        }
    }

    @Override
    public BlogsEntry deleteBlogsEntry(BlogsEntry blogsEntry) {
        try {
            return this.blogsEntryLocalService.deleteEntry(blogsEntry);
        }
        catch (PortalException pe) {
            return (BlogsEntry)ReflectionUtil.throwException((Throwable)pe);
        }
    }

    public void deleteEntries(long groupId) throws PortalException {
        for (BlogsEntry entry : this.blogsEntryPersistence.findByGroupId(groupId)) {
            this.blogsEntryLocalService.deleteEntry(entry);
        }
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public BlogsEntry deleteEntry(BlogsEntry entry) throws PortalException {
        long smallImageFileEntryId;
        this.ratingsStatsLocalService.deleteStats(BlogsEntry.class.getName(), entry.getEntryId());
        this.blogsEntryPersistence.remove((BaseModel)entry);
        this.resourceLocalService.deleteResource(entry.getCompanyId(), BlogsEntry.class.getName(), 4, entry.getEntryId());
        this.imageLocalService.deleteImage(entry.getSmallImageId());
        this.subscriptionLocalService.deleteSubscriptions(entry.getCompanyId(), BlogsEntry.class.getName(), entry.getEntryId());
        this.blogsStatsUserLocalService.updateStatsUser(entry.getGroupId(), entry.getUserId(), entry.getDisplayDate());
        this.assetEntryLocalService.deleteEntry(BlogsEntry.class.getName(), entry.getEntryId());
        long coverImageFileEntryId = entry.getCoverImageFileEntryId();
        if (coverImageFileEntryId != 0L) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)coverImageFileEntryId);
        }
        if ((smallImageFileEntryId = entry.getSmallImageFileEntryId()) != 0L) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)smallImageFileEntryId);
        }
        this.deleteDiscussion(entry);
        this.expandoRowLocalService.deleteRows(entry.getEntryId());
        this.friendlyURLEntryLocalService.deleteFriendlyURLEntry(entry.getGroupId(), BlogsEntry.class, entry.getEntryId());
        this.trashEntryLocalService.deleteEntry(BlogsEntry.class.getName(), entry.getEntryId());
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(entry.getCompanyId(), entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId());
        return entry;
    }

    public void deleteEntry(long entryId) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.blogsEntryLocalService.deleteEntry(entry);
    }

    public Folder fetchAttachmentsFolder(long userId, long groupId) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com.liferay.blogs");
        try {
            return PortletFileRepositoryUtil.getPortletFolder((long)repository.getRepositoryId(), (long)0L, (String)"com.liferay.blogs");
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return null;
        }
    }

    public BlogsEntry fetchEntry(long groupId, String urlTitle) {
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, BlogsEntry.class, urlTitle);
        if (friendlyURLEntry != null) {
            return this.blogsEntryPersistence.fetchByPrimaryKey(friendlyURLEntry.getClassPK());
        }
        return this.blogsEntryPersistence.fetchByG_UT(groupId, urlTitle);
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.findByC_LtD_NotS(companyId, displayDate, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
        }
        return this.blogsEntryPersistence.findByC_LtD_S(companyId, displayDate, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
    }

    public int getCompanyEntriesCount(long companyId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.countByC_LtD_NotS(companyId, displayDate, queryDefinition.getStatus());
        }
        return this.blogsEntryPersistence.countByC_LtD_S(companyId, displayDate, queryDefinition.getStatus());
    }

    public BlogsEntry[] getEntriesPrevAndNext(long entryId) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        BlogsEntry[] entries = this.blogsEntryPersistence.findByG_D_S_PrevAndNext(entryId, entry.getGroupId(), entry.getDisplayDate(), 0, (OrderByComparator)new EntryIdComparator(true));
        if (entries[0] == null) {
            entries[0] = this.blogsEntryPersistence.fetchByG_LtD_S_Last(entry.getGroupId(), entry.getDisplayDate(), 0, (OrderByComparator)new EntryDisplayDateComparator(true));
        }
        if (entries[2] == null) {
            entries[2] = this.blogsEntryPersistence.fetchByG_GtD_S_First(entry.getGroupId(), entry.getDisplayDate(), 0, (OrderByComparator)new EntryDisplayDateComparator(true));
        }
        return entries;
    }

    public BlogsEntry getEntry(long entryId) throws PortalException {
        return this.blogsEntryPersistence.findByPrimaryKey(entryId);
    }

    public BlogsEntry getEntry(long groupId, String urlTitle) throws PortalException {
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, BlogsEntry.class, urlTitle);
        if (friendlyURLEntry != null) {
            return this.blogsEntryPersistence.findByPrimaryKey(friendlyURLEntry.getClassPK());
        }
        return this.blogsEntryPersistence.findByG_UT(groupId, urlTitle);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.findByG_LtD_NotS(groupId, displayDate, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
        }
        return this.blogsEntryPersistence.findByG_LtD_S(groupId, displayDate, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
    }

    public List<BlogsEntry> getGroupEntries(long groupId, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.findByG_NotS(groupId, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
        }
        return this.blogsEntryPersistence.findByG_S(groupId, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
    }

    public int getGroupEntriesCount(long groupId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.countByG_LtD_NotS(groupId, displayDate, queryDefinition.getStatus());
        }
        return this.blogsEntryPersistence.countByG_LtD_S(groupId, displayDate, queryDefinition.getStatus());
    }

    public int getGroupEntriesCount(long groupId, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.countByG_NotS(groupId, queryDefinition.getStatus());
        }
        return this.blogsEntryPersistence.countByG_S(groupId, queryDefinition.getStatus());
    }

    public List<BlogsEntry> getGroupsEntries(long companyId, long groupId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        return this.blogsEntryFinder.findByGroupIds(companyId, groupId, displayDate, queryDefinition);
    }

    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.findByG_U_NotS(groupId, userId, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
        }
        return this.blogsEntryPersistence.findByG_U_S(groupId, userId, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
    }

    public int getGroupUserEntriesCount(long groupId, long userId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.countByG_U_LtD_NotS(groupId, userId, displayDate, queryDefinition.getStatus());
        }
        return this.blogsEntryPersistence.countByG_U_LtD_S(groupId, userId, displayDate, queryDefinition.getStatus());
    }

    @Deprecated
    public List<BlogsEntry> getNoAssetEntries() {
        return this.blogsEntryFinder.findByNoAssets();
    }

    public List<BlogsEntry> getOrganizationEntries(long organizationId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        return this.blogsEntryFinder.findByOrganizationId(organizationId, displayDate, queryDefinition);
    }

    public int getOrganizationEntriesCount(long organizationId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        return this.blogsEntryFinder.countByOrganizationId(organizationId, displayDate, queryDefinition);
    }

    public String getUniqueUrlTitle(BlogsEntry entry) {
        return this._getUniqueUrlTitle(entry);
    }

    public void moveEntriesToTrash(long groupId, long userId) throws PortalException {
        List entries = this.blogsEntryPersistence.findByGroupId(groupId);
        for (BlogsEntry entry : entries) {
            this.blogsEntryLocalService.moveEntryToTrash(userId, entry);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public BlogsEntry moveEntryToTrash(long userId, BlogsEntry entry) throws PortalException {
        if (entry.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = entry.getStatus();
        if (oldStatus == 1) {
            entry.setStatus(2);
            this.blogsEntryPersistence.update((BaseModel)entry);
        }
        entry = this.updateStatus(userId, entry.getEntryId(), 8, new ServiceContext(), new HashMap<String, Serializable>());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", entry.getTitle());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)entry, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(entry.getCompanyId(), entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId());
        }
        return entry;
    }

    public BlogsEntry moveEntryToTrash(long userId, long entryId) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        return this.blogsEntryLocalService.moveEntryToTrash(userId, entry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BlogsEntry restoreEntryFromTrash(long userId, long entryId) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        if (!entry.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(BlogsEntry.class.getName(), entryId);
        entry = this.updateStatus(userId, entryId, trashEntry.getStatus(), new ServiceContext(), new HashMap<String, Serializable>());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", entry.getTitle());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)entry, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        return entry;
    }

    public void subscribe(long userId, long groupId) throws PortalException {
        this.subscriptionLocalService.addSubscription(userId, groupId, BlogsEntry.class.getName(), groupId);
    }

    public void unsubscribe(long userId, long groupId) throws PortalException {
        this.subscriptionLocalService.deleteSubscription(userId, BlogsEntry.class.getName(), groupId);
    }

    public void updateAsset(long userId, BlogsEntry entry, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        boolean visible = false;
        if (entry.isApproved()) {
            visible = true;
        }
        String summary = HtmlUtil.extractText((String)StringUtil.shorten((String)entry.getContent(), (int)500));
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, entry.getGroupId(), entry.getCreateDate(), entry.getModifiedDate(), BlogsEntry.class.getName(), entry.getEntryId(), entry.getUuid(), 0L, assetCategoryIds, assetTagNames, true, visible, null, null, null, null, "text/html", entry.getTitle(), entry.getDescription(), summary, null, null, 0, 0, priority);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public BlogsEntry updateEntry(long userId, long entryId, String title, String content, ServiceContext serviceContext) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        return this.blogsEntryLocalService.updateEntry(userId, entryId, title, entry.getSubtitle(), entry.getDescription(), content, entry.getDisplayDate(), entry.isAllowPingbacks(), entry.isAllowTrackbacks(), StringUtil.split((String)entry.getTrackbacks()), "", null, null, serviceContext);
    }

    @Deprecated
    public BlogsEntry updateEntry(long userId, long entryId, String title, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, boolean smallImage, String smallImageURL, String smallImageFileName, InputStream smallImageInputStream, ServiceContext serviceContext) throws PortalException {
        ImageSelector smallImageImageSelector = null;
        if (smallImage) {
            if (Validator.isNotNull((String)smallImageFileName) && smallImageInputStream != null) {
                try {
                    byte[] bytes = FileUtil.getBytes((InputStream)smallImageInputStream);
                    smallImageImageSelector = new ImageSelector(bytes, smallImageFileName, MimeTypesUtil.getContentType((String)smallImageFileName), null);
                }
                catch (IOException ioe) {
                    _log.error((Object)"Unable to create image selector", (Throwable)ioe);
                }
            } else if (Validator.isNotNull((String)smallImageURL)) {
                smallImageImageSelector = new ImageSelector(smallImageURL);
            }
        } else {
            smallImageImageSelector = new ImageSelector();
        }
        return this.blogsEntryLocalService.updateEntry(userId, entryId, title, "", description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, "", null, smallImageImageSelector, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BlogsEntry updateEntry(long userId, long entryId, String title, String subtitle, String description, String content, Date displayDate, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, String coverImageCaption, ImageSelector coverImageImageSelector, ImageSelector smallImageImageSelector, ServiceContext serviceContext) throws PortalException {
        return this.blogsEntryLocalService.updateEntry(userId, entryId, title, subtitle, this._getURLTitle(entryId), description, content, displayDate, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
    }

    public BlogsEntry updateEntry(long userId, long entryId, String title, String subtitle, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, String coverImageCaption, ImageSelector coverImageImageSelector, ImageSelector smallImageImageSelector, ServiceContext serviceContext) throws PortalException {
        return this.blogsEntryLocalService.updateEntry(userId, entryId, title, subtitle, this._getURLTitle(entryId), description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BlogsEntry updateEntry(long userId, long entryId, String title, String subtitle, String urlTitle, String description, String content, Date displayDate, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, String coverImageCaption, ImageSelector coverImageImageSelector, ImageSelector smallImageImageSelector, ServiceContext serviceContext) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        int status = entry.getStatus();
        if (!entry.isPending() && !entry.isDraft()) {
            status = 2;
        }
        this.validate(title, urlTitle, content, status);
        if (Validator.isNotNull((String)urlTitle)) {
            long classNameId = this.classNameLocalService.getClassNameId(BlogsEntry.class);
            this.friendlyURLEntryLocalService.validate(entry.getGroupId(), classNameId, entryId, urlTitle);
        } else {
            urlTitle = this._getUniqueUrlTitle(entry, title);
        }
        String oldUrlTitle = entry.getUrlTitle();
        entry.setTitle(title);
        entry.setSubtitle(subtitle);
        if (Validator.isNotNull((String)urlTitle) && !urlTitle.equals(entry.getUrlTitle())) {
            FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.addFriendlyURLEntry(entry.getGroupId(), BlogsEntry.class, entry.getEntryId(), urlTitle, serviceContext);
            entry.setUrlTitle(friendlyURLEntry.getUrlTitle());
        }
        entry.setDescription(description);
        entry.setContent(content);
        entry.setDisplayDate(displayDate);
        entry.setAllowPingbacks(allowPingbacks);
        entry.setAllowTrackbacks(allowTrackbacks);
        entry.setStatus(status);
        entry.setExpandoBridgeAttributes(serviceContext);
        this.blogsEntryPersistence.update((BaseModel)entry);
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        long coverImageFileEntryId = entry.getCoverImageFileEntryId();
        String coverImageURL = entry.getCoverImageURL();
        long deletePreviousCoverImageFileEntryId = 0L;
        if (coverImageImageSelector != null) {
            coverImageURL = coverImageImageSelector.getImageURL();
            coverImageFileEntryId = coverImageImageSelector.getImageBytes() != null ? this.addCoverImageFileEntry(userId, entry.getGroupId(), entryId, coverImageImageSelector) : 0L;
            deletePreviousCoverImageFileEntryId = entry.getCoverImageFileEntryId();
        }
        long smallImageFileEntryId = entry.getSmallImageFileEntryId();
        String smallImageURL = entry.getSmallImageURL();
        long deletePreviousSmallImageFileEntryId = 0L;
        long deletePreviousSmallImageId = 0L;
        if (smallImageImageSelector != null) {
            smallImageURL = smallImageImageSelector.getImageURL();
            smallImageFileEntryId = smallImageImageSelector.getImageBytes() != null ? this.addSmallImageFileEntry(userId, entry.getGroupId(), entryId, smallImageImageSelector) : 0L;
            deletePreviousSmallImageFileEntryId = entry.getSmallImageFileEntryId();
            deletePreviousSmallImageId = entry.getSmallImageId();
        }
        this.validate(smallImageFileEntryId);
        entry.setCoverImageCaption(coverImageCaption);
        entry.setCoverImageFileEntryId(coverImageFileEntryId);
        entry.setCoverImageURL(coverImageURL);
        if (smallImageFileEntryId != 0L || Validator.isNotNull((String)smallImageURL)) {
            entry.setSmallImage(true);
        }
        entry.setSmallImageFileEntryId(smallImageFileEntryId);
        entry.setSmallImageURL(smallImageURL);
        this.blogsEntryPersistence.update((BaseModel)entry);
        boolean pingOldTrackbacks = false;
        if (!oldUrlTitle.equals(entry.getUrlTitle())) {
            pingOldTrackbacks = true;
        }
        serviceContext.setAttribute("pingOldTrackbacks", (Serializable)((Object)String.valueOf(pingOldTrackbacks)));
        if (ArrayUtil.isNotEmpty((Object[])trackbacks)) {
            serviceContext.setAttribute("trackbacks", (Serializable)trackbacks);
        } else {
            serviceContext.setAttribute("trackbacks", null);
        }
        entry = this.startWorkflowInstance(userId, entry, serviceContext);
        if (deletePreviousCoverImageFileEntryId != 0L) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)deletePreviousCoverImageFileEntryId);
        }
        if (deletePreviousSmallImageFileEntryId != 0L) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)deletePreviousSmallImageFileEntryId);
        }
        if (deletePreviousSmallImageId != 0L) {
            this.imageLocalService.deleteImage(deletePreviousSmallImageId);
        }
        return entry;
    }

    public BlogsEntry updateEntry(long userId, long entryId, String title, String subtitle, String urlTitle, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, String coverImageCaption, ImageSelector coverImageImageSelector, ImageSelector smallImageImageSelector, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), EntryDisplayDateException.class);
        return this.blogsEntryLocalService.updateEntry(userId, entryId, title, subtitle, urlTitle, description, content, displayDate, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
    }

    public void updateEntryResources(BlogsEntry entry, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.updateResources(entry.getCompanyId(), entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), modelPermissions);
    }

    public void updateEntryResources(BlogsEntry entry, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.updateResources(entry.getCompanyId(), entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), groupPermissions, guestPermissions);
    }

    @Deprecated
    public BlogsEntry updateStatus(long userId, long entryId, int status, ServiceContext serviceContext) throws PortalException {
        return this.updateStatus(userId, entryId, status, serviceContext, new HashMap<String, Serializable>());
    }

    @Indexable(type=IndexableType.REINDEX)
    public BlogsEntry updateStatus(long userId, long entryId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.validate(entry.getTitle(), entry.getUrlTitle(), entry.getContent(), status);
        int oldStatus = entry.getStatus();
        if (status == 0 && now.before(entry.getDisplayDate())) {
            status = 7;
        }
        entry.setStatus(status);
        entry.setStatusByUserId(user.getUserId());
        entry.setStatusByUserName(user.getFullName());
        entry.setStatusDate(serviceContext.getModifiedDate(now));
        if (status == 0 && Validator.isNull((String)entry.getUrlTitle())) {
            String uniqueUrlTitle = this._getUniqueUrlTitle(entry);
            FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.addFriendlyURLEntry(entry.getGroupId(), BlogsEntry.class, entry.getEntryId(), uniqueUrlTitle, serviceContext);
            entry.setUrlTitle(friendlyURLEntry.getUrlTitle());
        }
        this.blogsEntryPersistence.update((BaseModel)entry);
        this.blogsStatsUserLocalService.updateStatsUser(entry.getGroupId(), entry.getUserId(), entry.getDisplayDate());
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(BlogsEntry.class.getName(), entryId);
        if (assetEntry == null || assetEntry.getPublishDate() == null) {
            serviceContext.setCommand("add");
        }
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", entry.getTitle());
        if (status == 0) {
            this.assetEntryLocalService.updateEntry(BlogsEntry.class.getName(), entryId, entry.getDisplayDate(), null, true, true);
            if (oldStatus != 8 && oldStatus != 7) {
                if (serviceContext.isCommandUpdate()) {
                    SocialActivityManagerUtil.addActivity((long)user.getUserId(), (ClassedModel)entry, (int)3, (String)extraDataJSONObject.toString(), (long)0L);
                } else {
                    SocialActivityManagerUtil.addUniqueActivity((long)user.getUserId(), (ClassedModel)entry, (int)2, (String)extraDataJSONObject.toString(), (long)0L);
                }
            }
            if (oldStatus == 8) {
                if (PropsValues.BLOGS_ENTRY_COMMENTS_ENABLED) {
                    this.commentManager.restoreDiscussionFromTrash(BlogsEntry.class.getName(), entryId);
                }
                this.trashEntryLocalService.deleteEntry(BlogsEntry.class.getName(), entryId);
            }
            if (oldStatus != 8) {
                this.notifySubscribers(userId, entry, serviceContext, workflowContext);
                String[] trackbacks = (String[])serviceContext.getAttribute("trackbacks");
                Boolean pingOldTrackbacks = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"pingOldTrackbacks");
                this.pingGoogle(entry, serviceContext);
                this.pingPingback(entry, serviceContext);
                this.pingTrackbacks(entry, trackbacks, pingOldTrackbacks, serviceContext);
            }
        } else {
            this.assetEntryLocalService.updateVisible(BlogsEntry.class.getName(), entryId, false);
            if (status == 7 && oldStatus != 8) {
                if (serviceContext.isCommandUpdate()) {
                    SocialActivityManagerUtil.addActivity((long)user.getUserId(), (ClassedModel)entry, (int)3, (String)extraDataJSONObject.toString(), (long)0L);
                } else {
                    SocialActivityManagerUtil.addUniqueActivity((long)user.getUserId(), (ClassedModel)entry, (int)2, (String)extraDataJSONObject.toString(), (long)0L);
                }
            }
            if (status == 8) {
                if (PropsValues.BLOGS_ENTRY_COMMENTS_ENABLED) {
                    this.commentManager.moveDiscussionToTrash(BlogsEntry.class.getName(), entryId);
                }
                this.trashEntryLocalService.addTrashEntry(userId, entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), entry.getUuid(), null, oldStatus, null, null);
            } else if (oldStatus == 8) {
                if (PropsValues.BLOGS_ENTRY_COMMENTS_ENABLED) {
                    this.commentManager.restoreDiscussionFromTrash(BlogsEntry.class.getName(), entryId);
                }
                this.trashEntryLocalService.deleteEntry(BlogsEntry.class.getName(), entryId);
            }
        }
        return entry;
    }

    protected long addCoverImageFileEntry(long userId, long groupId, long entryId, ImageSelector imageSelector) throws PortalException {
        byte[] imageBytes = imageSelector.getImageBytes();
        if (imageBytes == null) {
            return 0L;
        }
        try {
            ImageSelectorProcessor imageSelectorProcessor = new ImageSelectorProcessor(imageSelector.getImageBytes());
            imageBytes = imageSelectorProcessor.cropImage(imageSelector.getImageCropRegion());
            if (imageBytes == null) {
                throw new EntryCoverImageCropException();
            }
            Folder folder = this.addCoverImageFolder(userId, groupId);
            return this.addProcessedImageFileEntry(userId, groupId, entryId, folder.getFolderId(), imageSelector.getImageTitle(), imageSelector.getImageMimeType(), imageBytes);
        }
        catch (IOException ioe) {
            throw new EntryCoverImageCropException((Throwable)ioe);
        }
    }

    protected Folder addCoverImageFolder(long userId, long groupId) throws PortalException {
        return this.doAddFolder(userId, groupId, _COVER_IMAGE_FOLDER_NAME);
    }

    @Deprecated
    protected void addDiscussion(BlogsEntry entry, long userId, long groupId) throws PortalException {
        if (PropsValues.BLOGS_ENTRY_COMMENTS_ENABLED) {
            this.commentManager.addDiscussion(userId, groupId, BlogsEntry.class.getName(), entry.getEntryId(), entry.getUserName());
        }
    }

    protected long addProcessedImageFileEntry(long userId, long groupId, long entryId, long folderId, String title, String mimeType, byte[] bytes) throws PortalException {
        if (Validator.isNull((String)title)) {
            title = StringUtil.randomString() + "_processedImage_" + entryId;
        }
        FileEntry processedImageFileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)BlogsEntry.class.getName(), (long)entryId, (String)"com.liferay.blogs", (long)folderId, (byte[])bytes, (String)this._getUniqueFileName(groupId, title, folderId), (String)mimeType, (boolean)true);
        return processedImageFileEntry.getFileEntryId();
    }

    protected long addSmallImageFileEntry(long userId, long groupId, long entryId, ImageSelector imageSelector) throws PortalException {
        byte[] imageBytes = imageSelector.getImageBytes();
        if (imageBytes == null) {
            return 0L;
        }
        try {
            BlogsGroupServiceSettings blogsGroupServiceSettings = BlogsGroupServiceSettings.getInstance((long)groupId);
            ImageSelectorProcessor imageSelectorProcessor = new ImageSelectorProcessor(imageSelector.getImageBytes());
            imageBytes = imageSelectorProcessor.scaleImage(blogsGroupServiceSettings.getSmallImageWidth());
            if (imageBytes == null) {
                throw new EntrySmallImageScaleException();
            }
            Folder folder = this.addSmallImageFolder(userId, groupId);
            return this.addProcessedImageFileEntry(userId, groupId, entryId, folder.getFolderId(), imageSelector.getImageTitle(), imageSelector.getImageMimeType(), imageBytes);
        }
        catch (IOException ioe) {
            throw new EntrySmallImageScaleException((Throwable)ioe);
        }
    }

    protected Folder addSmallImageFolder(long userId, long groupId) throws PortalException {
        return this.doAddFolder(userId, groupId, _SMALL_IMAGE_FOLDER_NAME);
    }

    protected void deleteDiscussion(BlogsEntry entry) throws PortalException {
        this.commentManager.deleteDiscussion(BlogsEntry.class.getName(), entry.getEntryId());
    }

    protected Folder doAddFolder(long userId, long groupId, String folderName) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com.liferay.blogs", (ServiceContext)serviceContext);
        return PortletFileRepositoryUtil.addPortletFolder((long)userId, (long)repository.getRepositoryId(), (long)0L, (String)folderName, (ServiceContext)serviceContext);
    }

    protected String getEntryURL(BlogsEntry entry, ServiceContext serviceContext) throws PortalException {
        String layoutURL;
        String entryURL = GetterUtil.getString((Object)serviceContext.getAttribute("entryURL"));
        if (Validator.isNotNull((String)entryURL)) {
            return entryURL;
        }
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            return "";
        }
        String portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        if (Validator.isNotNull((String)portletId) && Validator.isNotNull((String)(layoutURL = LayoutURLUtil.getLayoutURL((long)entry.getGroupId(), (String)portletId, (ServiceContext)serviceContext)))) {
            return StringBundler.concat((Object[])new Object[]{layoutURL, "/-/", "blogs", "/", entry.getEntryId()});
        }
        portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
        if (Validator.isNull((String)portletId) || serviceContext.getThemeDisplay() == null) {
            return "";
        }
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((HttpServletRequest)request, (String)portletId, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/blogs/view_entry");
        portletURL.setParameter("entryId", String.valueOf(entry.getEntryId()));
        return portletURL.toString();
    }

    protected String getLayoutFullURL(ThemeDisplay themeDisplay, ServiceContext serviceContext) throws PortalException {
        if (themeDisplay != null) {
            return PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay);
        }
        return serviceContext.getLayoutFullURL();
    }

    @Deprecated
    protected String getUniqueUrlTitle(long entryId, long groupId, String title) {
        return this._getUniqueUrlTitle(this.blogsEntryPersistence.fetchByPrimaryKey(entryId));
    }

    protected void notifySubscribers(long userId, BlogsEntry entry, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        LocalizedValuesMap bodyLocalizedValuesMap;
        LocalizedValuesMap subjectLocalizedValuesMap;
        if (!entry.isApproved()) {
            return;
        }
        String entryURL = (String)((Object)workflowContext.get("url"));
        if (Validator.isNull((String)entryURL)) {
            String layoutFullURL = serviceContext.getLayoutFullURL();
            entryURL = StringBundler.concat((Object[])new Object[]{layoutFullURL, "/-/", "blogs", "/", entry.getEntryId()});
        }
        BlogsGroupServiceSettings blogsGroupServiceSettings = BlogsGroupServiceSettings.getInstance((long)entry.getGroupId());
        boolean sendEmailEntryUpdated = GetterUtil.getBoolean((Object)serviceContext.getAttribute("sendEmailEntryUpdated"));
        if (!(serviceContext.isCommandAdd() && blogsGroupServiceSettings.isEmailEntryAddedEnabled() || sendEmailEntryUpdated && serviceContext.isCommandUpdate() && blogsGroupServiceSettings.isEmailEntryUpdatedEnabled())) {
            return;
        }
        Group group = this.groupLocalService.getGroup(entry.getGroupId());
        String entryTitle = entry.getTitle();
        String fromName = blogsGroupServiceSettings.getEmailFromName();
        String fromAddress = blogsGroupServiceSettings.getEmailFromAddress();
        if (serviceContext.isCommandUpdate()) {
            subjectLocalizedValuesMap = blogsGroupServiceSettings.getEmailEntryUpdatedSubject();
            bodyLocalizedValuesMap = blogsGroupServiceSettings.getEmailEntryUpdatedBody();
        } else {
            subjectLocalizedValuesMap = blogsGroupServiceSettings.getEmailEntryAddedSubject();
            bodyLocalizedValuesMap = blogsGroupServiceSettings.getEmailEntryAddedBody();
        }
        GroupSubscriptionCheckSubscriptionSender subscriptionSender = new GroupSubscriptionCheckSubscriptionSender("com.liferay.blogs");
        subscriptionSender.setClassPK(entry.getEntryId());
        subscriptionSender.setClassName(entry.getModelClassName());
        subscriptionSender.setCompanyId(entry.getCompanyId());
        subscriptionSender.setContextAttribute("[$BLOGS_ENTRY_CONTENT$]", (Object)StringUtil.shorten((String)HtmlUtil.stripHtml((String)entry.getContent()), (int)500), false);
        String description = entry.getDescription();
        if (Validator.isNotNull((String)description)) {
            subscriptionSender.setContextAttribute("[$BLOGS_ENTRY_DESCRIPTION$]", (Object)description, false);
        } else {
            subscriptionSender.setContextAttribute("[$BLOGS_ENTRY_DESCRIPTION$]", (Object)StringUtil.shorten((String)HtmlUtil.stripHtml((String)entry.getContent()), (int)400), false);
        }
        subscriptionSender.setContextAttributes(new Object[]{"[$BLOGS_ENTRY_CREATE_DATE$]", Time.getSimpleDate((Date)entry.getCreateDate(), (String)"yyyy/MM/dd"), "[$BLOGS_ENTRY_STATUS_BY_USER_NAME$]", entry.getStatusByUserName(), "[$BLOGS_ENTRY_TITLE$]", entryTitle, "[$BLOGS_ENTRY_UPDATE_COMMENT$]", HtmlUtil.replaceNewLine((String)GetterUtil.getString((Object)serviceContext.getAttribute("emailEntryUpdatedComment"))), "[$BLOGS_ENTRY_URL$]", entryURL, "[$BLOGS_ENTRY_USER_PORTRAIT_URL$]", workflowContext.get("userPortraitURL"), "[$BLOGS_ENTRY_USER_URL$]", workflowContext.get("userURL")});
        subscriptionSender.setContextCreatorUserPrefix("BLOGS_ENTRY");
        subscriptionSender.setCreatorUserId(entry.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(entryTitle);
        subscriptionSender.setEntryURL(entryURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        if (bodyLocalizedValuesMap != null) {
            subscriptionSender.setLocalizedBodyMap(LocalizationUtil.getMap((LocalizedValuesMap)bodyLocalizedValuesMap));
        }
        subscriptionSender.setLocalizedContextAttributeWithFunction("[$BLOGS_ENTRY_SITE_NAME$]", locale -> this._getGroupDescriptiveName(group, (Locale)locale));
        if (subjectLocalizedValuesMap != null) {
            subscriptionSender.setLocalizedSubjectMap(LocalizationUtil.getMap((LocalizedValuesMap)subjectLocalizedValuesMap));
        }
        subscriptionSender.setMailId("blogs_entry", new Object[]{entry.getEntryId()});
        int notificationType = 0;
        if (serviceContext.isCommandUpdate()) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        String portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(entry.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        this.unsubscribeHelper.registerHooks((SubscriptionSender)subscriptionSender);
        subscriptionSender.addPersistedSubscribers(BlogsEntry.class.getName(), entry.getGroupId());
        subscriptionSender.addPersistedSubscribers(BlogsEntry.class.getName(), entry.getEntryId());
        subscriptionSender.flushNotificationsAsync();
    }

    protected void pingGoogle(BlogsEntry entry, ServiceContext serviceContext) throws PortalException {
        if (!PropsValues.BLOGS_PING_GOOGLE_ENABLED || !entry.isApproved()) {
            return;
        }
        String portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
        if (Validator.isNull((String)portletId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Not pinging Google because there is no blogs portlet provider");
            }
            return;
        }
        String layoutFullURL = PortalUtil.getLayoutFullURL((long)serviceContext.getScopeGroupId(), (String)portletId);
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        if (layoutFullURL.contains("://localhost")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not pinging Google because of localhost URL " + layoutFullURL));
            }
            return;
        }
        Group group = this.groupLocalService.getGroup(entry.getGroupId());
        StringBundler sb = new StringBundler(6);
        String name = group.getDescriptiveName();
        String url = layoutFullURL + "/-/" + "blogs";
        String changesURL = serviceContext.getPathMain() + "/blogs/rss";
        sb.append("http://blogsearch.google.com/ping?name=");
        sb.append(URLCodec.encodeURL((String)name));
        sb.append("&url=");
        sb.append(URLCodec.encodeURL((String)url));
        sb.append("&changesURL=");
        sb.append(URLCodec.encodeURL((String)changesURL));
        String location = sb.toString();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Pinging Google at " + location));
        }
        try {
            String response = HttpUtil.URLtoString((String)sb.toString());
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Google ping response: " + response));
            }
        }
        catch (IOException ioe) {
            _log.error((Object)("Unable to ping Google at " + location), (Throwable)ioe);
        }
    }

    protected void pingPingback(BlogsEntry entry, ServiceContext serviceContext) throws PortalException {
        if (!(PropsValues.BLOGS_PINGBACK_ENABLED && entry.isAllowPingbacks() && entry.isApproved())) {
            return;
        }
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String layoutFullURL = this.getLayoutFullURL(themeDisplay, serviceContext);
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        String sourceUri = StringBundler.concat((String[])new String[]{layoutFullURL, "/-/", "blogs/", entry.getUrlTitle()});
        Source source = new Source((CharSequence)entry.getContent());
        List tags = source.getAllStartTags("a");
        for (StartTag tag : tags) {
            String targetUri = tag.getAttributeValue("href");
            if (!Validator.isNotNull((String)targetUri)) continue;
            try {
                LinkbackProducerUtil.sendPingback((String)sourceUri, (String)targetUri);
            }
            catch (Exception e) {
                _log.error((Object)("Error while sending pingback " + targetUri), (Throwable)e);
            }
        }
    }

    protected void pingTrackbacks(BlogsEntry entry, String[] trackbacks, boolean pingOldTrackbacks, ServiceContext serviceContext) throws PortalException {
        if (!(PropsValues.BLOGS_TRACKBACK_ENABLED && entry.isAllowTrackbacks() && entry.isApproved())) {
            return;
        }
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String layoutFullURL = this.getLayoutFullURL(themeDisplay, serviceContext);
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        HashMap<String, String> parts = new HashMap<String, String>();
        String excerpt = StringUtil.shorten((String)HtmlUtil.extractText((String)entry.getContent()), (int)PropsValues.BLOGS_LINKBACK_EXCERPT_LENGTH);
        String url = StringBundler.concat((String[])new String[]{layoutFullURL, "/-/", "blogs/", entry.getUrlTitle()});
        parts.put("blog_name", entry.getUserName());
        parts.put("excerpt", excerpt);
        parts.put("title", entry.getTitle());
        parts.put("url", url);
        HashSet trackbacksSet = ArrayUtil.isNotEmpty((Object[])trackbacks) ? SetUtil.fromArray((Object[])trackbacks) : new HashSet();
        if (pingOldTrackbacks) {
            trackbacksSet.addAll(SetUtil.fromArray((Object[])StringUtil.split((String)entry.getTrackbacks())));
            entry.setTrackbacks("");
            this.blogsEntryPersistence.update((BaseModel)entry);
        }
        Set oldTrackbacks = SetUtil.fromArray((Object[])StringUtil.split((String)entry.getTrackbacks()));
        HashSet<String> validTrackbacks = new HashSet<String>();
        for (String trackback : trackbacksSet) {
            if (oldTrackbacks.contains(trackback)) continue;
            try {
                if (!LinkbackProducerUtil.sendTrackback((String)trackback, parts)) continue;
                validTrackbacks.add(trackback);
            }
            catch (Exception e) {
                _log.error((Object)("Error while sending trackback at " + trackback), (Throwable)e);
            }
        }
        if (!validTrackbacks.isEmpty()) {
            String newTrackbacks = StringUtil.merge(validTrackbacks);
            if (Validator.isNotNull((String)entry.getTrackbacks())) {
                newTrackbacks = newTrackbacks + "," + entry.getTrackbacks();
            }
            entry.setTrackbacks(newTrackbacks);
            this.blogsEntryPersistence.update((BaseModel)entry);
        }
    }

    protected BlogsEntry startWorkflowInstance(long userId, BlogsEntry entry, ServiceContext serviceContext) throws PortalException {
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("url", this.getEntryURL(entry, serviceContext));
        String userPortraitURL = "";
        String userURL = "";
        if (serviceContext.getThemeDisplay() != null) {
            User user = this.userLocalService.getUser(userId);
            userPortraitURL = user.getPortraitURL(serviceContext.getThemeDisplay());
            userURL = user.getDisplayURL(serviceContext.getThemeDisplay());
        }
        workflowContext.put("userPortraitURL", userPortraitURL);
        workflowContext.put("userURL", userURL);
        return (BlogsEntry)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)entry.getCompanyId(), (long)entry.getGroupId(), (long)userId, (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (Object)entry, (ServiceContext)serviceContext, workflowContext);
    }

    protected void validate(long smallImageFileEntryId) throws PortalException {
        if (smallImageFileEntryId != 0L) {
            String[] imageExtensions;
            FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)smallImageFileEntryId);
            boolean validSmallImageExtension = false;
            for (String imageExtension : imageExtensions = PrefsPropsUtil.getStringArray((String)"blogs.image.extensions", (String)",")) {
                if (!"*".equals(imageExtension) && !imageExtension.equals("." + fileEntry.getExtension())) continue;
                validSmallImageExtension = true;
                break;
            }
            if (!validSmallImageExtension) {
                throw new EntrySmallImageNameException("Invalid small image for file entry " + smallImageFileEntryId);
            }
        }
    }

    @Deprecated
    protected void validate(String title, String urlTitle, String content) throws PortalException {
        this.validate(title, urlTitle, content, 0);
    }

    protected void validate(String title, String urlTitle, String content, int status) throws PortalException {
        if (status == 0 && Validator.isNull((String)title)) {
            throw new EntryTitleException("Title is null");
        }
        if (Validator.isNotNull((String)title)) {
            int titleMaxLength = ModelHintsUtil.getMaxLength((String)BlogsEntry.class.getName(), (String)"title");
            if (title.length() > titleMaxLength) {
                throw new EntryTitleException("Title has more than " + titleMaxLength + " characters");
            }
        }
        if (Validator.isNotNull((String)urlTitle)) {
            int urlTitleMaxLength = ModelHintsUtil.getMaxLength((String)BlogsEntry.class.getName(), (String)"urlTitle");
            if (urlTitle.length() > urlTitleMaxLength) {
                throw new EntryUrlTitleException("URL title has more than " + urlTitleMaxLength + " characters");
            }
        }
        if (Validator.isNull((String)content)) {
            throw new EntryContentException("Content is null");
        }
        int contentMaxLength = ModelHintsUtil.getMaxLength((String)BlogsEntry.class.getName(), (String)"content");
        if (content.length() > contentMaxLength) {
            throw new EntryContentException("Content has more than " + contentMaxLength + " characters");
        }
    }

    private boolean _attachmentExists(long groupId, long folderId, String fileName) {
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)groupId, (long)folderId, (String)fileName) != null;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }

    private FileEntry _fetchPortletFileEntry(long groupId, String fileName, long folderId) {
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)groupId, (long)folderId, (String)fileName);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
    }

    private String _getGroupDescriptiveName(Group group, Locale locale) {
        try {
            return group.getDescriptiveName(locale);
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to get descriptive name for group " + group.getGroupId()), (Throwable)pe);
            return "";
        }
    }

    private String _getUniqueFileName(long groupId, String fileName, long folderId) throws PortalException {
        FileEntry fileEntry = this._fetchPortletFileEntry(groupId, fileName = FileUtil.stripParentheticalSuffix((String)fileName), folderId);
        if (fileEntry == null) {
            return fileName;
        }
        int suffix = 1;
        for (int i = 0; i < 50; ++i) {
            String curFileName = FileUtil.appendParentheticalSuffix((String)fileName, (String)String.valueOf(suffix));
            fileEntry = this._fetchPortletFileEntry(groupId, curFileName, folderId);
            if (fileEntry == null) {
                return curFileName;
            }
            ++suffix;
        }
        throw new PortalException(StringBundler.concat((Object[])new Object[]{"Unable to get a unique file name for ", fileName, " in folder ", folderId}));
    }

    private String _getUniqueUrlTitle(BlogsEntry entry) {
        return this._getUniqueUrlTitle(entry, entry.getTitle());
    }

    private String _getUniqueUrlTitle(BlogsEntry entry, String newTitle) {
        long entryId = entry.getEntryId();
        String urlTitle = null;
        if (newTitle == null) {
            urlTitle = String.valueOf(entryId);
        } else {
            urlTitle = StringUtil.toLowerCase((String)newTitle.trim());
            urlTitle = Validator.isNull((String)urlTitle) || Validator.isNumber((String)urlTitle) || urlTitle.equals("rss") ? String.valueOf(entryId) : FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)urlTitle);
            urlTitle = ModelHintsUtil.trimString((String)BlogsEntry.class.getName(), (String)"urlTitle", (String)urlTitle);
        }
        long classNameId = this.classNameLocalService.getClassNameId(BlogsEntry.class);
        return this.friendlyURLEntryLocalService.getUniqueUrlTitle(entry.getGroupId(), classNameId, entry.getEntryId(), urlTitle);
    }

    private String _getURLTitle(long entryId) {
        BlogsEntry entry = this.blogsEntryPersistence.fetchByPrimaryKey(entryId);
        if (entry != null) {
            return entry.getUrlTitle();
        }
        return "";
    }
}

