/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.verify;

import com.liferay.blogs.linkback.LinkbackConsumer;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.blogs.trackbacks"}, service={VerifyProcess.class})
public class VerifyBlogsTrackbacks
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyBlogsTrackbacks.class);
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference
    private LinkbackConsumer _linkbackConsumer;
    private MBDiscussionLocalService _mbDiscussionLocalService;
    private MBMessageLocalService _mbMessageLocalService;
    private UserLocalService _userLocalService;

    protected void doVerify() throws Exception {
        this.verifyMBDiscussions();
    }

    @Reference(unbind="-")
    protected void setBlogsEntryLocalService(BlogsEntryLocalService blogsEntryLocalService) {
        this._blogsEntryLocalService = blogsEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setMBDiscussionLocalService(MBDiscussionLocalService mbDiscussionLocalService) {
        this._mbDiscussionLocalService = mbDiscussionLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected void verifyMBDiscussions() {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List mbDiscussions = this._mbDiscussionLocalService.getDiscussions(BlogsEntry.class.getName());
            for (MBDiscussion mbDiscussion : mbDiscussions) {
                try {
                    BlogsEntry entry = this._blogsEntryLocalService.getEntry(mbDiscussion.getClassPK());
                    List mbMessages = this._mbMessageLocalService.getThreadMessages(mbDiscussion.getThreadId(), 0);
                    for (MBMessage mbMessage : mbMessages) {
                        this._verifyPost(entry, mbMessage);
                    }
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    private void _verifyPost(BlogsEntry entry, MBMessage mbMessage) throws PortalException {
        int end;
        String body = mbMessage.getBody();
        String url = null;
        int start = body.indexOf("[url=");
        if (start > -1 && (end = body.indexOf("]", start += "[url=".length())) > -1) {
            url = body.substring(start, end);
        }
        if (Validator.isNotNull(url)) {
            long defaultUserId = this._userLocalService.getDefaultUserId(mbMessage.getCompanyId());
            if (mbMessage.getUserId() == defaultUserId) {
                String entryURL = "/-/blogs/" + entry.getUrlTitle();
                this._linkbackConsumer.verifyTrackback(mbMessage.getMessageId(), url, entryURL);
            }
        }
    }
}

