/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.linkback;

import com.liferay.blogs.linkback.LinkbackConsumer;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LinkbackConsumer.class})
public class LinkbackConsumerImpl
implements LinkbackConsumer {
    private static final Log _log = LogFactoryUtil.getLog(LinkbackConsumerImpl.class);
    @Reference
    private CommentManager _commentManager;
    @Reference
    private Http _http;
    private final List<Tuple> _trackbacks = Collections.synchronizedList(new ArrayList());

    public void addNewTrackback(long commentId, String url, String entryURL) {
        this._trackbacks.add(new Tuple(new Object[]{commentId, url, entryURL}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyNewTrackbacks() {
        Tuple tuple = null;
        while (!this._trackbacks.isEmpty()) {
            List<Tuple> list = this._trackbacks;
            synchronized (list) {
                tuple = this._trackbacks.remove(0);
            }
            long commentId = (Long)tuple.getObject(0);
            String url = (String)tuple.getObject(1);
            String entryUrl = (String)tuple.getObject(2);
            this.verifyTrackback(commentId, url, entryUrl);
        }
    }

    public void verifyTrackback(long commentId, String url, String entryURL) {
        try {
            String result = this._http.URLtoString(url);
            if (result.contains(entryURL)) {
                return;
            }
        }
        catch (Exception result) {
            // empty catch block
        }
        try {
            this._commentManager.deleteComment(commentId);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to delete trackback comment " + commentId), (Throwable)e);
        }
    }
}

