/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.exportimport.data.handler;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class BlogsEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<BlogsEntry> {
    public static final String[] CLASS_NAMES = new String[]{BlogsEntry.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(BlogsEntryStagedModelDataHandler.class);
    @Reference
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.blogs.model.BlogsEntry)")
    private volatile ExportImportContentProcessor<String> _exportImportContentProcessor;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private Portal _portal;

    public void deleteStagedModel(BlogsEntry entry) throws PortalException {
        this._blogsEntryLocalService.deleteEntry(entry);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        BlogsEntry entry = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (entry != null) {
            this.deleteStagedModel(entry);
        }
    }

    public BlogsEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._blogsEntryLocalService.fetchBlogsEntryByUuidAndGroupId(uuid, groupId);
    }

    public List<BlogsEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._blogsEntryLocalService.getBlogsEntriesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(BlogsEntry entry) {
        return entry.getTitle();
    }

    public int[] getExportableStatuses() {
        return new int[]{0, 7};
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        FileEntry fileEntry;
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)entry);
        if (entry.isSmallImage()) {
            if (entry.getSmallImageFileEntryId() > 0L) {
                fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)entry.getSmallImageFileEntryId());
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)entry, (StagedModel)fileEntry, (String)"weak");
            } else if (entry.getSmallImageId() > 0L) {
                Image smallImage = this._imageLocalService.fetchImage(entry.getSmallImageId());
                if (smallImage != null && smallImage.getTextObj() != null) {
                    String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)entry, (String)(smallImage.getImageId() + "." + smallImage.getType()));
                    entryElement.addAttribute("small-image-path", smallImagePath);
                    entry.setSmallImageType(smallImage.getType());
                    portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
                } else {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler(4);
                        sb.append("Unable to export small image ");
                        sb.append(entry.getSmallImageId());
                        sb.append(" to blogs entry ");
                        sb.append(entry.getEntryId());
                        _log.warn((Object)sb.toString());
                    }
                    entry.setSmallImage(false);
                    entry.setSmallImageId(0L);
                }
            }
        }
        if (entry.getCoverImageFileEntryId() != 0L) {
            fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)entry.getCoverImageFileEntryId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)entry, (StagedModel)fileEntry, (String)"weak");
        }
        this._exportFriendlyURLEntries(portletDataContext, entry);
        String content = (String)((Object)this._exportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)entry, (Serializable)((Object)entry.getContent()), portletDataContext.getBooleanParameter("blogs", "referenced-content"), true));
        entry.setContent(content);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)entry), (ClassedModel)entry);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long entryId) {
        BlogsEntry existingEntry = (BlogsEntry)this.fetchMissingReference(uuid, groupId);
        if (existingEntry == null) {
            return;
        }
        Map entryIds = portletDataContext.getNewPrimaryKeysMap(BlogsEntry.class);
        entryIds.put(entryId, existingEntry.getEntryId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        long userId = portletDataContext.getUserId(entry.getUserUuid());
        String content = (String)((Object)this._exportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)entry, (Serializable)((Object)entry.getContent())));
        entry.setContent(content);
        String[] trackbacks = StringUtil.split((String)entry.getTrackbacks());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)entry);
        BlogsEntry existingEntry = this.fetchStagedModelByUuidAndGroupId(entry.getUuid(), portletDataContext.getScopeGroupId());
        long existingCoverImageFileEntryId = 0L;
        long existingSmallImageFileEntryId = 0L;
        if (existingEntry != null) {
            existingCoverImageFileEntryId = existingEntry.getCoverImageFileEntryId();
            existingSmallImageFileEntryId = existingEntry.getSmallImageFileEntryId();
        }
        if (portletDataContext.isDataStrategyMirror() && existingEntry == null) {
            serviceContext.setUuid(entry.getUuid());
        }
        BlogsEntry importedEntry = null;
        importedEntry = existingEntry == null ? this._blogsEntryLocalService.addEntry(userId, entry.getTitle(), entry.getSubtitle(), entry.getDescription(), entry.getContent(), entry.getDisplayDate(), entry.isAllowPingbacks(), entry.isAllowTrackbacks(), trackbacks, entry.getCoverImageCaption(), null, null, serviceContext) : this._blogsEntryLocalService.updateEntry(userId, existingEntry.getEntryId(), entry.getTitle(), entry.getSubtitle(), entry.getDescription(), entry.getContent(), entry.getDisplayDate(), entry.isAllowPingbacks(), entry.isAllowTrackbacks(), trackbacks, entry.getCoverImageCaption(), null, null, serviceContext);
        serviceContext.setModifiedDate(importedEntry.getModifiedDate());
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        try {
            Map fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class);
            long coverImageFileEntryId = MapUtil.getLong((Map)fileEntryIds, (long)entry.getCoverImageFileEntryId(), (long)0L);
            importedEntry.setCoverImageFileEntryId(coverImageFileEntryId);
            importedEntry = this._blogsEntryLocalService.updateBlogsEntry(importedEntry);
            if (existingCoverImageFileEntryId != 0L && entry.getCoverImageFileEntryId() == 0L) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)existingCoverImageFileEntryId);
            }
            if (entry.isSmallImage()) {
                long smallImageFileEntryId = MapUtil.getLong((Map)fileEntryIds, (long)entry.getSmallImageFileEntryId(), (long)0L);
                importedEntry.setSmallImageFileEntryId(smallImageFileEntryId);
                if (smallImageFileEntryId == 0L) {
                    importedEntry.setSmallImage(false);
                }
                importedEntry = this._blogsEntryLocalService.updateBlogsEntry(importedEntry);
                if (existingSmallImageFileEntryId != 0L && entry.getSmallImageFileEntryId() == 0L) {
                    PortletFileRepositoryUtil.deletePortletFileEntry((long)existingSmallImageFileEntryId);
                }
            }
            Map newPrimaryKeysMap = portletDataContext.getNewPrimaryKeysMap(BlogsEntry.class);
            newPrimaryKeysMap.put(entry.getEntryId(), importedEntry.getEntryId());
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
        portletDataContext.importClassedModel((ClassedModel)entry, (ClassedModel)importedEntry);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        BlogsEntry existingEntry = this.fetchStagedModelByUuidAndGroupId(entry.getUuid(), portletDataContext.getScopeGroupId());
        if (existingEntry == null || !existingEntry.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)BlogsEntry.class.getName());
        if (trashHandler.isRestorable(existingEntry.getEntryId())) {
            long userId = portletDataContext.getUserId(entry.getUserUuid());
            trashHandler.restoreTrashEntry(userId, existingEntry.getEntryId());
        }
    }

    private void _exportFriendlyURLEntries(PortletDataContext portletDataContext, BlogsEntry blogsEntry) throws PortletDataException {
        long classNameId = this._portal.getClassNameId(BlogsEntry.class);
        List friendlyURLEntries = this._friendlyURLEntryLocalService.getFriendlyURLEntries(blogsEntry.getGroupId(), classNameId, blogsEntry.getEntryId());
        for (FriendlyURLEntry friendlyURLEntry : friendlyURLEntries) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)friendlyURLEntry);
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)friendlyURLEntry, (StagedModel)blogsEntry, (String)"dependency");
        }
    }
}

