/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.atom;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.portal.atom.AtomPager;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.atom.AtomEntryContent;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import com.liferay.portal.kernel.atom.BaseAtomCollectionAdapter;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.blogs.model.BlogsEntry"}, service={AtomCollectionAdapter.class})
public class BlogsEntryAtomCollectionAdapter
extends BaseAtomCollectionAdapter<BlogsEntry> {
    private static final String _COLLECTION_NAME = "blogs";
    private BlogsEntryService _blogsEntryService;

    public String getCollectionName() {
        return _COLLECTION_NAME;
    }

    public List<String> getEntryAuthors(BlogsEntry blogsEntry) {
        ArrayList<String> authors = new ArrayList<String>();
        authors.add(blogsEntry.getUserName());
        return authors;
    }

    public AtomEntryContent getEntryContent(BlogsEntry blogsEntry, AtomRequestContext atomRequestContext) {
        return new AtomEntryContent(blogsEntry.getContent());
    }

    public String getEntryId(BlogsEntry blogsEntry) {
        return String.valueOf(blogsEntry.getEntryId());
    }

    public String getEntrySummary(BlogsEntry blogsEntry) {
        return blogsEntry.getDescription();
    }

    public String getEntryTitle(BlogsEntry blogsEntry) {
        return blogsEntry.getTitle();
    }

    public Date getEntryUpdated(BlogsEntry blogsEntry) {
        return blogsEntry.getModifiedDate();
    }

    public String getFeedTitle(AtomRequestContext atomRequestContext) {
        String portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        return AtomUtil.createFeedTitleFromPortletName((AtomRequestContext)atomRequestContext, (String)portletId);
    }

    protected void doDeleteEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long blogsEntryId = GetterUtil.getLong((String)resourceName);
        this._blogsEntryService.deleteEntry(blogsEntryId);
    }

    protected BlogsEntry doGetEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long blogsEntryId = GetterUtil.getLong((String)resourceName);
        return this._blogsEntryService.getEntry(blogsEntryId);
    }

    protected Iterable<BlogsEntry> doGetFeedEntries(AtomRequestContext atomRequestContext) throws Exception {
        long groupId = atomRequestContext.getLongParameter("groupId");
        int status = 0;
        int max = atomRequestContext.getIntParameter("max", SearchContainer.DEFAULT_DELTA);
        if (groupId > 0L) {
            int page = atomRequestContext.getIntParameter("page");
            if (page == 0) {
                return this._blogsEntryService.getGroupEntries(groupId, status, max);
            }
            int count = this._blogsEntryService.getGroupEntriesCount(groupId, new Date(), status);
            AtomPager atomPager = new AtomPager(page, max, count);
            AtomUtil.saveAtomPagerInRequest((AtomRequestContext)atomRequestContext, (AtomPager)atomPager);
            return this._blogsEntryService.getGroupEntries(groupId, new Date(), status, atomPager.getStart(), atomPager.getEnd() + 1);
        }
        long organizationId = atomRequestContext.getLongParameter("organizationId");
        if (organizationId > 0L) {
            return this._blogsEntryService.getOrganizationEntries(organizationId, new Date(), status, max);
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        if (companyId > 0L) {
            return this._blogsEntryService.getCompanyEntries(companyId, new Date(), status, max);
        }
        return Collections.emptyList();
    }

    protected BlogsEntry doPostEntry(String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        long groupId = atomRequestContext.getLongParameter("groupId");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int displayDateMonth = cal.get(2);
        int displayDateDay = cal.get(5);
        int displayDateYear = cal.get(1);
        int displayDateHour = cal.get(11);
        int displayDateMinute = cal.get(12);
        boolean allowPingbacks = true;
        boolean allowTrackbacks = true;
        String[] trackbacks = new String[]{};
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        return this._blogsEntryService.addEntry(title, "", summary, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, "", null, null, serviceContext);
    }

    protected void doPutEntry(BlogsEntry blogsEntry, String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int displayDateMonth = cal.get(2);
        int displayDateDay = cal.get(5);
        int displayDateYear = cal.get(1);
        int displayDateHour = cal.get(11);
        int displayDateMinute = cal.get(12);
        String[] trackbacks = StringUtil.split((String)blogsEntry.getTrackbacks());
        ServiceContext serviceContext = new ServiceContext();
        this._blogsEntryService.updateEntry(blogsEntry.getEntryId(), title, blogsEntry.getSubtitle(), summary, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, blogsEntry.isAllowPingbacks(), blogsEntry.isAllowTrackbacks(), trackbacks, "", null, null, serviceContext);
    }

    @Reference(unbind="-")
    protected void setBlogsEntryService(BlogsEntryService blogsEntryService) {
        this._blogsEntryService = blogsEntryService;
    }
}

