/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.search;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.BlogsEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class BlogsEntryIndexer
extends BaseIndexer<BlogsEntry> {
    public static final String CLASS_NAME = BlogsEntry.class.getName();
    @Reference
    protected BlogsEntryLocalService blogsEntryLocalService;
    @Reference
    protected IndexWriterHelper indexWriterHelper;
    private static final Log _log = LogFactoryUtil.getLog(BlogsEntryIndexer.class);

    public BlogsEntryIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetTagNames", "companyId", "content", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "title", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return BlogsEntryPermission.contains((PermissionChecker)permissionChecker, (long)entryClassPK, (String)"VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        BlogsEntry entry = this.blogsEntryLocalService.getEntry(classPK);
        return this.isVisible(entry.getStatus(), status);
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
    }

    protected void doDelete(BlogsEntry blogsEntry) throws Exception {
        this.deleteDocument(blogsEntry.getCompanyId(), blogsEntry.getEntryId());
    }

    protected Document doGetDocument(BlogsEntry blogsEntry) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)blogsEntry);
        document.addText("caption", blogsEntry.getCoverImageCaption());
        document.addText("content", HtmlUtil.extractText((String)blogsEntry.getContent()));
        document.addText("description", blogsEntry.getDescription());
        document.addDate("modified", blogsEntry.getModifiedDate());
        document.addText("subtitle", blogsEntry.getSubtitle());
        document.addText("title", blogsEntry.getTitle());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(BlogsEntry blogsEntry) throws Exception {
        Document document = this.getDocument(blogsEntry);
        this.indexWriterHelper.updateDocument(this.getSearchEngineId(), blogsEntry.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BlogsEntry entry = this.blogsEntryLocalService.getEntry(classPK);
        this.doReindex(entry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexEntries(companyId);
    }

    protected void reindexEntries(long companyId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.blogsEntryLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property displayDateProperty = PropertyFactoryUtil.forName((String)"displayDate");
                dynamicQuery.add(displayDateProperty.lt((Object)new Date()));
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                Object[] statuses = new Integer[]{0, 8};
                dynamicQuery.add(statusProperty.in(statuses));
            }
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<BlogsEntry>(){

            public void performAction(BlogsEntry entry) {
                block2: {
                    try {
                        Document document = BlogsEntryIndexer.this.getDocument(entry);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index blogs entry " + entry.getEntryId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

