/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.exportimport.data.handler;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.BlogsEntryLocalService;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class BlogsEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<BlogsEntry> {
    public static final String[] CLASS_NAMES = new String[]{BlogsEntry.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(BlogsEntryStagedModelDataHandler.class);
    private BlogsEntryLocalService _blogsEntryLocalService;
    private ExportImportContentProcessor<String> _exportImportContentProcessor;
    private ImageLocalService _imageLocalService;

    public void deleteStagedModel(BlogsEntry entry) throws PortalException {
        this._blogsEntryLocalService.deleteEntry(entry);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        BlogsEntry entry = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (entry != null) {
            this.deleteStagedModel(entry);
        }
    }

    public BlogsEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._blogsEntryLocalService.fetchBlogsEntryByUuidAndGroupId(uuid, groupId);
    }

    public List<BlogsEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._blogsEntryLocalService.getBlogsEntriesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(BlogsEntry entry) {
        return entry.getTitle();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        FileEntry fileEntry;
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)entry);
        if (entry.isSmallImage()) {
            if (entry.getSmallImageFileEntryId() > 0L) {
                fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)entry.getSmallImageFileEntryId());
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)entry, (StagedModel)fileEntry, (String)"weak");
            } else if (entry.getSmallImageId() > 0L) {
                Image smallImage = this._imageLocalService.fetchImage(entry.getSmallImageId());
                if (smallImage != null && smallImage.getTextObj() != null) {
                    String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)entry, (String)(smallImage.getImageId() + "." + smallImage.getType()));
                    entryElement.addAttribute("small-image-path", smallImagePath);
                    entry.setSmallImageType(smallImage.getType());
                    portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
                } else {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler(4);
                        sb.append("Unable to export small image ");
                        sb.append(entry.getSmallImageId());
                        sb.append(" to blogs entry ");
                        sb.append(entry.getEntryId());
                        _log.warn((Object)sb.toString());
                    }
                    entry.setSmallImage(false);
                    entry.setSmallImageId(0L);
                }
            }
        }
        if (entry.getCoverImageFileEntryId() != 0L) {
            fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)entry.getCoverImageFileEntryId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)entry, (StagedModel)fileEntry, (String)"weak");
        }
        String content = (String)((Object)this._exportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)entry, (Serializable)((Object)entry.getContent()), portletDataContext.getBooleanParameter("blogs", "referenced-content"), true));
        entry.setContent(content);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)entry), (ClassedModel)entry);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long entryId) throws Exception {
        BlogsEntry existingEntry = (BlogsEntry)this.fetchMissingReference(uuid, groupId);
        if (existingEntry == null) {
            return;
        }
        Map entryIds = portletDataContext.getNewPrimaryKeysMap(BlogsEntry.class);
        entryIds.put(entryId, existingEntry.getEntryId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        ImageSelector smallImageSelector;
        ImageSelector coverImageSelector;
        BlogsEntry importedEntry;
        block15: {
            List attachmentElements;
            block17: {
                String smallImagePath;
                block16: {
                    long userId = portletDataContext.getUserId(entry.getUserUuid());
                    Element entryElement = portletDataContext.getImportDataStagedModelElement((StagedModel)entry);
                    String content = (String)((Object)this._exportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)entry, (Serializable)((Object)entry.getContent())));
                    entry.setContent(content);
                    Calendar displayDateCal = CalendarFactoryUtil.getCalendar();
                    displayDateCal.setTime(entry.getDisplayDate());
                    int displayDateMonth = displayDateCal.get(2);
                    int displayDateDay = displayDateCal.get(5);
                    int displayDateYear = displayDateCal.get(1);
                    int displayDateHour = displayDateCal.get(10);
                    int displayDateMinute = displayDateCal.get(12);
                    if (displayDateCal.get(9) == 1) {
                        displayDateHour += 12;
                    }
                    boolean allowPingbacks = entry.isAllowPingbacks();
                    boolean allowTrackbacks = entry.isAllowTrackbacks();
                    String[] trackbacks = StringUtil.split((String)entry.getTrackbacks());
                    ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)entry);
                    importedEntry = null;
                    if (portletDataContext.isDataStrategyMirror()) {
                        serviceContext.setAttribute("urlTitle", (Serializable)((Object)entry.getUrlTitle()));
                        BlogsEntry existingEntry = this.fetchStagedModelByUuidAndGroupId(entry.getUuid(), portletDataContext.getScopeGroupId());
                        if (existingEntry == null) {
                            serviceContext.setUuid(entry.getUuid());
                            importedEntry = this._blogsEntryLocalService.addEntry(userId, entry.getTitle(), entry.getSubtitle(), entry.getDescription(), entry.getContent(), displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, entry.getCoverImageCaption(), null, null, serviceContext);
                        } else {
                            importedEntry = this._blogsEntryLocalService.updateEntry(userId, existingEntry.getEntryId(), entry.getTitle(), entry.getSubtitle(), entry.getDescription(), entry.getContent(), displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, entry.getCoverImageCaption(), new ImageSelector(), new ImageSelector(), serviceContext);
                        }
                    } else {
                        importedEntry = this._blogsEntryLocalService.addEntry(userId, entry.getTitle(), entry.getSubtitle(), entry.getDescription(), entry.getContent(), displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, entry.getCoverImageCaption(), null, null, serviceContext);
                    }
                    if (entry.getCoverImageFileEntryId() == 0L && Validator.isNull((String)entry.getCoverImageURL()) && entry.getSmallImageFileEntryId() == 0L && Validator.isNull((String)entry.getSmallImageURL()) && !entry.isSmallImage()) {
                        portletDataContext.importClassedModel((ClassedModel)entry, (ClassedModel)importedEntry);
                        return;
                    }
                    coverImageSelector = null;
                    attachmentElements = portletDataContext.getReferenceDataElements((StagedModel)entry, DLFileEntry.class, "weak");
                    if (Validator.isNotNull((String)entry.getCoverImageURL())) {
                        coverImageSelector = new ImageSelector(entry.getCoverImageURL());
                    } else if (entry.getCoverImageFileEntryId() != 0L) {
                        coverImageSelector = this._getImageSelector(portletDataContext, entry.getCoverImageFileEntryId(), attachmentElements);
                    }
                    if (coverImageSelector != null) {
                        this._blogsEntryLocalService.addCoverImage(importedEntry.getEntryId(), coverImageSelector);
                    }
                    smallImageSelector = null;
                    if (!entry.isSmallImage()) break block15;
                    smallImagePath = entryElement.attributeValue("small-image-path");
                    if (!Validator.isNotNull((String)entry.getSmallImageURL())) break block16;
                    smallImageSelector = new ImageSelector(entry.getSmallImageURL());
                    break block15;
                }
                if (!Validator.isNotNull((String)smallImagePath)) break block17;
                String smallImageFileName = entry.getSmallImageId() + "." + entry.getSmallImageType();
                InputStream inputStream = null;
                try {
                    inputStream = portletDataContext.getZipEntryAsInputStream(smallImagePath);
                    smallImageSelector = new ImageSelector(FileUtil.getBytes((InputStream)inputStream), smallImageFileName, MimeTypesUtil.getContentType((String)smallImageFileName), null);
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                break block15;
            }
            if (entry.getSmallImageFileEntryId() != 0L) {
                smallImageSelector = this._getImageSelector(portletDataContext, entry.getSmallImageFileEntryId(), attachmentElements);
            }
        }
        if (smallImageSelector != null) {
            this._blogsEntryLocalService.addSmallImage(importedEntry.getEntryId(), smallImageSelector);
        }
        if (coverImageSelector != null || smallImageSelector != null) {
            importedEntry = this._blogsEntryLocalService.getBlogsEntry(importedEntry.getEntryId());
        }
        portletDataContext.importClassedModel((ClassedModel)entry, (ClassedModel)importedEntry);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        long userId = portletDataContext.getUserId(entry.getUserUuid());
        BlogsEntry existingEntry = this.fetchStagedModelByUuidAndGroupId(entry.getUuid(), portletDataContext.getScopeGroupId());
        if (existingEntry == null || !existingEntry.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingEntry.getTrashHandler();
        if (trashHandler.isRestorable(existingEntry.getEntryId())) {
            trashHandler.restoreTrashEntry(userId, existingEntry.getEntryId());
        }
    }

    protected InputStream getSmallImageInputStream(PortletDataContext portletDataContext, Element attachmentElement) {
        InputStream inputStream = null;
        String path = attachmentElement.attributeValue("path");
        FileEntry fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
        String binPath = attachmentElement.attributeValue("bin-path");
        if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
            try {
                inputStream = FileEntryUtil.getContentStream((FileEntry)fileEntry);
            }
            catch (Exception exception) {}
        } else {
            inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
        }
        if (inputStream == null && _log.isWarnEnabled()) {
            _log.warn((Object)("Unable to import small image file entry " + fileEntry.getFileEntryId()));
        }
        return inputStream;
    }

    @Reference(unbind="-")
    protected void setBlogsEntryLocalService(BlogsEntryLocalService blogsEntryLocalService) {
        this._blogsEntryLocalService = blogsEntryLocalService;
    }

    @Reference(policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.blogs.kernel.model.BlogsEntry)", unbind="-")
    protected void setExportImportContentProcessor(ExportImportContentProcessor<String> exportImportContentProcessor) {
        this._exportImportContentProcessor = exportImportContentProcessor;
    }

    @Reference(unbind="-")
    protected void setImageLocalService(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageSelector _getImageSelector(PortletDataContext portletDataContext, long fileEntryId, List<Element> attachmentElements) throws Exception {
        for (Element attachmentElement : attachmentElements) {
            InputStream inputStream;
            FileEntry fileEntry;
            block9: {
                block10: {
                    String path = attachmentElement.attributeValue("path");
                    fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
                    if (fileEntryId != fileEntry.getFileEntryId()) continue;
                    inputStream = null;
                    try {
                        String binPath = attachmentElement.attributeValue("bin-path");
                        if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
                            try {
                                inputStream = FileEntryUtil.getContentStream((FileEntry)fileEntry);
                            }
                            catch (NoSuchFileException nsfe) {
                                if (_log.isDebugEnabled()) {
                                    _log.debug((Object)nsfe, (Throwable)nsfe);
                                }
                            }
                        } else {
                            inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
                        }
                        if (inputStream != null) break block9;
                        if (!_log.isWarnEnabled()) break block10;
                        _log.warn((Object)("Unable to import attachment for file entry " + fileEntry.getFileEntryId()));
                    }
                    catch (Throwable throwable) {
                        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                        throw throwable;
                    }
                }
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                continue;
            }
            ImageSelector imageSelector = new ImageSelector(FileUtil.getBytes((InputStream)inputStream), fileEntry.getFileName(), fileEntry.getMimeType(), null);
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            return imageSelector;
        }
        return null;
    }
}

