/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.internal.model.listener;

import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.planner.constants.BatchPlannerPlanConstants;
import com.liferay.batch.planner.internal.notifications.BatchPlannerNotificationSender;
import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.service.BatchPlannerPlanLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class BatchEngineExportTaskModelListener
extends BaseModelListener<BatchEngineExportTask> {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineExportTaskModelListener.class);
    private final BatchPlannerNotificationSender _batchPlannerNotificationSender = new BatchPlannerNotificationSender("export");
    @Reference
    private BatchPlannerPlanLocalService _batchPlannerPlanLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public void onAfterRemove(BatchEngineExportTask batchEngineExportTask) throws ModelListenerException {
        try {
            this._batchPlannerPlanLocalService.deactivateBatchPlannerPlan(batchEngineExportTask.getExternalReferenceCode());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public void onAfterUpdate(BatchEngineExportTask originalBatchEngineExportTask, BatchEngineExportTask batchEngineExportTask) throws ModelListenerException {
        BatchPlannerPlan batchPlannerPlan = this._updateStatus(batchEngineExportTask);
        if (batchPlannerPlan == null) {
            return;
        }
        BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus = BatchEngineTaskExecuteStatus.valueOf((String)batchEngineExportTask.getExecuteStatus());
        if (batchEngineTaskExecuteStatus == BatchEngineTaskExecuteStatus.COMPLETED || batchEngineTaskExecuteStatus == BatchEngineTaskExecuteStatus.FAILED) {
            this._notify(batchEngineTaskExecuteStatus, batchPlannerPlan);
        }
    }

    @Activate
    protected void activate() {
        this._batchPlannerNotificationSender.setUserNotificationEventLocalService(this._userNotificationEventLocalService);
    }

    private void _notify(BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus, BatchPlannerPlan batchPlannerPlan) {
        this._batchPlannerNotificationSender.sendUserNotificationEvents(batchPlannerPlan.getUserId(), "com_liferay_batch_planner_web_internal_portlet_BatchPlannerPortlet", 10002, this._batchPlannerNotificationSender.getNotificationEventJSONObject(batchEngineTaskExecuteStatus, batchPlannerPlan.getBatchPlannerPlanId(), batchPlannerPlan.getInternalClassName()));
    }

    private BatchPlannerPlan _updateStatus(BatchEngineExportTask batchEngineExportTask) {
        BatchPlannerPlan batchPlannerPlan = this._batchPlannerPlanLocalService.fetchBatchPlannerPlan(GetterUtil.getLong((String)batchEngineExportTask.getExternalReferenceCode()));
        if (batchPlannerPlan == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No batch planner plan found for ID " + batchEngineExportTask.getExternalReferenceCode()));
            }
            return null;
        }
        try {
            return this._batchPlannerPlanLocalService.updateStatus(batchPlannerPlan.getBatchPlannerPlanId(), BatchPlannerPlanConstants.getStatus((BatchEngineTaskExecuteStatus)BatchEngineTaskExecuteStatus.valueOf((String)batchEngineExportTask.getExecuteStatus())));
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return null;
        }
    }
}

