/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.internal.batch.engine.broker;

import com.liferay.batch.engine.constants.CreateStrategy;
import com.liferay.batch.engine.jaxrs.uri.BatchEngineUriInfo;
import com.liferay.batch.planner.batch.engine.broker.BatchEngineBroker;
import com.liferay.batch.planner.constants.BatchPlannerPlanConstants;
import com.liferay.batch.planner.constants.BatchPlannerPolicyConstants;
import com.liferay.batch.planner.model.BatchPlannerMapping;
import com.liferay.batch.planner.model.BatchPlannerMappingModel;
import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.model.BatchPlannerPolicy;
import com.liferay.batch.planner.service.BatchPlannerMappingLocalService;
import com.liferay.batch.planner.service.BatchPlannerPlanLocalService;
import com.liferay.headless.batch.engine.resource.v1_0.ExportTaskResource;
import com.liferay.headless.batch.engine.resource.v1_0.ImportTaskResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import jakarta.ws.rs.core.UriInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BatchEngineBroker.class})
public class BatchEngineBrokerImpl
implements BatchEngineBroker {
    @Reference
    private BatchPlannerMappingLocalService _batchPlannerMappingLocalService;
    @Reference
    private BatchPlannerPlanLocalService _batchPlannerPlanLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ExportTaskResource _exportTaskResource;
    @Reference
    private ImportTaskResource.Factory _factory;
    @Reference
    private com.liferay.portal.kernel.util.File _file;
    @Reference
    private UserLocalService _userLocalService;

    public void submit(long batchPlannerPlanId) throws Exception {
        BatchPlannerPlan batchPlannerPlan = this._batchPlannerPlanLocalService.getBatchPlannerPlan(batchPlannerPlanId);
        this._batchPlannerPlanLocalService.updateStatus(batchPlannerPlan.getBatchPlannerPlanId(), 1);
        try {
            if (batchPlannerPlan.isExport()) {
                this._submitExportTask(batchPlannerPlan);
            } else {
                this._submitImportTask(batchPlannerPlan);
            }
        }
        catch (Exception exception) {
            this._batchPlannerPlanLocalService.updateStatus(batchPlannerPlan.getBatchPlannerPlanId(), 4);
            throw exception;
        }
    }

    private String _getFieldNameMapping(List<BatchPlannerMapping> batchPlannerMappings) {
        if (batchPlannerMappings.isEmpty()) {
            throw new IllegalArgumentException("There are no batch planner mappings");
        }
        StringBundler sb = new StringBundler(batchPlannerMappings.size() * 3 - 1);
        Iterator<BatchPlannerMapping> iterator = batchPlannerMappings.iterator();
        while (iterator.hasNext()) {
            BatchPlannerMapping batchPlannerMapping = iterator.next();
            sb.append(batchPlannerMapping.getExternalFieldName());
            sb.append("=");
            sb.append(batchPlannerMapping.getInternalFieldName());
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private File _getFile(long batchPlannerPlanId) throws Exception {
        BatchPlannerPlan batchPlannerPlan = this._batchPlannerPlanLocalService.getBatchPlannerPlan(batchPlannerPlanId);
        return new File(new URI(batchPlannerPlan.getExternalURL()));
    }

    private String[] _getHeaderNames(List<BatchPlannerMapping> batchPlannerMappings, UnsafeFunction<BatchPlannerMapping, String, Exception> unsafeFunction) {
        return (String[])TransformUtil.transformToArray(batchPlannerMappings, unsafeFunction, String.class);
    }

    private String _getImportErrorStrategy(BatchPlannerPlan batchPlannerPlan) throws Exception {
        BatchPlannerPolicy batchPlannerPolicy = batchPlannerPlan.getBatchPlannerPolicy("onErrorFail");
        boolean onErrorFail = Boolean.valueOf(batchPlannerPolicy.getValue());
        if (onErrorFail) {
            return "ON_ERROR_FAIL";
        }
        return "ON_ERROR_CONTINUE";
    }

    private UriInfo _getUriInfo(BatchPlannerPlan batchPlannerPlan, Map<String, String> planPolicyNameTypes) {
        BatchEngineUriInfo.Builder builder = new BatchEngineUriInfo.Builder();
        for (String name : planPolicyNameTypes.keySet()) {
            builder.queryParameter(name, this._getValue(batchPlannerPlan.fetchBatchPlannerPolicy(name)));
        }
        return builder.taskItemDelegateName(batchPlannerPlan.getTaskItemDelegateName()).build();
    }

    private String _getValue(BatchPlannerPolicy batchPlannerPolicy) {
        if (batchPlannerPolicy != null) {
            return batchPlannerPolicy.getValue();
        }
        return null;
    }

    private void _submitExportTask(BatchPlannerPlan batchPlannerPlan) throws Exception {
        this._exportTaskResource.setContextCompany(this._companyLocalService.getCompany(batchPlannerPlan.getCompanyId()));
        this._exportTaskResource.setContextUriInfo(this._getUriInfo(batchPlannerPlan, BatchPlannerPolicyConstants.exportPlanPolicyNameTypes));
        this._exportTaskResource.setContextUser(this._userLocalService.getUser(batchPlannerPlan.getUserId()));
        this._exportTaskResource.postExportTask(batchPlannerPlan.getInternalClassName(), batchPlannerPlan.getExternalType(), null, null, String.valueOf(batchPlannerPlan.getBatchPlannerPlanId()), StringUtil.merge((Object[])this._getHeaderNames(this._batchPlannerMappingLocalService.getBatchPlannerMappings(batchPlannerPlan.getBatchPlannerPlanId()), (UnsafeFunction<BatchPlannerMapping, String, Exception>)((UnsafeFunction)BatchPlannerMappingModel::getInternalFieldName)), (String)","), batchPlannerPlan.getTaskItemDelegateName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _submitImportTask(BatchPlannerPlan batchPlannerPlan) throws Exception {
        ImportTaskResource importTaskResource = this._factory.create().uriInfo(this._getUriInfo(batchPlannerPlan, BatchPlannerPolicyConstants.importPlanPolicyNameTypes)).user(this._userLocalService.getUser(batchPlannerPlan.getUserId())).build();
        importTaskResource.setContextCompany(this._companyLocalService.getCompany(batchPlannerPlan.getCompanyId()));
        File file = this._getFile(batchPlannerPlan.getBatchPlannerPlanId());
        CreateStrategy createStrategy = CreateStrategy.getDefaultCreateStrategy();
        String value = this._getValue(batchPlannerPlan.fetchBatchPlannerPolicy("createStrategy"));
        if (value != null) {
            createStrategy = CreateStrategy.valueOf((String)value);
        }
        try {
            if (createStrategy == CreateStrategy.INSERT || createStrategy == CreateStrategy.UPSERT) {
                importTaskResource.postImportTask(batchPlannerPlan.getInternalClassName(), null, null, null, createStrategy.name(), String.valueOf(batchPlannerPlan.getBatchPlannerPlanId()), this._getFieldNameMapping(this._batchPlannerMappingLocalService.getBatchPlannerMappings(batchPlannerPlan.getBatchPlannerPlanId())), this._getImportErrorStrategy(batchPlannerPlan), batchPlannerPlan.getTaskItemDelegateName(), MultipartBody.of(Collections.singletonMap("file", new BinaryFile(BatchPlannerPlanConstants.getContentType((String)batchPlannerPlan.getExternalType()), file.getName(), (InputStream)new FileInputStream(file), file.length())), null, Collections.emptyMap()));
                return;
            }
            importTaskResource.putImportTask(batchPlannerPlan.getInternalClassName(), null, String.valueOf(batchPlannerPlan.getBatchPlannerPlanId()), this._getImportErrorStrategy(batchPlannerPlan), batchPlannerPlan.getTaskItemDelegateName(), null, MultipartBody.of(Collections.singletonMap("file", new BinaryFile(BatchPlannerPlanConstants.getContentType((String)batchPlannerPlan.getExternalType()), file.getName(), (InputStream)new FileInputStream(file), file.length())), null, Collections.emptyMap()));
        }
        finally {
            this._file.delete(file);
        }
    }
}

