/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.internal.notifications;

import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.BaseUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import jakarta.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"jakarta.portlet.name=com_liferay_batch_planner_web_internal_portlet_BatchPlannerPortlet"}, service={UserNotificationHandler.class})
public class BatchPlannerUserNotificationHandler
extends BaseUserNotificationHandler {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    public BatchPlannerUserNotificationHandler() {
        this.setPortletId("com_liferay_batch_planner_web_internal_portlet_BatchPlannerPortlet");
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(userNotificationEvent.getPayload());
        String className = jsonObject.getString("className");
        String fileName = jsonObject.getString("fileName");
        String status = jsonObject.getString("status");
        String taskType = jsonObject.getString("taskType");
        return StringBundler.concat((String[])new String[]{"<h2 class=\"title\">", this._getTitle(className, serviceContext, status, taskType), "</h2><div class=\"body\">", this._getBody(className, fileName, serviceContext, status, taskType), "</div>"});
    }

    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return PortletURLBuilder.create((PortletURL)this._portal.getControlPanelPortletURL(serviceContext.getRequest(), serviceContext.getScopeGroup(), "com_liferay_batch_planner_web_internal_portlet_BatchPlannerPortlet", 0L, 0L, "RENDER_PHASE")).setMVCRenderCommandName("/batch_planner/view_batch_planner_plan").setBackURL(serviceContext.getCurrentURL()).setParameter("batchPlannerPlanId", () -> {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(userNotificationEvent.getPayload());
            return jsonObject.getLong("batchPlannerPlanId");
        }).buildString();
    }

    protected String getTitle(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(userNotificationEvent.getPayload());
        String className = jsonObject.getString("className");
        String status = jsonObject.getString("status");
        String taskType = jsonObject.getString("taskType");
        return this._getTitle(className, serviceContext, status, taskType);
    }

    private String _getBody(String className, String fileName, ServiceContext serviceContext, String status, String taskType) {
        if (status.equals(BatchEngineTaskExecuteStatus.COMPLETED.name())) {
            if (taskType.equals("export")) {
                return serviceContext.translate("x-were-exported-to-a-zip-file", new Object[]{this._getSimpleClassNamePlural(className)});
            }
            return serviceContext.translate("x-from-x-were-imported-to-the-x-entity", new Object[]{this._getSimpleClassNamePlural(className), fileName, StringUtil.toLowerCase((String)this._getSimpleClassName(className))});
        }
        if (status.equals(BatchEngineTaskExecuteStatus.FAILED.name())) {
            if (taskType.equals("export")) {
                return serviceContext.translate("x-entity-export-encountered-an-error-while-exporting-to-a-zip-file", new Object[]{this._getSimpleClassName(className)});
            }
            return serviceContext.translate("x-encountered-an-error-while-importing-to-the-x-entity", new Object[]{fileName, StringUtil.toLowerCase((String)this._getSimpleClassName(className))});
        }
        throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"No batch planner user notification found for status ", status, " and task type ", taskType}));
    }

    private String _getSimpleClassName(String className) {
        return className.substring(className.lastIndexOf(".") + 1);
    }

    private String _getSimpleClassNamePlural(String className) {
        return TextFormatter.formatPlural((String)this._getSimpleClassName(className));
    }

    private String _getTitle(String className, ServiceContext serviceContext, String status, String taskType) {
        if (status.equals(BatchEngineTaskExecuteStatus.COMPLETED.name())) {
            if (taskType.equals("export")) {
                return serviceContext.translate("x-exported", new Object[]{this._getSimpleClassNamePlural(className)});
            }
            return serviceContext.translate("x-imported", new Object[]{this._getSimpleClassNamePlural(className)});
        }
        if (status.equals(BatchEngineTaskExecuteStatus.FAILED.name())) {
            if (taskType.equals("export")) {
                return serviceContext.translate("x-export-stopped", new Object[]{this._getSimpleClassNamePlural(className)});
            }
            return serviceContext.translate("x-import-stopped", new Object[]{this._getSimpleClassNamePlural(className)});
        }
        throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"No batch planner user notification found for status ", status, " and task type ", taskType}));
    }
}

