/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.internal.model.listener;

import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.planner.constants.BatchPlannerPlanConstants;
import com.liferay.batch.planner.internal.notifications.BatchPlannerNotificationSender;
import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.service.BatchPlannerPlanLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.GetterUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class BatchEngineImportTaskModelListener
extends BaseModelListener<BatchEngineImportTask> {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineImportTaskModelListener.class);
    private final BatchPlannerNotificationSender _batchPlannerNotificationSender = new BatchPlannerNotificationSender("import");
    @Reference
    private BatchPlannerPlanLocalService _batchPlannerPlanLocalService;
    @Reference
    private File _file;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public void onAfterRemove(BatchEngineImportTask batchEngineImportTask) throws ModelListenerException {
        try {
            this._batchPlannerPlanLocalService.deactivateBatchPlannerPlan(batchEngineImportTask.getExternalReferenceCode());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public void onAfterUpdate(BatchEngineImportTask originalBatchEngineImportTask, BatchEngineImportTask batchEngineImportTask) throws ModelListenerException {
        BatchPlannerPlan batchPlannerPlan = this._updateStatus(batchEngineImportTask);
        if (batchPlannerPlan == null) {
            return;
        }
        BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus = BatchEngineTaskExecuteStatus.valueOf((String)batchEngineImportTask.getExecuteStatus());
        if (batchEngineTaskExecuteStatus == BatchEngineTaskExecuteStatus.COMPLETED || batchEngineTaskExecuteStatus == BatchEngineTaskExecuteStatus.FAILED) {
            this._notify(batchEngineTaskExecuteStatus, batchPlannerPlan);
        }
    }

    @Activate
    protected void activate() {
        this._batchPlannerNotificationSender.setUserNotificationEventLocalService(this._userNotificationEventLocalService);
    }

    private String _getFileName(String externalURL) {
        String fileName = this._file.getShortFileName(externalURL);
        return fileName.replaceAll("(.+)-(.+)\\.(\\w+)", "$1.$3");
    }

    private int _getStatus(BatchEngineImportTask batchEngineImportTask) {
        int batchEngineImportTaskErrorsCount;
        int status = BatchPlannerPlanConstants.getStatus((BatchEngineTaskExecuteStatus)BatchEngineTaskExecuteStatus.valueOf((String)batchEngineImportTask.getExecuteStatus()));
        if (status == 3 && (batchEngineImportTaskErrorsCount = batchEngineImportTask.getBatchEngineImportTaskErrorsCount()) > 0) {
            int totalItemsCount = batchEngineImportTask.getTotalItemsCount();
            status = batchEngineImportTaskErrorsCount < totalItemsCount ? 5 : 4;
        }
        return status;
    }

    private void _notify(BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus, BatchPlannerPlan batchPlannerPlan) {
        this._batchPlannerNotificationSender.sendUserNotificationEvents(batchPlannerPlan.getUserId(), "com_liferay_batch_planner_web_internal_portlet_BatchPlannerPortlet", 10002, this._batchPlannerNotificationSender.getNotificationEventJSONObject(batchEngineTaskExecuteStatus, batchPlannerPlan.getBatchPlannerPlanId(), batchPlannerPlan.getInternalClassName(), this._getFileName(batchPlannerPlan.getExternalURL())));
    }

    private BatchPlannerPlan _updateStatus(BatchEngineImportTask batchEngineImportTask) {
        BatchPlannerPlan batchPlannerPlan = this._batchPlannerPlanLocalService.fetchBatchPlannerPlan(GetterUtil.getLong((String)batchEngineImportTask.getExternalReferenceCode()));
        if (batchPlannerPlan == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No batch planner plan found for ID " + batchEngineImportTask.getExternalReferenceCode()));
            }
            return null;
        }
        try {
            return this._batchPlannerPlanLocalService.updateStatus(batchPlannerPlan.getBatchPlannerPlanId(), this._getStatus(batchEngineImportTask));
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return null;
        }
    }
}

