/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.service.impl;

import com.liferay.batch.planner.exception.BatchPlannerPlanNameException;
import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.model.BatchPlannerPolicy;
import com.liferay.batch.planner.service.base.BatchPlannerPolicyLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.batch.planner.model.BatchPlannerPolicy"}, service={AopService.class})
public class BatchPlannerPolicyLocalServiceImpl
extends BatchPlannerPolicyLocalServiceBaseImpl {
    public BatchPlannerPolicy addBatchPlannerPolicy(long userId, long batchPlannerPlanId, String name, String value) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new BatchPlannerPlanNameException("Batch planner policy name is null for batch planner plan ID " + batchPlannerPlanId);
        }
        BatchPlannerPlan batchPlannerPlan = this.batchPlannerPlanPersistence.findByPrimaryKey(batchPlannerPlanId);
        BatchPlannerPolicy batchPlannerPolicy = this.batchPlannerPolicyPersistence.create(this.counterLocalService.increment());
        batchPlannerPolicy.setCompanyId(batchPlannerPlan.getCompanyId());
        batchPlannerPolicy.setUserId(userId);
        User user = this.userLocalService.getUser(userId);
        batchPlannerPolicy.setUserName(user.getFullName());
        batchPlannerPolicy.setBatchPlannerPlanId(batchPlannerPlan.getBatchPlannerPlanId());
        batchPlannerPolicy.setName(StringUtil.trim((String)name));
        batchPlannerPolicy.setValue(StringUtil.trim((String)value));
        return (BatchPlannerPolicy)this.batchPlannerPolicyPersistence.update((BaseModel)batchPlannerPolicy);
    }

    public BatchPlannerPolicy deleteBatchPlannerPolicy(long batchPlannerPlanId, String name) throws PortalException {
        return this.batchPlannerPolicyPersistence.removeByBPPI_N(batchPlannerPlanId, name);
    }

    public List<BatchPlannerPolicy> getBatchPlannerPolicies(long batchPlannerPlanId) {
        return this.batchPlannerPolicyPersistence.findByBatchPlannerPlanId(batchPlannerPlanId);
    }

    public BatchPlannerPolicy getBatchPlannerPolicy(long batchPlannerPlanId, String name) throws PortalException {
        return this.batchPlannerPolicyPersistence.findByBPPI_N(batchPlannerPlanId, name);
    }

    public boolean hasBatchPlannerPolicy(long batchPlannerPlanId, String name) {
        BatchPlannerPolicy batchPlannerPolicy = this.batchPlannerPolicyPersistence.fetchByBPPI_N(batchPlannerPlanId, name);
        return batchPlannerPolicy != null;
    }

    public BatchPlannerPolicy updateBatchPlannerPolicy(long batchPlannerPlanId, String name, String value) throws PortalException {
        BatchPlannerPolicy batchPlannerPolicy = this.batchPlannerPolicyPersistence.findByBPPI_N(batchPlannerPlanId, name);
        batchPlannerPolicy.setValue(StringUtil.trim((String)value));
        return (BatchPlannerPolicy)this.batchPlannerPolicyPersistence.update((BaseModel)batchPlannerPolicy);
    }
}

