/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.service.impl;

import com.liferay.batch.planner.model.BatchPlannerLog;
import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.service.base.BatchPlannerLogServiceBaseImpl;
import com.liferay.batch.planner.service.impl.BatchPlannerPlanServiceImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"json.web.service.context.name=batchplanner", "json.web.service.context.path=BatchPlannerLog"}, service={AopService.class})
public class BatchPlannerLogServiceImpl
extends BatchPlannerLogServiceBaseImpl {
    private static volatile ModelResourcePermission<BatchPlannerPlan> _batchPlannerPlanModelResourcePermission = ModelResourcePermissionFactory.getInstance(BatchPlannerPlanServiceImpl.class, (String)"_batchPlannerPlanModelResourcePermission", BatchPlannerPlan.class);

    public BatchPlannerLog addBatchPlannerLog(long batchPlannerPlanId, String batchEngineExportERC, String batchEngineImportERC, String dispatchTriggerERC, int size, int status) throws PortalException {
        _batchPlannerPlanModelResourcePermission.check(this.getPermissionChecker(), batchPlannerPlanId, "UPDATE");
        return this.batchPlannerLogLocalService.addBatchPlannerLog(this.getUserId(), batchPlannerPlanId, batchEngineExportERC, batchEngineImportERC, dispatchTriggerERC, size, status);
    }

    public BatchPlannerLog deleteBatchPlannerLog(long batchPlannerLogId) throws PortalException {
        BatchPlannerLog batchPlannerLog = this.batchPlannerLogPersistence.findByPrimaryKey(batchPlannerLogId);
        _batchPlannerPlanModelResourcePermission.check(this.getPermissionChecker(), batchPlannerLog.getBatchPlannerPlanId(), "UPDATE");
        return this.batchPlannerLogLocalService.deleteBatchPlannerLog(batchPlannerLogId);
    }

    public BatchPlannerLog getBatchPlannerLog(long batchPlannerLogId) throws PortalException {
        BatchPlannerLog batchPlannerLog = this.batchPlannerLogPersistence.fetchByPrimaryKey(batchPlannerLogId);
        _batchPlannerPlanModelResourcePermission.check(this.getPermissionChecker(), batchPlannerLog.getBatchPlannerPlanId(), "VIEW");
        return batchPlannerLog;
    }

    public int getBatchPlannerLogsCount(long batchPlannerPlanId) throws PortalException {
        _batchPlannerPlanModelResourcePermission.check(this.getPermissionChecker(), batchPlannerPlanId, "VIEW");
        return this.batchPlannerLogLocalService.getBatchPlannerLogsCount(batchPlannerPlanId);
    }

    public BatchPlannerLog getBatchPlannerPlanBatchPlannerLog(long batchPlannerPlanId) throws PortalException {
        _batchPlannerPlanModelResourcePermission.check(this.getPermissionChecker(), batchPlannerPlanId, "VIEW");
        return this.batchPlannerLogLocalService.getBatchPlannerPlanBatchPlannerLog(batchPlannerPlanId);
    }

    public List<BatchPlannerLog> getCompanyBatchPlannerLogs(long companyId, boolean export, int start, int end, OrderByComparator<BatchPlannerLog> orderByComparator) throws PortalException {
        this.checkPermission(companyId, "VIEW");
        return this.batchPlannerLogLocalService.getCompanyBatchPlannerLogs(companyId, export, start, end, orderByComparator);
    }

    public List<BatchPlannerLog> getCompanyBatchPlannerLogs(long companyId, int start, int end, OrderByComparator<BatchPlannerLog> orderByComparator) throws PortalException {
        this.checkPermission(companyId, "VIEW");
        return this.batchPlannerLogLocalService.getCompanyBatchPlannerLogs(companyId, start, end, orderByComparator);
    }

    public int getCompanyBatchPlannerLogsCount(long companyId) throws PortalException {
        this.checkPermission(companyId, "VIEW");
        return this.batchPlannerLogLocalService.getCompanyBatchPlannerLogsCount(companyId);
    }

    public int getCompanyBatchPlannerLogsCount(long companyId, boolean export) throws PortalException {
        this.checkPermission(companyId, "VIEW");
        return this.batchPlannerLogLocalService.getCompanyBatchPlannerLogsCount(companyId, export);
    }

    protected void checkPermission(long companyId, String actionKey) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.hasPermission(0L, BatchPlannerPlan.class.getName(), companyId, actionKey)) {
            throw new PrincipalException.MustHavePermission(this.getUserId(), new String[]{actionKey});
        }
    }
}

