/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.service.impl;

import com.liferay.batch.planner.exception.BatchPlannerLogBatchEngineExportTaskERCException;
import com.liferay.batch.planner.exception.BatchPlannerLogBatchEngineImportTaskERCException;
import com.liferay.batch.planner.model.BatchPlannerLog;
import com.liferay.batch.planner.model.BatchPlannerLogTable;
import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.model.BatchPlannerPlanTable;
import com.liferay.batch.planner.service.base.BatchPlannerLogLocalServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.batch.planner.model.BatchPlannerLog"}, service={AopService.class})
public class BatchPlannerLogLocalServiceImpl
extends BatchPlannerLogLocalServiceBaseImpl {
    public BatchPlannerLog addBatchPlannerLog(long userId, long batchPlannerPlanId, String batchEngineExportERC, String batchEngineImportERC, String dispatchTriggerERC, int size, int status) throws PortalException {
        int maxLength;
        BatchPlannerPlan batchPlannerPlan = this.batchPlannerPlanPersistence.findByPrimaryKey(batchPlannerPlanId);
        if (batchPlannerPlan.isExport()) {
            if (Validator.isNotNull((String)batchEngineImportERC)) {
                throw new BatchPlannerLogBatchEngineImportTaskERCException("Batch engine import task external reference code must not be set during export");
            }
            if (Validator.isNull((String)batchEngineExportERC)) {
                throw new BatchPlannerLogBatchEngineExportTaskERCException("Batch engine export task external reference code must be set during export");
            }
            maxLength = ModelHintsUtil.getMaxLength((String)BatchPlannerLog.class.getName(), (String)"batchEngineExportERC");
            if (batchEngineExportERC.length() > maxLength) {
                throw new BatchPlannerLogBatchEngineExportTaskERCException("Batch engine export task external reference code is too long");
            }
        } else {
            if (Validator.isNotNull((String)batchEngineExportERC)) {
                throw new BatchPlannerLogBatchEngineExportTaskERCException("Batch engine export task external reference code must not be set during import");
            }
            if (Validator.isNull((String)batchEngineImportERC)) {
                throw new BatchPlannerLogBatchEngineImportTaskERCException("Batch engine import task external reference code must be set during import");
            }
            maxLength = ModelHintsUtil.getMaxLength((String)BatchPlannerLog.class.getName(), (String)"batchEngineImportERC");
            if (batchEngineImportERC.length() > maxLength) {
                throw new BatchPlannerLogBatchEngineImportTaskERCException("Batch engine import task external reference code is too long");
            }
        }
        BatchPlannerLog batchPlannerLog = this.batchPlannerLogPersistence.create(this.counterLocalService.increment(BatchPlannerLog.class.getName()));
        User user = this.userLocalService.getUser(userId);
        batchPlannerLog.setCompanyId(user.getCompanyId());
        batchPlannerLog.setUserId(userId);
        batchPlannerLog.setBatchPlannerPlanId(batchPlannerPlanId);
        batchPlannerLog.setBatchEngineExportTaskERC(batchEngineExportERC);
        batchPlannerLog.setBatchEngineImportTaskERC(batchEngineImportERC);
        batchPlannerLog.setDispatchTriggerERC(dispatchTriggerERC);
        batchPlannerLog.setSize(size);
        batchPlannerLog.setStatus(status);
        return (BatchPlannerLog)this.batchPlannerLogPersistence.update((BaseModel)batchPlannerLog);
    }

    public BatchPlannerLog fetchBatchPlannerPlanBatchPlannerLog(long batchPlannerPlanId) {
        return this.batchPlannerLogPersistence.fetchByBatchPlannerPlanId(batchPlannerPlanId);
    }

    public int getBatchPlannerLogsCount(long batchPlannerPlanId) {
        return this.batchPlannerLogPersistence.countByBatchPlannerPlanId(batchPlannerPlanId);
    }

    public BatchPlannerLog getBatchPlannerPlanBatchPlannerLog(long batchPlannerPlanId) throws PortalException {
        return this.batchPlannerLogPersistence.findByBatchPlannerPlanId(batchPlannerPlanId);
    }

    public List<BatchPlannerLog> getCompanyBatchPlannerLogs(long companyId, boolean export, int start, int end, OrderByComparator<BatchPlannerLog> orderByComparator) {
        return (List)this.batchPlannerLogPersistence.dslQuery(DSLQueryFactoryUtil.select((Table)BatchPlannerLogTable.INSTANCE).from((Table)BatchPlannerLogTable.INSTANCE).innerJoinON((Table)BatchPlannerPlanTable.INSTANCE, BatchPlannerLogTable.INSTANCE.batchPlannerPlanId.eq((Expression)BatchPlannerPlanTable.INSTANCE.batchPlannerPlanId)).where(this._getPredicate(companyId, export)).orderBy((Table)BatchPlannerLogTable.INSTANCE, orderByComparator).limit(start, end));
    }

    public List<BatchPlannerLog> getCompanyBatchPlannerLogs(long companyId, int start, int end, OrderByComparator<BatchPlannerLog> orderByComparator) {
        return this.batchPlannerLogPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getCompanyBatchPlannerLogsCount(long companyId) {
        return this.batchPlannerLogPersistence.countByCompanyId(companyId);
    }

    public int getCompanyBatchPlannerLogsCount(long companyId, boolean export) {
        return this.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)BatchPlannerLogTable.INSTANCE).innerJoinON((Table)BatchPlannerPlanTable.INSTANCE, BatchPlannerLogTable.INSTANCE.batchPlannerPlanId.eq((Expression)BatchPlannerPlanTable.INSTANCE.batchPlannerPlanId)).where(this._getPredicate(companyId, export)));
    }

    public BatchPlannerLog updateBatchPlannerLogSize(long batchPlannerLogId, int size) throws PortalException {
        BatchPlannerLog batchPlannerLog = this.batchPlannerLogPersistence.findByPrimaryKey(batchPlannerLogId);
        batchPlannerLog.setSize(size);
        return (BatchPlannerLog)this.batchPlannerLogPersistence.update((BaseModel)batchPlannerLog);
    }

    public BatchPlannerLog updateBatchPlannerLogStatus(long batchPlannerLogId, int status) throws PortalException {
        BatchPlannerLog batchPlannerLog = this.batchPlannerLogPersistence.findByPrimaryKey(batchPlannerLogId);
        batchPlannerLog.setStatus(status);
        return (BatchPlannerLog)this.batchPlannerLogPersistence.update((BaseModel)batchPlannerLog);
    }

    private Predicate _getPredicate(long companyId, boolean export) {
        return BatchPlannerLogTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)BatchPlannerPlanTable.INSTANCE.export.eq((Object)export));
    }
}

