/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.internal.batch.engine.broker;

import com.liferay.batch.planner.batch.engine.broker.BatchEngineBroker;
import com.liferay.batch.planner.exception.BatchPlannerMappingExternalFieldNameException;
import com.liferay.batch.planner.internal.jaxrs.uri.EmptyUriInfo;
import com.liferay.batch.planner.model.BatchPlannerMapping;
import com.liferay.batch.planner.model.BatchPlannerMappingModel;
import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.model.BatchPlannerPolicy;
import com.liferay.batch.planner.service.BatchPlannerLogLocalService;
import com.liferay.batch.planner.service.BatchPlannerMappingLocalService;
import com.liferay.batch.planner.service.BatchPlannerPlanLocalService;
import com.liferay.batch.planner.service.BatchPlannerPolicyLocalService;
import com.liferay.headless.batch.engine.dto.v1_0.ExportTask;
import com.liferay.headless.batch.engine.dto.v1_0.ImportTask;
import com.liferay.headless.batch.engine.resource.v1_0.ExportTaskResource;
import com.liferay.headless.batch.engine.resource.v1_0.ImportTaskResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BatchEngineBroker.class})
public class BatchEngineBrokerImpl
implements BatchEngineBroker {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineBrokerImpl.class);
    @Reference
    private BatchPlannerLogLocalService _batchPlannerLogLocalService;
    @Reference
    private BatchPlannerMappingLocalService _batchPlannerMappingLocalService;
    @Reference
    private BatchPlannerPlanLocalService _batchPlannerPlanLocalService;
    @Reference
    private BatchPlannerPolicyLocalService _batchPlannerPolicyLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ExportTaskResource _exportTaskResource;
    @Reference
    private ImportTaskResource _importTaskResource;
    @Reference
    private UserLocalService _userLocalService;

    public void submit(long batchPlannerPlanId) {
        try {
            BatchPlannerPlan batchPlannerPlan = this._batchPlannerPlanLocalService.getBatchPlannerPlan(batchPlannerPlanId);
            if (batchPlannerPlan.isExport()) {
                this._submitExportTask(batchPlannerPlan);
            } else {
                this._submitImportTask(batchPlannerPlan);
            }
            this._batchPlannerPlanLocalService.updateActive(batchPlannerPlanId, true);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to execute batch planner plan ID " + batchPlannerPlanId), (Throwable)exception);
        }
    }

    private String _getBatchPlannerPolicyValue(List<BatchPlannerPolicy> batchPlannerPolicies, String name) {
        for (BatchPlannerPolicy batchPlannerPolicy : batchPlannerPolicies) {
            if (!Objects.equals(batchPlannerPolicy.getName(), name)) continue;
            return batchPlannerPolicy.getValue();
        }
        return null;
    }

    private String[] _getHeaderNames(List<BatchPlannerMapping> batchPlannerMappings, String delimiter, String headerNamesString) {
        if (Validator.isNull((String)headerNamesString)) {
            return this._getHeaderNames(batchPlannerMappings, (UnsafeFunction<BatchPlannerMapping, String, Exception>)((UnsafeFunction)BatchPlannerMappingModel::getExternalFieldName));
        }
        Object[] headerNames = headerNamesString.split(delimiter);
        if (batchPlannerMappings.size() != headerNames.length) {
            return this._getHeaderNames(batchPlannerMappings, (UnsafeFunction<BatchPlannerMapping, String, Exception>)((UnsafeFunction)BatchPlannerMappingModel::getExternalFieldName));
        }
        for (BatchPlannerMapping batchPlannerMapping : batchPlannerMappings) {
            if (ArrayUtil.contains((Object[])headerNames, (Object)batchPlannerMapping.getExternalFieldName())) continue;
            return this._getHeaderNames(batchPlannerMappings, (UnsafeFunction<BatchPlannerMapping, String, Exception>)((UnsafeFunction)BatchPlannerMappingModel::getExternalFieldName));
        }
        return headerNames;
    }

    private String[] _getHeaderNames(List<BatchPlannerMapping> batchPlannerMappings, UnsafeFunction<BatchPlannerMapping, String, Exception> unsafeFunction) {
        return (String[])TransformUtil.transformToArray(batchPlannerMappings, unsafeFunction, String.class);
    }

    private void _submitExportTask(BatchPlannerPlan batchPlannerPlan) throws Exception {
        this._exportTaskResource.setContextCompany(this._companyLocalService.getCompany(batchPlannerPlan.getCompanyId()));
        this._exportTaskResource.setContextUriInfo((UriInfo)new EmptyUriInfo(batchPlannerPlan.getTaskItemDelegateName()));
        this._exportTaskResource.setContextUser(this._userLocalService.getUser(batchPlannerPlan.getUserId()));
        List batchPlannerMappings = this._batchPlannerMappingLocalService.getBatchPlannerMappings(batchPlannerPlan.getBatchPlannerPlanId());
        Object[] headerNames = this._getHeaderNames(batchPlannerMappings, (UnsafeFunction<BatchPlannerMapping, String, Exception>)((UnsafeFunction)BatchPlannerMappingModel::getInternalFieldName));
        ExportTask exportTask = this._exportTaskResource.postExportTask(batchPlannerPlan.getInternalClassName(), batchPlannerPlan.getExternalType(), null, StringUtil.merge((Object[])headerNames, (String)","), batchPlannerPlan.getTaskItemDelegateName());
        this._batchPlannerLogLocalService.addBatchPlannerLog(batchPlannerPlan.getUserId(), batchPlannerPlan.getBatchPlannerPlanId(), String.valueOf(exportTask.getId()), null, null, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _submitImportTask(BatchPlannerPlan batchPlannerPlan) throws Exception {
        this._importTaskResource.setContextCompany(this._companyLocalService.getCompany(batchPlannerPlan.getCompanyId()));
        this._importTaskResource.setContextUriInfo((UriInfo)new EmptyUriInfo(batchPlannerPlan.getTaskItemDelegateName()));
        this._importTaskResource.setContextUser(this._userLocalService.getUser(batchPlannerPlan.getUserId()));
        File jsonlFile = FileUtil.createTempFile((String)String.valueOf(batchPlannerPlan.getBatchPlannerPlanId()), (String)"jsonl");
        try {
            this._writeJSONLFile(batchPlannerPlan.getBatchPlannerPlanId(), jsonlFile);
            ImportTask importTask = this._importTaskResource.postImportTask(batchPlannerPlan.getInternalClassName(), null, null, batchPlannerPlan.getTaskItemDelegateName(), MultipartBody.of(Collections.singletonMap("file", new BinaryFile("application/json", jsonlFile.getName(), (InputStream)new FileInputStream(jsonlFile), jsonlFile.length())), null, Collections.emptyMap()));
            this._batchPlannerLogLocalService.addBatchPlannerLog(batchPlannerPlan.getUserId(), batchPlannerPlan.getBatchPlannerPlanId(), null, String.valueOf(importTask.getId()), null, (int)jsonlFile.length(), 1);
        }
        finally {
            FileUtil.delete((File)jsonlFile);
        }
    }

    private Map<Integer, BatchPlannerMapping> _toBatchPlannerMappingsMap(List<BatchPlannerMapping> batchPlannerMappings, String delimiter, String headerNamesString) throws PortalException {
        HashMap<Integer, BatchPlannerMapping> batchPlannerMappingsMap = new HashMap<Integer, BatchPlannerMapping>();
        String[] headerNames = this._getHeaderNames(batchPlannerMappings, delimiter, headerNamesString);
        block0: for (BatchPlannerMapping batchPlannerMapping : batchPlannerMappings) {
            for (int i = 0; i < headerNames.length; ++i) {
                if (!Objects.equals(batchPlannerMapping.getExternalFieldName(), headerNames[i])) continue;
                batchPlannerMappingsMap.put(i, batchPlannerMapping);
                continue block0;
            }
        }
        if (batchPlannerMappingsMap.isEmpty()) {
            throw new BatchPlannerMappingExternalFieldNameException("Unable to map external field names to header names");
        }
        return batchPlannerMappingsMap;
    }

    private String _toJSON(Map<Integer, BatchPlannerMapping> batchPlannerMappingsMap, String[] columns) {
        StringBundler sb = new StringBundler(2 + batchPlannerMappingsMap.size() * 6);
        sb.append('{');
        Set<Map.Entry<Integer, BatchPlannerMapping>> set = batchPlannerMappingsMap.entrySet();
        Iterator<Map.Entry<Integer, BatchPlannerMapping>> iterator = set.iterator();
        while (iterator.hasNext()) {
            sb.append('\"');
            Map.Entry<Integer, BatchPlannerMapping> entry = iterator.next();
            BatchPlannerMapping batchPlannerMapping = entry.getValue();
            sb.append(batchPlannerMapping.getInternalFieldName());
            sb.append("\": \"");
            sb.append(columns[entry.getKey()]);
            sb.append('\"');
            if (!iterator.hasNext()) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    private void _writeJSONLFile(long batchPlannerPlanId, File jsonlFile) throws Exception {
        BatchPlannerPlan batchPlannerPlan = this._batchPlannerPlanLocalService.getBatchPlannerPlan(batchPlannerPlanId);
        try (FileReader fileReader = new FileReader(new File(new URI(batchPlannerPlan.getExternalURL())));
             FileWriter fileWriter = new FileWriter(jsonlFile);){
            List batchPlannerPolicies = this._batchPlannerPolicyLocalService.getBatchPlannerPolicies(batchPlannerPlanId);
            String delimiter = GetterUtil.getString((String)this._getBatchPlannerPolicyValue(batchPlannerPolicies, "delimiter"), (String)";");
            String line = null;
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            if (GetterUtil.getBoolean((String)this._getBatchPlannerPolicyValue(batchPlannerPolicies, "containsHeaders"))) {
                line = bufferedReader.readLine();
            }
            Map<Integer, BatchPlannerMapping> batchPlannerMappingsMap = this._toBatchPlannerMappingsMap(this._batchPlannerMappingLocalService.getBatchPlannerMappings(batchPlannerPlanId), delimiter, line);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            line = bufferedReader.readLine();
            while (line != null) {
                bufferedWriter.append(this._toJSON(batchPlannerMappingsMap, line.split(delimiter)));
                bufferedWriter.newLine();
                line = bufferedReader.readLine();
            }
            bufferedWriter.flush();
        }
    }
}

