/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.batch.planner.model.impl;

import com.liferay.batch.planner.model.BatchPlannerPolicy;
import com.liferay.batch.planner.model.BatchPlannerPolicyModel;
import com.liferay.batch.planner.model.BatchPlannerPolicySoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the BatchPlannerPolicy service. Represents a row in the &quot;BatchPlannerPolicy&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>BatchPlannerPolicyModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BatchPlannerPolicyImpl}.
 * </p>
 *
 * @author Igor Beslic
 * @see BatchPlannerPolicyImpl
 * @generated
 */
@JSON(strict = true)
public class BatchPlannerPolicyModelImpl
	extends BaseModelImpl<BatchPlannerPolicy>
	implements BatchPlannerPolicyModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a batch planner policy model instance should use the <code>BatchPlannerPolicy</code> interface instead.
	 */
	public static final String TABLE_NAME = "BatchPlannerPolicy";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"batchPlannerPolicyId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"batchPlannerPlanId", Types.BIGINT},
		{"name", Types.VARCHAR}, {"value", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("batchPlannerPolicyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("batchPlannerPlanId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("value", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table BatchPlannerPolicy (mvccVersion LONG default 0 not null,batchPlannerPolicyId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,batchPlannerPlanId LONG,name VARCHAR(75) null,value VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table BatchPlannerPolicy";

	public static final String ORDER_BY_JPQL =
		" ORDER BY batchPlannerPolicy.modifiedDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY BatchPlannerPolicy.modifiedDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long BATCHPLANNERPLANID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MODIFIEDDATE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static BatchPlannerPolicy toModel(BatchPlannerPolicySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		BatchPlannerPolicy model = new BatchPlannerPolicyImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setBatchPlannerPolicyId(soapModel.getBatchPlannerPolicyId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setBatchPlannerPlanId(soapModel.getBatchPlannerPlanId());
		model.setName(soapModel.getName());
		model.setValue(soapModel.getValue());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<BatchPlannerPolicy> toModels(
		BatchPlannerPolicySoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<BatchPlannerPolicy> models = new ArrayList<BatchPlannerPolicy>(
			soapModels.length);

		for (BatchPlannerPolicySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public BatchPlannerPolicyModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _batchPlannerPolicyId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setBatchPlannerPolicyId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _batchPlannerPolicyId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return BatchPlannerPolicy.class;
	}

	@Override
	public String getModelClassName() {
		return BatchPlannerPolicy.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<BatchPlannerPolicy, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<BatchPlannerPolicy, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<BatchPlannerPolicy, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((BatchPlannerPolicy)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<BatchPlannerPolicy, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<BatchPlannerPolicy, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(BatchPlannerPolicy)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<BatchPlannerPolicy, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<BatchPlannerPolicy, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, BatchPlannerPolicy>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			BatchPlannerPolicy.class.getClassLoader(), BatchPlannerPolicy.class,
			ModelWrapper.class);

		try {
			Constructor<BatchPlannerPolicy> constructor =
				(Constructor<BatchPlannerPolicy>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<BatchPlannerPolicy, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<BatchPlannerPolicy, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<BatchPlannerPolicy, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<BatchPlannerPolicy, Object>>();
		Map<String, BiConsumer<BatchPlannerPolicy, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<BatchPlannerPolicy, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", BatchPlannerPolicy::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<BatchPlannerPolicy, Long>)
				BatchPlannerPolicy::setMvccVersion);
		attributeGetterFunctions.put(
			"batchPlannerPolicyId",
			BatchPlannerPolicy::getBatchPlannerPolicyId);
		attributeSetterBiConsumers.put(
			"batchPlannerPolicyId",
			(BiConsumer<BatchPlannerPolicy, Long>)
				BatchPlannerPolicy::setBatchPlannerPolicyId);
		attributeGetterFunctions.put(
			"companyId", BatchPlannerPolicy::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<BatchPlannerPolicy, Long>)
				BatchPlannerPolicy::setCompanyId);
		attributeGetterFunctions.put("userId", BatchPlannerPolicy::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<BatchPlannerPolicy, Long>)
				BatchPlannerPolicy::setUserId);
		attributeGetterFunctions.put(
			"userName", BatchPlannerPolicy::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<BatchPlannerPolicy, String>)
				BatchPlannerPolicy::setUserName);
		attributeGetterFunctions.put(
			"createDate", BatchPlannerPolicy::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<BatchPlannerPolicy, Date>)
				BatchPlannerPolicy::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", BatchPlannerPolicy::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<BatchPlannerPolicy, Date>)
				BatchPlannerPolicy::setModifiedDate);
		attributeGetterFunctions.put(
			"batchPlannerPlanId", BatchPlannerPolicy::getBatchPlannerPlanId);
		attributeSetterBiConsumers.put(
			"batchPlannerPlanId",
			(BiConsumer<BatchPlannerPolicy, Long>)
				BatchPlannerPolicy::setBatchPlannerPlanId);
		attributeGetterFunctions.put("name", BatchPlannerPolicy::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<BatchPlannerPolicy, String>)
				BatchPlannerPolicy::setName);
		attributeGetterFunctions.put("value", BatchPlannerPolicy::getValue);
		attributeSetterBiConsumers.put(
			"value",
			(BiConsumer<BatchPlannerPolicy, String>)
				BatchPlannerPolicy::setValue);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getBatchPlannerPolicyId() {
		return _batchPlannerPolicyId;
	}

	@Override
	public void setBatchPlannerPolicyId(long batchPlannerPolicyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_batchPlannerPolicyId = batchPlannerPolicyId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getBatchPlannerPlanId() {
		return _batchPlannerPlanId;
	}

	@Override
	public void setBatchPlannerPlanId(long batchPlannerPlanId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_batchPlannerPlanId = batchPlannerPlanId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalBatchPlannerPlanId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("batchPlannerPlanId"));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public String getValue() {
		if (_value == null) {
			return "";
		}
		else {
			return _value;
		}
	}

	@Override
	public void setValue(String value) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_value = value;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), BatchPlannerPolicy.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public BatchPlannerPolicy toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, BatchPlannerPolicy>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		BatchPlannerPolicyImpl batchPlannerPolicyImpl =
			new BatchPlannerPolicyImpl();

		batchPlannerPolicyImpl.setMvccVersion(getMvccVersion());
		batchPlannerPolicyImpl.setBatchPlannerPolicyId(
			getBatchPlannerPolicyId());
		batchPlannerPolicyImpl.setCompanyId(getCompanyId());
		batchPlannerPolicyImpl.setUserId(getUserId());
		batchPlannerPolicyImpl.setUserName(getUserName());
		batchPlannerPolicyImpl.setCreateDate(getCreateDate());
		batchPlannerPolicyImpl.setModifiedDate(getModifiedDate());
		batchPlannerPolicyImpl.setBatchPlannerPlanId(getBatchPlannerPlanId());
		batchPlannerPolicyImpl.setName(getName());
		batchPlannerPolicyImpl.setValue(getValue());

		batchPlannerPolicyImpl.resetOriginalValues();

		return batchPlannerPolicyImpl;
	}

	@Override
	public BatchPlannerPolicy cloneWithOriginalValues() {
		BatchPlannerPolicyImpl batchPlannerPolicyImpl =
			new BatchPlannerPolicyImpl();

		batchPlannerPolicyImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		batchPlannerPolicyImpl.setBatchPlannerPolicyId(
			this.<Long>getColumnOriginalValue("batchPlannerPolicyId"));
		batchPlannerPolicyImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		batchPlannerPolicyImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		batchPlannerPolicyImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		batchPlannerPolicyImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		batchPlannerPolicyImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		batchPlannerPolicyImpl.setBatchPlannerPlanId(
			this.<Long>getColumnOriginalValue("batchPlannerPlanId"));
		batchPlannerPolicyImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		batchPlannerPolicyImpl.setValue(
			this.<String>getColumnOriginalValue("value"));

		return batchPlannerPolicyImpl;
	}

	@Override
	public int compareTo(BatchPlannerPolicy batchPlannerPolicy) {
		int value = 0;

		value = DateUtil.compareTo(
			getModifiedDate(), batchPlannerPolicy.getModifiedDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof BatchPlannerPolicy)) {
			return false;
		}

		BatchPlannerPolicy batchPlannerPolicy = (BatchPlannerPolicy)object;

		long primaryKey = batchPlannerPolicy.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<BatchPlannerPolicy> toCacheModel() {
		BatchPlannerPolicyCacheModel batchPlannerPolicyCacheModel =
			new BatchPlannerPolicyCacheModel();

		batchPlannerPolicyCacheModel.mvccVersion = getMvccVersion();

		batchPlannerPolicyCacheModel.batchPlannerPolicyId =
			getBatchPlannerPolicyId();

		batchPlannerPolicyCacheModel.companyId = getCompanyId();

		batchPlannerPolicyCacheModel.userId = getUserId();

		batchPlannerPolicyCacheModel.userName = getUserName();

		String userName = batchPlannerPolicyCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			batchPlannerPolicyCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			batchPlannerPolicyCacheModel.createDate = createDate.getTime();
		}
		else {
			batchPlannerPolicyCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			batchPlannerPolicyCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			batchPlannerPolicyCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		batchPlannerPolicyCacheModel.batchPlannerPlanId =
			getBatchPlannerPlanId();

		batchPlannerPolicyCacheModel.name = getName();

		String name = batchPlannerPolicyCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			batchPlannerPolicyCacheModel.name = null;
		}

		batchPlannerPolicyCacheModel.value = getValue();

		String value = batchPlannerPolicyCacheModel.value;

		if ((value != null) && (value.length() == 0)) {
			batchPlannerPolicyCacheModel.value = null;
		}

		return batchPlannerPolicyCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<BatchPlannerPolicy, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<BatchPlannerPolicy, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<BatchPlannerPolicy, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(BatchPlannerPolicy)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<BatchPlannerPolicy, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<BatchPlannerPolicy, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<BatchPlannerPolicy, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((BatchPlannerPolicy)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, BatchPlannerPolicy>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _batchPlannerPolicyId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _batchPlannerPlanId;
	private String _name;
	private String _value;

	public <T> T getColumnValue(String columnName) {
		Function<BatchPlannerPolicy, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((BatchPlannerPolicy)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"batchPlannerPolicyId", _batchPlannerPolicyId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("batchPlannerPlanId", _batchPlannerPlanId);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("value", _value);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("batchPlannerPolicyId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("batchPlannerPlanId", 128L);

		columnBitmasks.put("name", 256L);

		columnBitmasks.put("value", 512L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private BatchPlannerPolicy _escapedModel;

}