/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.batch.planner.model.impl;

import com.liferay.batch.planner.model.BatchPlannerMapping;
import com.liferay.batch.planner.model.BatchPlannerMappingModel;
import com.liferay.batch.planner.model.BatchPlannerMappingSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the BatchPlannerMapping service. Represents a row in the &quot;BatchPlannerMapping&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>BatchPlannerMappingModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BatchPlannerMappingImpl}.
 * </p>
 *
 * @author Igor Beslic
 * @see BatchPlannerMappingImpl
 * @generated
 */
@JSON(strict = true)
public class BatchPlannerMappingModelImpl
	extends BaseModelImpl<BatchPlannerMapping>
	implements BatchPlannerMappingModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a batch planner mapping model instance should use the <code>BatchPlannerMapping</code> interface instead.
	 */
	public static final String TABLE_NAME = "BatchPlannerMapping";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"batchPlannerMappingId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"batchPlannerPlanId", Types.BIGINT},
		{"externalFieldName", Types.VARCHAR},
		{"externalFieldType", Types.VARCHAR},
		{"internalFieldName", Types.VARCHAR},
		{"internalFieldType", Types.VARCHAR}, {"script", Types.CLOB}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("batchPlannerMappingId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("batchPlannerPlanId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("externalFieldName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalFieldType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("internalFieldName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("internalFieldType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("script", Types.CLOB);
	}

	public static final String TABLE_SQL_CREATE =
		"create table BatchPlannerMapping (mvccVersion LONG default 0 not null,batchPlannerMappingId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,batchPlannerPlanId LONG,externalFieldName VARCHAR(75) null,externalFieldType VARCHAR(75) null,internalFieldName VARCHAR(75) null,internalFieldType VARCHAR(75) null,script TEXT null)";

	public static final String TABLE_SQL_DROP =
		"drop table BatchPlannerMapping";

	public static final String ORDER_BY_JPQL =
		" ORDER BY batchPlannerMapping.modifiedDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY BatchPlannerMapping.modifiedDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long BATCHPLANNERPLANID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALFIELDNAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long INTERNALFIELDNAME_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MODIFIEDDATE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static BatchPlannerMapping toModel(
		BatchPlannerMappingSoap soapModel) {

		if (soapModel == null) {
			return null;
		}

		BatchPlannerMapping model = new BatchPlannerMappingImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setBatchPlannerMappingId(soapModel.getBatchPlannerMappingId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setBatchPlannerPlanId(soapModel.getBatchPlannerPlanId());
		model.setExternalFieldName(soapModel.getExternalFieldName());
		model.setExternalFieldType(soapModel.getExternalFieldType());
		model.setInternalFieldName(soapModel.getInternalFieldName());
		model.setInternalFieldType(soapModel.getInternalFieldType());
		model.setScript(soapModel.getScript());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<BatchPlannerMapping> toModels(
		BatchPlannerMappingSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<BatchPlannerMapping> models = new ArrayList<BatchPlannerMapping>(
			soapModels.length);

		for (BatchPlannerMappingSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public BatchPlannerMappingModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _batchPlannerMappingId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setBatchPlannerMappingId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _batchPlannerMappingId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return BatchPlannerMapping.class;
	}

	@Override
	public String getModelClassName() {
		return BatchPlannerMapping.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<BatchPlannerMapping, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<BatchPlannerMapping, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<BatchPlannerMapping, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((BatchPlannerMapping)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<BatchPlannerMapping, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<BatchPlannerMapping, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(BatchPlannerMapping)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<BatchPlannerMapping, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<BatchPlannerMapping, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, BatchPlannerMapping>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			BatchPlannerMapping.class.getClassLoader(),
			BatchPlannerMapping.class, ModelWrapper.class);

		try {
			Constructor<BatchPlannerMapping> constructor =
				(Constructor<BatchPlannerMapping>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<BatchPlannerMapping, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<BatchPlannerMapping, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<BatchPlannerMapping, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<BatchPlannerMapping, Object>>();
		Map<String, BiConsumer<BatchPlannerMapping, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<BatchPlannerMapping, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", BatchPlannerMapping::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<BatchPlannerMapping, Long>)
				BatchPlannerMapping::setMvccVersion);
		attributeGetterFunctions.put(
			"batchPlannerMappingId",
			BatchPlannerMapping::getBatchPlannerMappingId);
		attributeSetterBiConsumers.put(
			"batchPlannerMappingId",
			(BiConsumer<BatchPlannerMapping, Long>)
				BatchPlannerMapping::setBatchPlannerMappingId);
		attributeGetterFunctions.put(
			"companyId", BatchPlannerMapping::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<BatchPlannerMapping, Long>)
				BatchPlannerMapping::setCompanyId);
		attributeGetterFunctions.put("userId", BatchPlannerMapping::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<BatchPlannerMapping, Long>)
				BatchPlannerMapping::setUserId);
		attributeGetterFunctions.put(
			"userName", BatchPlannerMapping::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<BatchPlannerMapping, String>)
				BatchPlannerMapping::setUserName);
		attributeGetterFunctions.put(
			"createDate", BatchPlannerMapping::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<BatchPlannerMapping, Date>)
				BatchPlannerMapping::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", BatchPlannerMapping::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<BatchPlannerMapping, Date>)
				BatchPlannerMapping::setModifiedDate);
		attributeGetterFunctions.put(
			"batchPlannerPlanId", BatchPlannerMapping::getBatchPlannerPlanId);
		attributeSetterBiConsumers.put(
			"batchPlannerPlanId",
			(BiConsumer<BatchPlannerMapping, Long>)
				BatchPlannerMapping::setBatchPlannerPlanId);
		attributeGetterFunctions.put(
			"externalFieldName", BatchPlannerMapping::getExternalFieldName);
		attributeSetterBiConsumers.put(
			"externalFieldName",
			(BiConsumer<BatchPlannerMapping, String>)
				BatchPlannerMapping::setExternalFieldName);
		attributeGetterFunctions.put(
			"externalFieldType", BatchPlannerMapping::getExternalFieldType);
		attributeSetterBiConsumers.put(
			"externalFieldType",
			(BiConsumer<BatchPlannerMapping, String>)
				BatchPlannerMapping::setExternalFieldType);
		attributeGetterFunctions.put(
			"internalFieldName", BatchPlannerMapping::getInternalFieldName);
		attributeSetterBiConsumers.put(
			"internalFieldName",
			(BiConsumer<BatchPlannerMapping, String>)
				BatchPlannerMapping::setInternalFieldName);
		attributeGetterFunctions.put(
			"internalFieldType", BatchPlannerMapping::getInternalFieldType);
		attributeSetterBiConsumers.put(
			"internalFieldType",
			(BiConsumer<BatchPlannerMapping, String>)
				BatchPlannerMapping::setInternalFieldType);
		attributeGetterFunctions.put("script", BatchPlannerMapping::getScript);
		attributeSetterBiConsumers.put(
			"script",
			(BiConsumer<BatchPlannerMapping, String>)
				BatchPlannerMapping::setScript);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getBatchPlannerMappingId() {
		return _batchPlannerMappingId;
	}

	@Override
	public void setBatchPlannerMappingId(long batchPlannerMappingId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_batchPlannerMappingId = batchPlannerMappingId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getBatchPlannerPlanId() {
		return _batchPlannerPlanId;
	}

	@Override
	public void setBatchPlannerPlanId(long batchPlannerPlanId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_batchPlannerPlanId = batchPlannerPlanId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalBatchPlannerPlanId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("batchPlannerPlanId"));
	}

	@JSON
	@Override
	public String getExternalFieldName() {
		if (_externalFieldName == null) {
			return "";
		}
		else {
			return _externalFieldName;
		}
	}

	@Override
	public void setExternalFieldName(String externalFieldName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalFieldName = externalFieldName;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalFieldName() {
		return getColumnOriginalValue("externalFieldName");
	}

	@JSON
	@Override
	public String getExternalFieldType() {
		if (_externalFieldType == null) {
			return "";
		}
		else {
			return _externalFieldType;
		}
	}

	@Override
	public void setExternalFieldType(String externalFieldType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalFieldType = externalFieldType;
	}

	@JSON
	@Override
	public String getInternalFieldName() {
		if (_internalFieldName == null) {
			return "";
		}
		else {
			return _internalFieldName;
		}
	}

	@Override
	public void setInternalFieldName(String internalFieldName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_internalFieldName = internalFieldName;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalInternalFieldName() {
		return getColumnOriginalValue("internalFieldName");
	}

	@JSON
	@Override
	public String getInternalFieldType() {
		if (_internalFieldType == null) {
			return "";
		}
		else {
			return _internalFieldType;
		}
	}

	@Override
	public void setInternalFieldType(String internalFieldType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_internalFieldType = internalFieldType;
	}

	@JSON
	@Override
	public String getScript() {
		if (_script == null) {
			return "";
		}
		else {
			return _script;
		}
	}

	@Override
	public void setScript(String script) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_script = script;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), BatchPlannerMapping.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public BatchPlannerMapping toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, BatchPlannerMapping>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		BatchPlannerMappingImpl batchPlannerMappingImpl =
			new BatchPlannerMappingImpl();

		batchPlannerMappingImpl.setMvccVersion(getMvccVersion());
		batchPlannerMappingImpl.setBatchPlannerMappingId(
			getBatchPlannerMappingId());
		batchPlannerMappingImpl.setCompanyId(getCompanyId());
		batchPlannerMappingImpl.setUserId(getUserId());
		batchPlannerMappingImpl.setUserName(getUserName());
		batchPlannerMappingImpl.setCreateDate(getCreateDate());
		batchPlannerMappingImpl.setModifiedDate(getModifiedDate());
		batchPlannerMappingImpl.setBatchPlannerPlanId(getBatchPlannerPlanId());
		batchPlannerMappingImpl.setExternalFieldName(getExternalFieldName());
		batchPlannerMappingImpl.setExternalFieldType(getExternalFieldType());
		batchPlannerMappingImpl.setInternalFieldName(getInternalFieldName());
		batchPlannerMappingImpl.setInternalFieldType(getInternalFieldType());
		batchPlannerMappingImpl.setScript(getScript());

		batchPlannerMappingImpl.resetOriginalValues();

		return batchPlannerMappingImpl;
	}

	@Override
	public BatchPlannerMapping cloneWithOriginalValues() {
		BatchPlannerMappingImpl batchPlannerMappingImpl =
			new BatchPlannerMappingImpl();

		batchPlannerMappingImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		batchPlannerMappingImpl.setBatchPlannerMappingId(
			this.<Long>getColumnOriginalValue("batchPlannerMappingId"));
		batchPlannerMappingImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		batchPlannerMappingImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		batchPlannerMappingImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		batchPlannerMappingImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		batchPlannerMappingImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		batchPlannerMappingImpl.setBatchPlannerPlanId(
			this.<Long>getColumnOriginalValue("batchPlannerPlanId"));
		batchPlannerMappingImpl.setExternalFieldName(
			this.<String>getColumnOriginalValue("externalFieldName"));
		batchPlannerMappingImpl.setExternalFieldType(
			this.<String>getColumnOriginalValue("externalFieldType"));
		batchPlannerMappingImpl.setInternalFieldName(
			this.<String>getColumnOriginalValue("internalFieldName"));
		batchPlannerMappingImpl.setInternalFieldType(
			this.<String>getColumnOriginalValue("internalFieldType"));
		batchPlannerMappingImpl.setScript(
			this.<String>getColumnOriginalValue("script"));

		return batchPlannerMappingImpl;
	}

	@Override
	public int compareTo(BatchPlannerMapping batchPlannerMapping) {
		int value = 0;

		value = DateUtil.compareTo(
			getModifiedDate(), batchPlannerMapping.getModifiedDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof BatchPlannerMapping)) {
			return false;
		}

		BatchPlannerMapping batchPlannerMapping = (BatchPlannerMapping)object;

		long primaryKey = batchPlannerMapping.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<BatchPlannerMapping> toCacheModel() {
		BatchPlannerMappingCacheModel batchPlannerMappingCacheModel =
			new BatchPlannerMappingCacheModel();

		batchPlannerMappingCacheModel.mvccVersion = getMvccVersion();

		batchPlannerMappingCacheModel.batchPlannerMappingId =
			getBatchPlannerMappingId();

		batchPlannerMappingCacheModel.companyId = getCompanyId();

		batchPlannerMappingCacheModel.userId = getUserId();

		batchPlannerMappingCacheModel.userName = getUserName();

		String userName = batchPlannerMappingCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			batchPlannerMappingCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			batchPlannerMappingCacheModel.createDate = createDate.getTime();
		}
		else {
			batchPlannerMappingCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			batchPlannerMappingCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			batchPlannerMappingCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		batchPlannerMappingCacheModel.batchPlannerPlanId =
			getBatchPlannerPlanId();

		batchPlannerMappingCacheModel.externalFieldName =
			getExternalFieldName();

		String externalFieldName =
			batchPlannerMappingCacheModel.externalFieldName;

		if ((externalFieldName != null) && (externalFieldName.length() == 0)) {
			batchPlannerMappingCacheModel.externalFieldName = null;
		}

		batchPlannerMappingCacheModel.externalFieldType =
			getExternalFieldType();

		String externalFieldType =
			batchPlannerMappingCacheModel.externalFieldType;

		if ((externalFieldType != null) && (externalFieldType.length() == 0)) {
			batchPlannerMappingCacheModel.externalFieldType = null;
		}

		batchPlannerMappingCacheModel.internalFieldName =
			getInternalFieldName();

		String internalFieldName =
			batchPlannerMappingCacheModel.internalFieldName;

		if ((internalFieldName != null) && (internalFieldName.length() == 0)) {
			batchPlannerMappingCacheModel.internalFieldName = null;
		}

		batchPlannerMappingCacheModel.internalFieldType =
			getInternalFieldType();

		String internalFieldType =
			batchPlannerMappingCacheModel.internalFieldType;

		if ((internalFieldType != null) && (internalFieldType.length() == 0)) {
			batchPlannerMappingCacheModel.internalFieldType = null;
		}

		batchPlannerMappingCacheModel.script = getScript();

		String script = batchPlannerMappingCacheModel.script;

		if ((script != null) && (script.length() == 0)) {
			batchPlannerMappingCacheModel.script = null;
		}

		return batchPlannerMappingCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<BatchPlannerMapping, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<BatchPlannerMapping, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<BatchPlannerMapping, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(BatchPlannerMapping)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<BatchPlannerMapping, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<BatchPlannerMapping, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<BatchPlannerMapping, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((BatchPlannerMapping)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, BatchPlannerMapping>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _batchPlannerMappingId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _batchPlannerPlanId;
	private String _externalFieldName;
	private String _externalFieldType;
	private String _internalFieldName;
	private String _internalFieldType;
	private String _script;

	public <T> T getColumnValue(String columnName) {
		Function<BatchPlannerMapping, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((BatchPlannerMapping)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"batchPlannerMappingId", _batchPlannerMappingId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("batchPlannerPlanId", _batchPlannerPlanId);
		_columnOriginalValues.put("externalFieldName", _externalFieldName);
		_columnOriginalValues.put("externalFieldType", _externalFieldType);
		_columnOriginalValues.put("internalFieldName", _internalFieldName);
		_columnOriginalValues.put("internalFieldType", _internalFieldType);
		_columnOriginalValues.put("script", _script);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("batchPlannerMappingId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("batchPlannerPlanId", 128L);

		columnBitmasks.put("externalFieldName", 256L);

		columnBitmasks.put("externalFieldType", 512L);

		columnBitmasks.put("internalFieldName", 1024L);

		columnBitmasks.put("internalFieldType", 2048L);

		columnBitmasks.put("script", 4096L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private BatchPlannerMapping _escapedModel;

}