/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.planner.model.impl;

import com.liferay.batch.planner.model.BatchPlannerPolicy;
import com.liferay.batch.planner.service.BatchPlannerPolicyLocalServiceUtil;

/**
 * The extended model base implementation for the BatchPlannerPolicy service. Represents a row in the &quot;BatchPlannerPolicy&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BatchPlannerPolicyImpl}.
 * </p>
 *
 * @author Igor Beslic
 * @see BatchPlannerPolicyImpl
 * @see BatchPlannerPolicy
 * @generated
 */
public abstract class BatchPlannerPolicyBaseImpl
	extends BatchPlannerPolicyModelImpl implements BatchPlannerPolicy {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a batch planner policy model instance should use the <code>BatchPlannerPolicy</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			BatchPlannerPolicyLocalServiceUtil.addBatchPlannerPolicy(this);
		}
		else {
			BatchPlannerPolicyLocalServiceUtil.updateBatchPlannerPolicy(this);
		}
	}

}