/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.batch.planner.internal.security.permission.resource;

import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.service.BatchPlannerPlanLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.GroupConstants;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Igor Beslic
 */
@Component(
	property = "model.class.name=com.liferay.batch.planner.model.BatchPlannerPlan",
	service = ModelResourcePermission.class
)
public class BatchPlannerPlanModelResourcePermission
	implements ModelResourcePermission<BatchPlannerPlan> {

	@Override
	public void check(
			PermissionChecker permissionChecker,
			BatchPlannerPlan batchPlannerPlan, String actionId)
		throws PortalException {

		if (contains(permissionChecker, batchPlannerPlan, actionId)) {
			return;
		}

		throw new PrincipalException.MustHavePermission(
			permissionChecker, BatchPlannerPlan.class.getName(),
			batchPlannerPlan.getBatchPlannerPlanId(), actionId);
	}

	@Override
	public void check(
			PermissionChecker permissionChecker, long batchPlannerPlanId,
			String actionId)
		throws PortalException {

		check(
			permissionChecker,
			_batchPlannerPlanLocalService.getBatchPlannerPlan(
				batchPlannerPlanId),
			actionId);
	}

	@Override
	public boolean contains(
			PermissionChecker permissionChecker,
			BatchPlannerPlan batchPlannerPlan, String actionId)
		throws PortalException {

		if (permissionChecker.isCompanyAdmin(batchPlannerPlan.getCompanyId()) ||
			permissionChecker.hasOwnerPermission(
				batchPlannerPlan.getCompanyId(),
				BatchPlannerPlan.class.getName(),
				batchPlannerPlan.getBatchPlannerPlanId(),
				batchPlannerPlan.getUserId(), actionId)) {

			return true;
		}

		return permissionChecker.hasPermission(
			GroupConstants.DEFAULT_LIVE_GROUP_ID,
			BatchPlannerPlan.class.getName(),
			batchPlannerPlan.getBatchPlannerPlanId(), actionId);
	}

	@Override
	public boolean contains(
			PermissionChecker permissionChecker, long batchPlannerPlanId,
			String actionId)
		throws PortalException {

		return contains(
			permissionChecker,
			_batchPlannerPlanLocalService.getBatchPlannerPlan(
				batchPlannerPlanId),
			actionId);
	}

	@Override
	public String getModelName() {
		return BatchPlannerPlan.class.getName();
	}

	@Override
	public PortletResourcePermission getPortletResourcePermission() {
		return null;
	}

	@Reference
	private BatchPlannerPlanLocalService _batchPlannerPlanLocalService;

}