/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.service.impl;

import com.liferay.batch.planner.constants.BatchPlannerPlanConstants;
import com.liferay.batch.planner.exception.BatchPlannerPlanExternalTypeException;
import com.liferay.batch.planner.exception.BatchPlannerPlanInternalClassNameException;
import com.liferay.batch.planner.exception.BatchPlannerPlanNameException;
import com.liferay.batch.planner.exception.DuplicateBatchPlannerPlanException;
import com.liferay.batch.planner.exception.RequiredBatchPlannerPlanException;
import com.liferay.batch.planner.model.BatchPlannerLog;
import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.service.BatchPlannerLogLocalService;
import com.liferay.batch.planner.service.base.BatchPlannerPlanLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.batch.planner.model.BatchPlannerPlan"}, service={AopService.class})
public class BatchPlannerPlanLocalServiceImpl
extends BatchPlannerPlanLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(BatchPlannerPlanLocalServiceImpl.class);
    @BeanReference(type=BatchPlannerLogLocalService.class)
    private BatchPlannerLogLocalService _batchPlannerLogLocalService;

    public BatchPlannerPlan addBatchPlannerPlan(long userId, boolean export, String externalType, String externalURL, String internalClassName, String name, String taskItemDelegateName, boolean template) throws PortalException {
        this._validateExternalType(externalType);
        this._validateInternalClassName(internalClassName);
        if (Validator.isNull((String)name) && !template) {
            name = this._generateName(internalClassName);
        }
        User user = this.userLocalService.getUser(userId);
        this._validateName(0L, user.getCompanyId(), name);
        BatchPlannerPlan batchPlannerPlan = this.batchPlannerPlanPersistence.create(this.counterLocalService.increment());
        batchPlannerPlan.setCompanyId(user.getCompanyId());
        batchPlannerPlan.setUserId(userId);
        batchPlannerPlan.setUserName(user.getFullName());
        batchPlannerPlan.setExport(export);
        batchPlannerPlan.setExternalType(externalType);
        batchPlannerPlan.setExternalURL(externalURL);
        batchPlannerPlan.setInternalClassName(internalClassName);
        batchPlannerPlan.setName(name);
        batchPlannerPlan.setTaskItemDelegateName(taskItemDelegateName);
        batchPlannerPlan.setTemplate(template);
        batchPlannerPlan = (BatchPlannerPlan)this.batchPlannerPlanPersistence.update((BaseModel)batchPlannerPlan);
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), BatchPlannerPlan.class.getName(), batchPlannerPlan.getBatchPlannerPlanId(), false, true, false);
        return batchPlannerPlan;
    }

    @Override
    public BatchPlannerPlan deleteBatchPlannerPlan(long batchPlannerPlanId) throws PortalException {
        BatchPlannerPlan batchPlannerPlan = this.batchPlannerPlanPersistence.remove(batchPlannerPlanId);
        this.resourceLocalService.deleteResource((AuditedModel)batchPlannerPlan, 4);
        BatchPlannerLog batchPlannerLog = this.batchPlannerLogPersistence.fetchByBatchPlannerPlanId(batchPlannerPlanId);
        if (batchPlannerLog != null) {
            this.batchPlannerLogPersistence.removeByBatchPlannerPlanId(batchPlannerPlanId);
        }
        this.batchPlannerMappingPersistence.removeByBatchPlannerPlanId(batchPlannerPlanId);
        this.batchPlannerPolicyPersistence.removeByBatchPlannerPlanId(batchPlannerPlanId);
        return batchPlannerPlan;
    }

    public BatchPlannerPlan updateActive(boolean active, String batchEngineTaskERC, boolean export) throws PortalException {
        BatchPlannerLog batchPlannerLog = this._batchPlannerLogLocalService.fetchBatchPlannerLog(batchEngineTaskERC, export);
        if (batchPlannerLog == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to update batch planner plan for batch engine ", "task ERC ", batchEngineTaskERC, " and export ", export}));
            }
            return null;
        }
        return this.updateActive(batchPlannerLog.getBatchPlannerPlanId(), active);
    }

    public BatchPlannerPlan updateActive(long batchPlannerPlanId, boolean active) throws PortalException {
        BatchPlannerPlan batchPlannerPlan = this.batchPlannerPlanPersistence.findByPrimaryKey(batchPlannerPlanId);
        batchPlannerPlan.setActive(active);
        return (BatchPlannerPlan)this.batchPlannerPlanPersistence.update((BaseModel)batchPlannerPlan);
    }

    public BatchPlannerPlan updateBatchPlannerPlan(long userId, long batchPlannerPlanId, String externalType, String internalClassName, String name) throws PortalException {
        BatchPlannerPlan batchPlannerPlan = this.batchPlannerPlanPersistence.findByPrimaryKey(batchPlannerPlanId);
        if (!batchPlannerPlan.isTemplate()) {
            throw new RequiredBatchPlannerPlanException("Batch planner plan is not a template");
        }
        User user = this.userLocalService.getUser(userId);
        this._validateName(batchPlannerPlanId, user.getCompanyId(), name);
        batchPlannerPlan.setExternalType(externalType);
        batchPlannerPlan.setInternalClassName(internalClassName);
        batchPlannerPlan.setName(name);
        return (BatchPlannerPlan)this.batchPlannerPlanPersistence.update((BaseModel)batchPlannerPlan);
    }

    private String _generateName(String value) {
        return value.substring(value.lastIndexOf(".") + 1) + " Plan Execution " + System.currentTimeMillis();
    }

    private void _validateExternalType(String externalType) throws PortalException {
        if (ArrayUtil.contains((Object[])BatchPlannerPlanConstants.EXTERNAL_TYPES, (Object)externalType)) {
            return;
        }
        String merge = StringUtil.merge((String[])BatchPlannerPlanConstants.EXTERNAL_TYPES, (String)",");
        throw new BatchPlannerPlanExternalTypeException("Batch planner plan external type must be one of following: " + merge);
    }

    private void _validateInternalClassName(String internalClassName) throws PortalException {
        if (Validator.isNull((String)internalClassName)) {
            throw new BatchPlannerPlanInternalClassNameException();
        }
    }

    private void _validateName(long batchPlannerPlanId, long companyId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new BatchPlannerPlanNameException("Batch planner plan name is null for company " + companyId);
        }
        int maxLength = ModelHintsUtil.getMaxLength((String)BatchPlannerPlan.class.getName(), (String)"name");
        if (name.length() > maxLength) {
            throw new BatchPlannerPlanNameException("Batch planner plan name must not be longer than " + maxLength);
        }
        BatchPlannerPlan batchPlannerPlan = this.batchPlannerPlanPersistence.fetchByC_N(companyId, name);
        if (batchPlannerPlan == null || batchPlannerPlan.getBatchPlannerPlanId() == batchPlannerPlanId) {
            return;
        }
        throw new DuplicateBatchPlannerPlanException(StringBundler.concat((Object[])new Object[]{"Batch planner plan name \"", name, "\" already exists for company ", companyId}));
    }
}

