/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.internal.model.listener;

import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.planner.constants.BatchPlannerLogConstants;
import com.liferay.batch.planner.model.BatchPlannerLog;
import com.liferay.batch.planner.service.BatchPlannerLogLocalService;
import com.liferay.batch.planner.service.BatchPlannerPlanLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class BatchEngineImportTaskModelListener
extends BaseModelListener<BatchEngineImportTask> {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineImportTaskModelListener.class);
    @Reference
    private BatchPlannerLogLocalService _batchPlannerLogLocalService;
    @Reference
    private BatchPlannerPlanLocalService _batchPlannerPlanLocalService;

    public void onAfterCreate(BatchEngineImportTask batchEngineImportTask) throws ModelListenerException {
        this._updateStatus(batchEngineImportTask);
    }

    public void onAfterRemove(BatchEngineImportTask batchEngineImportTask) throws ModelListenerException {
        try {
            this._batchPlannerPlanLocalService.updateActive(false, String.valueOf(batchEngineImportTask.getBatchEngineImportTaskId()), true);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public void onAfterUpdate(BatchEngineImportTask originalBatchEngineImportTask, BatchEngineImportTask batchEngineImportTask) throws ModelListenerException {
        this._updateStatus(batchEngineImportTask);
    }

    private void _updateStatus(BatchEngineImportTask batchEngineImportTask) {
        BatchPlannerLog batchPlannerLog = this._batchPlannerLogLocalService.fetchBatchPlannerLog(String.valueOf(batchEngineImportTask.getBatchEngineImportTaskId()), false);
        if (batchPlannerLog == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No batch planner log found for batch engine import task ID " + batchEngineImportTask.getBatchEngineImportTaskId()));
            }
            return;
        }
        batchPlannerLog.setStatus(BatchPlannerLogConstants.getStatus((BatchEngineTaskExecuteStatus)BatchEngineTaskExecuteStatus.valueOf((String)batchEngineImportTask.getExecuteStatus())));
        this._batchPlannerLogLocalService.updateBatchPlannerLog(batchPlannerLog);
    }
}

