/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.internal.model.listener;

import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.planner.constants.BatchPlannerLogConstants;
import com.liferay.batch.planner.model.BatchPlannerLog;
import com.liferay.batch.planner.service.BatchPlannerLogLocalService;
import com.liferay.batch.planner.service.BatchPlannerPlanLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class BatchEngineExportTaskModelListener
extends BaseModelListener<BatchEngineExportTask> {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineExportTaskModelListener.class);
    @Reference
    private BatchPlannerLogLocalService _batchPlannerLogLocalService;
    @Reference
    private BatchPlannerPlanLocalService _batchPlannerPlanLocalService;

    public void onAfterCreate(BatchEngineExportTask batchEngineExportTask) throws ModelListenerException {
        this._updateStatus(batchEngineExportTask);
    }

    public void onAfterRemove(BatchEngineExportTask batchEngineExportTask) throws ModelListenerException {
        try {
            this._batchPlannerPlanLocalService.updateActive(false, String.valueOf(batchEngineExportTask.getBatchEngineExportTaskId()), true);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public void onAfterUpdate(BatchEngineExportTask originalBatchEngineExportTask, BatchEngineExportTask batchEngineExportTask) throws ModelListenerException {
        this._updateStatus(batchEngineExportTask);
    }

    private void _updateStatus(BatchEngineExportTask batchEngineExportTask) {
        BatchPlannerLog batchPlannerLog = this._batchPlannerLogLocalService.fetchBatchPlannerLog(String.valueOf(batchEngineExportTask.getBatchEngineExportTaskId()), true);
        if (batchPlannerLog == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No batch planner log found for batch engine export task ID " + batchEngineExportTask.getBatchEngineExportTaskId()));
            }
            return;
        }
        batchPlannerLog.setStatus(BatchPlannerLogConstants.getStatus((BatchEngineTaskExecuteStatus)BatchEngineTaskExecuteStatus.valueOf((String)batchEngineExportTask.getExecuteStatus())));
        this._batchPlannerLogLocalService.updateBatchPlannerLog(batchPlannerLog);
    }
}

