/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.internal.batch.engine.broker;

import com.liferay.batch.planner.batch.engine.broker.BatchEngineBroker;
import com.liferay.batch.planner.constants.BatchPlannerPlanConstants;
import com.liferay.batch.planner.internal.jaxrs.uri.BatchPlannerUriInfo;
import com.liferay.batch.planner.model.BatchPlannerMapping;
import com.liferay.batch.planner.model.BatchPlannerMappingModel;
import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.model.BatchPlannerPolicy;
import com.liferay.batch.planner.service.BatchPlannerLogLocalService;
import com.liferay.batch.planner.service.BatchPlannerMappingLocalService;
import com.liferay.batch.planner.service.BatchPlannerPlanLocalService;
import com.liferay.headless.batch.engine.dto.v1_0.ExportTask;
import com.liferay.headless.batch.engine.dto.v1_0.ImportTask;
import com.liferay.headless.batch.engine.resource.v1_0.ExportTaskResource;
import com.liferay.headless.batch.engine.resource.v1_0.ImportTaskResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BatchEngineBroker.class})
public class BatchEngineBrokerImpl
implements BatchEngineBroker {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineBrokerImpl.class);
    @Reference
    private BatchPlannerLogLocalService _batchPlannerLogLocalService;
    @Reference
    private BatchPlannerMappingLocalService _batchPlannerMappingLocalService;
    @Reference
    private BatchPlannerPlanLocalService _batchPlannerPlanLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ExportTaskResource _exportTaskResource;
    @Reference
    private ImportTaskResource _importTaskResource;
    @Reference
    private UserLocalService _userLocalService;

    public void submit(long batchPlannerPlanId) {
        try {
            BatchPlannerPlan batchPlannerPlan = this._batchPlannerPlanLocalService.getBatchPlannerPlan(batchPlannerPlanId);
            if (batchPlannerPlan.isExport()) {
                this._submitExportTask(batchPlannerPlan);
            } else {
                this._submitImportTask(batchPlannerPlan);
            }
            this._batchPlannerPlanLocalService.updateActive(batchPlannerPlanId, true);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to execute batch planner plan ID " + batchPlannerPlanId), (Throwable)exception);
        }
    }

    private String _getFieldNameMapping(List<BatchPlannerMapping> batchPlannerMappings) {
        if (batchPlannerMappings.isEmpty()) {
            throw new IllegalArgumentException("There are no batch planner mappings");
        }
        StringBundler sb = new StringBundler(batchPlannerMappings.size() * 3 - 1);
        Iterator<BatchPlannerMapping> iterator = batchPlannerMappings.iterator();
        while (iterator.hasNext()) {
            BatchPlannerMapping batchPlannerMapping = iterator.next();
            sb.append(batchPlannerMapping.getExternalFieldName());
            sb.append("=");
            sb.append(batchPlannerMapping.getInternalFieldName());
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private File _getFile(long batchPlannerPlanId) throws Exception {
        BatchPlannerPlan batchPlannerPlan = this._batchPlannerPlanLocalService.getBatchPlannerPlan(batchPlannerPlanId);
        return new File(new URI(batchPlannerPlan.getExternalURL()));
    }

    private String[] _getHeaderNames(List<BatchPlannerMapping> batchPlannerMappings, UnsafeFunction<BatchPlannerMapping, String, Exception> unsafeFunction) {
        return (String[])TransformUtil.transformToArray(batchPlannerMappings, unsafeFunction, String.class);
    }

    private String _getImportStrategy(BatchPlannerPlan batchPlannerPlan) throws Exception {
        BatchPlannerPolicy batchPlannerPolicy = batchPlannerPlan.getBatchPlannerPolicy("onErrorFail");
        boolean onErrorFail = Boolean.valueOf(batchPlannerPolicy.getValue());
        if (onErrorFail) {
            return "ON_ERROR_FAIL";
        }
        return "ON_ERROR_CONTINUE";
    }

    private UriInfo _getImportTaskUriInfo(BatchPlannerPlan batchPlannerPlan) {
        BatchPlannerUriInfo.Builder builder = new BatchPlannerUriInfo.Builder();
        return builder.delimiter(this._getValue(batchPlannerPlan.fetchBatchPlannerPolicy("csvSeparator"))).taskItemDelegateName(batchPlannerPlan.getTaskItemDelegateName()).queryParameter("containsHeaders", this._getValue(batchPlannerPlan.fetchBatchPlannerPolicy("containsHeaders"))).build();
    }

    private String _getValue(BatchPlannerPolicy batchPlannerPolicy) {
        if (batchPlannerPolicy != null) {
            return batchPlannerPolicy.getValue();
        }
        return null;
    }

    private void _submitExportTask(BatchPlannerPlan batchPlannerPlan) throws Exception {
        this._exportTaskResource.setContextCompany(this._companyLocalService.getCompany(batchPlannerPlan.getCompanyId()));
        this._exportTaskResource.setContextUriInfo(this._getImportTaskUriInfo(batchPlannerPlan));
        this._exportTaskResource.setContextUser(this._userLocalService.getUser(batchPlannerPlan.getUserId()));
        List batchPlannerMappings = this._batchPlannerMappingLocalService.getBatchPlannerMappings(batchPlannerPlan.getBatchPlannerPlanId());
        Object[] headerNames = this._getHeaderNames(batchPlannerMappings, (UnsafeFunction<BatchPlannerMapping, String, Exception>)((UnsafeFunction)BatchPlannerMappingModel::getInternalFieldName));
        ExportTask exportTask = this._exportTaskResource.postExportTask(batchPlannerPlan.getInternalClassName(), batchPlannerPlan.getExternalType(), null, StringUtil.merge((Object[])headerNames, (String)","), batchPlannerPlan.getTaskItemDelegateName());
        this._batchPlannerLogLocalService.addBatchPlannerLog(batchPlannerPlan.getUserId(), batchPlannerPlan.getBatchPlannerPlanId(), String.valueOf(exportTask.getId()), null, null, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _submitImportTask(BatchPlannerPlan batchPlannerPlan) throws Exception {
        this._importTaskResource.setContextCompany(this._companyLocalService.getCompany(batchPlannerPlan.getCompanyId()));
        this._importTaskResource.setContextUriInfo(this._getImportTaskUriInfo(batchPlannerPlan));
        this._importTaskResource.setContextUser(this._userLocalService.getUser(batchPlannerPlan.getUserId()));
        File file = this._getFile(batchPlannerPlan.getBatchPlannerPlanId());
        try {
            ImportTask importTask = this._importTaskResource.postImportTask(batchPlannerPlan.getInternalClassName(), null, this._getFieldNameMapping(this._batchPlannerMappingLocalService.getBatchPlannerMappings(batchPlannerPlan.getBatchPlannerPlanId())), this._getImportStrategy(batchPlannerPlan), batchPlannerPlan.getTaskItemDelegateName(), MultipartBody.of(Collections.singletonMap("file", new BinaryFile(BatchPlannerPlanConstants.getContentType((String)batchPlannerPlan.getExternalType()), file.getName(), (InputStream)new FileInputStream(file), file.length())), null, Collections.emptyMap()));
            this._batchPlannerLogLocalService.addBatchPlannerLog(batchPlannerPlan.getUserId(), batchPlannerPlan.getBatchPlannerPlanId(), null, String.valueOf(importTask.getId()), null, (int)file.length(), 1);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }
}

