/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal;

import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.internal.security.permission.LiberalPermissionChecker;
import com.liferay.batch.engine.internal.util.ItemIndexThreadLocal;
import com.liferay.batch.engine.jaxrs.uri.BatchEngineUriInfo;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.audit.AuditRequestThreadLocal;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageSender;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.Map;

public class BatchEngineTaskExecutorUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(boolean checkPermissions, UnsafeSupplier<T, Throwable> unsafeSupplier, User user) throws Throwable {
        AuditRequestThreadLocal auditRequestThreadLocal = AuditRequestThreadLocal.getAuditThreadLocal();
        auditRequestThreadLocal.setRealUserEmailAddress(user.getEmailAddress());
        auditRequestThreadLocal.setRealUserId(user.getUserId());
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (checkPermissions) {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)user));
        } else {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)new LiberalPermissionChecker(user));
        }
        String name = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)user.getUserId());
        try {
            Object object = unsafeSupplier.get();
            return (T)object;
        }
        finally {
            ItemIndexThreadLocal.clear();
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            PrincipalThreadLocal.setName((String)name);
        }
    }

    public static void sendBatchProgressMessage(BackgroundTaskStatusMessageSender backgroundTaskStatusMessageSender, int processedItemsCount) {
        if (backgroundTaskStatusMessageSender == null) {
            return;
        }
        Message message = new Message();
        message.put("backgroundTaskId", (Object)BackgroundTaskThreadLocal.getBackgroundTaskId());
        message.put("batchEngineProcessedItemsCount", (Object)processedItemsCount);
        message.put("messageType", (Object)"batchProgress");
        backgroundTaskStatusMessageSender.sendBackgroundTaskStatusMessage(message);
    }

    public static void setContextFields(long companyId, BatchEngineTaskItemDelegate<?> batchEngineTaskItemDelegate, Map<String, Serializable> parameters, User user) throws PortalException {
        batchEngineTaskItemDelegate.setContextCompany(CompanyLocalServiceUtil.getCompany((long)companyId));
        BatchEngineUriInfo.Builder builder = new BatchEngineUriInfo.Builder();
        for (Map.Entry<String, Serializable> entry : parameters.entrySet()) {
            builder.queryParameter(entry.getKey(), String.valueOf(entry.getValue()));
        }
        batchEngineTaskItemDelegate.setContextUriInfo((UriInfo)builder.build());
        batchEngineTaskItemDelegate.setContextUser(user);
        batchEngineTaskItemDelegate.setLanguageId(user.getLanguageId());
    }
}

