/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.CSVBatchEngineImportTaskItemReaderImpl;
import com.liferay.batch.engine.internal.reader.JSONBatchEngineImportTaskItemReaderImpl;
import com.liferay.batch.engine.internal.reader.JSONLBatchEngineImportTaskItemReaderImpl;
import com.liferay.batch.engine.internal.reader.XLSBatchEngineImportTaskItemReaderImpl;
import com.liferay.batch.engine.internal.util.ZipInputStreamUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BatchEngineImportTaskItemReaderBuilder {
    private BatchEngineTaskContentType _batchEngineTaskContentType;
    private String _csvFileColumnDelimiter;
    private List<String> _fieldNames;
    private InputStream _inputStream;
    private Map<String, Serializable> _parameters;

    public BatchEngineImportTaskItemReaderBuilder batchEngineTaskContentType(BatchEngineTaskContentType batchEngineTaskContentType) {
        this._batchEngineTaskContentType = batchEngineTaskContentType;
        return this;
    }

    public BatchEngineImportTaskItemReader build() throws Exception {
        if (this._fieldNames == null) {
            this._fieldNames = Collections.emptyList();
        }
        InputStream inputStream = ZipInputStreamUtil.asZipInputStream(this._inputStream);
        if (this._batchEngineTaskContentType == BatchEngineTaskContentType.CSV) {
            return new CSVBatchEngineImportTaskItemReaderImpl(this._csvFileColumnDelimiter, inputStream, this._parameters);
        }
        if (this._batchEngineTaskContentType == BatchEngineTaskContentType.JSON || this._batchEngineTaskContentType == BatchEngineTaskContentType.JSONT) {
            return new JSONBatchEngineImportTaskItemReaderImpl(this._fieldNames, inputStream);
        }
        if (this._batchEngineTaskContentType == BatchEngineTaskContentType.JSONL) {
            return new JSONLBatchEngineImportTaskItemReaderImpl(this._fieldNames, inputStream);
        }
        if (this._batchEngineTaskContentType == BatchEngineTaskContentType.XLS || this._batchEngineTaskContentType == BatchEngineTaskContentType.XLSX) {
            return new XLSBatchEngineImportTaskItemReaderImpl(this._fieldNames, inputStream);
        }
        throw new IllegalArgumentException("Unknown batch engine task content type " + String.valueOf(this._batchEngineTaskContentType));
    }

    public BatchEngineImportTaskItemReaderBuilder csvFileColumnDelimiter(String csvFileColumnDelimiter) {
        this._csvFileColumnDelimiter = csvFileColumnDelimiter;
        return this;
    }

    public BatchEngineImportTaskItemReaderBuilder fieldNames(List<String> fieldNames) {
        this._fieldNames = fieldNames;
        return this;
    }

    public BatchEngineImportTaskItemReaderBuilder inputStream(InputStream inputStream) {
        this._inputStream = inputStream;
        return this;
    }

    public BatchEngineImportTaskItemReaderBuilder parameters(Map<String, Serializable> parameters) {
        this._parameters = parameters;
        return this;
    }
}

