/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal;

import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.BatchEngineTaskItemDelegateRegistry;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.ItemClassRegistry;
import com.liferay.batch.engine.action.ImportTaskPostAction;
import com.liferay.batch.engine.action.ImportTaskPreAction;
import com.liferay.batch.engine.action.ItemReaderPostAction;
import com.liferay.batch.engine.configuration.BatchEngineTaskCompanyConfiguration;
import com.liferay.batch.engine.internal.BatchEngineTaskCallbackUtil;
import com.liferay.batch.engine.internal.BatchEngineTaskExecutorUtil;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemDelegateExecutor;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemDelegateExecutorFactory;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReaderBuilder;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReaderUtil;
import com.liferay.batch.engine.internal.strategy.OnErrorContinueBatchEngineImportStrategy;
import com.liferay.batch.engine.internal.strategy.OnErrorFailBatchEngineImportStrategy;
import com.liferay.batch.engine.internal.task.progress.BatchEngineTaskProgress;
import com.liferay.batch.engine.internal.task.progress.BatchEngineTaskProgressFactory;
import com.liferay.batch.engine.internal.util.ErrorMessageUtil;
import com.liferay.batch.engine.internal.util.ItemIndexThreadLocal;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskErrorLocalService;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.batch.engine.strategy.BatchEngineImportStrategy;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={BatchEngineImportTaskExecutor.class})
public class BatchEngineImportTaskExecutorImpl
implements BatchEngineImportTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineImportTaskExecutorImpl.class);
    @Reference
    private BatchEngineImportTaskErrorLocalService _batchEngineImportTaskErrorLocalService;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    private BatchEngineTaskItemDelegateExecutorFactory _batchEngineTaskItemDelegateExecutorFactory;
    @Reference
    private BatchEngineTaskItemDelegateRegistry _batchEngineTaskItemDelegateRegistry;
    private final BatchEngineTaskProgressFactory _batchEngineTaskProgressFactory = new BatchEngineTaskProgressFactory();
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    private ServiceTrackerList<ImportTaskPostAction> _importTaskPostActions;
    private ServiceTrackerList<ImportTaskPreAction> _importTaskPreActions;
    @Reference
    private ItemClassRegistry _itemClassRegistry;
    private ServiceTrackerList<ItemReaderPostAction> _itemReaderPostActions;
    @Reference
    private UserLocalService _userLocalService;

    public void execute(BatchEngineImportTask batchEngineImportTask) {
        BatchEngineTaskItemDelegate batchEngineTaskItemDelegate = this._batchEngineTaskItemDelegateRegistry.getBatchEngineTaskItemDelegate(batchEngineImportTask.getCompanyId(), batchEngineImportTask.getClassName(), batchEngineImportTask.getTaskItemDelegateName());
        this.execute(batchEngineImportTask, batchEngineTaskItemDelegate, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(BatchEngineImportTask batchEngineImportTask, BatchEngineTaskItemDelegate<?> batchEngineTaskItemDelegate, boolean checkPermissions) {
        File file;
        long startTime = 0L;
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Started batch engine import task " + batchEngineImportTask.getBatchEngineImportTaskId()));
            startTime = System.currentTimeMillis();
        }
        SafeCloseable safeCloseable1 = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)batchEngineImportTask.getCompanyId(), (Long)CTCollectionThreadLocal.getCTCollectionId());
        try (InputStream inputStream = this._batchEngineImportTaskLocalService.openContentInputStream(batchEngineImportTask.getBatchEngineImportTaskId());){
            file = FileUtil.createTempFile((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            _log.error((Object)("Unable to save batch engine import task content as temp file" + batchEngineImportTask), throwable);
            this._updateBatchEngineImportTask(BatchEngineTaskExecuteStatus.FAILED, batchEngineImportTask, throwable);
            return;
        }
        try (SafeCloseable safeCloseable2 = SearchContext.openBatchMode();){
            batchEngineImportTask.setExecuteStatus(BatchEngineTaskExecuteStatus.STARTED.toString());
            batchEngineImportTask.setStartTime(new Date());
            BatchEngineTaskProgress batchEngineTaskProgress = this._batchEngineTaskProgressFactory.create(BatchEngineTaskContentType.valueOf((String)batchEngineImportTask.getContentType()));
            try (FileInputStream inputStream = new FileInputStream(file);){
                batchEngineImportTask.setTotalItemsCount(batchEngineTaskProgress.getTotalItemsCount(inputStream));
            }
            this._batchEngineImportTaskLocalService.updateBatchEngineImportTask(batchEngineImportTask);
            BatchEngineTaskExecutorUtil.execute(checkPermissions, () -> this._importItems(batchEngineImportTask, batchEngineTaskItemDelegate, file), this._userLocalService.getUser(batchEngineImportTask.getUserId()));
            this._updateBatchEngineImportTask(BatchEngineTaskExecuteStatus.COMPLETED, batchEngineImportTask, null);
        }
        catch (Throwable throwable) {
            _log.error((Object)("Unable to update batch engine import task " + batchEngineImportTask), throwable);
            this._updateBatchEngineImportTask(BatchEngineTaskExecuteStatus.FAILED, batchEngineImportTask, throwable);
        }
        finally {
            file.delete();
            safeCloseable1.close();
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Finished batch engine import task ", batchEngineImportTask.getBatchEngineImportTaskId(), " in ", System.currentTimeMillis() - startTime, "ms"}));
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._batchEngineTaskItemDelegateExecutorFactory = new BatchEngineTaskItemDelegateExecutorFactory(this._batchEngineTaskItemDelegateRegistry, null, null, null);
        this._importTaskPostActions = ServiceTrackerListFactory.open((BundleContext)bundleContext, ImportTaskPostAction.class);
        this._importTaskPreActions = ServiceTrackerListFactory.open((BundleContext)bundleContext, ImportTaskPreAction.class);
        this._itemReaderPostActions = ServiceTrackerListFactory.open((BundleContext)bundleContext, ItemReaderPostAction.class);
    }

    @Deactivate
    protected void deactivate() {
        this._importTaskPostActions.close();
        this._importTaskPreActions.close();
        this._itemReaderPostActions.close();
    }

    private void _commitItems(BatchEngineImportTask batchEngineImportTask, BatchEngineTaskItemDelegateExecutor batchEngineTaskItemDelegateExecutor, List<Object> items, int processedItemsCount) throws Throwable {
        batchEngineTaskItemDelegateExecutor.saveItems(this._createBatchEngineImportStrategy(batchEngineImportTask), BatchEngineTaskOperation.valueOf((String)batchEngineImportTask.getOperation()), items);
        batchEngineImportTask.setProcessedItemsCount(processedItemsCount);
        this._batchEngineImportTaskLocalService.updateBatchEngineImportTask(batchEngineImportTask);
    }

    private BatchEngineImportStrategy _createBatchEngineImportStrategy(BatchEngineImportTask batchEngineImportTask) {
        if (batchEngineImportTask.getImportStrategy() == 1) {
            return new OnErrorContinueBatchEngineImportStrategy(batchEngineImportTask, this._importTaskPostActions.toList(), this._importTaskPreActions.toList());
        }
        return new OnErrorFailBatchEngineImportStrategy(batchEngineImportTask, this._importTaskPostActions.toList(), this._importTaskPreActions.toList());
    }

    private BatchEngineImportTaskItemReader _getBatchEngineImportTaskItemReader(BatchEngineImportTask batchEngineImportTask, InputStream inputStream, Map<String, Serializable> parameters) throws Exception {
        BatchEngineImportTaskItemReaderBuilder batchEngineImportTaskItemReaderBuilder = new BatchEngineImportTaskItemReaderBuilder();
        Map fieldNameMapping = batchEngineImportTask.getFieldNameMapping();
        if (fieldNameMapping == null) {
            fieldNameMapping = Collections.emptyMap();
        }
        return batchEngineImportTaskItemReaderBuilder.batchEngineTaskContentType(BatchEngineTaskContentType.valueOf((String)batchEngineImportTask.getContentType())).csvFileColumnDelimiter(this._getCSVFileColumnDelimiter(batchEngineImportTask.getCompanyId())).fieldNames(ListUtil.fromCollection(fieldNameMapping.keySet())).inputStream(inputStream).parameters(parameters).build();
    }

    private String _getCSVFileColumnDelimiter(long companyId) throws Exception {
        BatchEngineTaskCompanyConfiguration batchEngineTaskCompanyConfiguration = (BatchEngineTaskCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(BatchEngineTaskCompanyConfiguration.class, companyId);
        return batchEngineTaskCompanyConfiguration.csvFileColumnDelimiter();
    }

    private Map<String, Serializable> _getParameters(BatchEngineImportTask batchEngineImportTask) {
        HashMap parameters = batchEngineImportTask.getParameters();
        if (parameters == null) {
            parameters = new HashMap();
        }
        return parameters;
    }

    private void _handleException(BatchEngineImportTask batchEngineImportTask, Exception exception, int processedItemsCount) throws Exception {
        this._batchEngineImportTaskErrorLocalService.addBatchEngineImportTaskError(batchEngineImportTask.getCompanyId(), batchEngineImportTask.getUserId(), batchEngineImportTask.getBatchEngineImportTaskId(), null, processedItemsCount, ErrorMessageUtil.getErrorMessage(exception, batchEngineImportTask.getUserId()));
        if (batchEngineImportTask.getImportStrategy() == 1) {
            _log.error((Throwable)exception);
        } else if (batchEngineImportTask.getImportStrategy() == 2) {
            throw exception;
        }
    }

    private Void _importItems(BatchEngineImportTask batchEngineImportTask, BatchEngineTaskItemDelegate<?> batchEngineTaskItemDelegate, File file) throws Throwable {
        Map<String, Serializable> parameters = this._getParameters(batchEngineImportTask);
        try (FileInputStream inputStream = new FileInputStream(file);
             BatchEngineImportTaskItemReader batchEngineImportTaskItemReader = this._getBatchEngineImportTaskItemReader(batchEngineImportTask, inputStream, parameters);){
            BatchEngineTaskItemDelegateExecutor batchEngineTaskItemDelegateExecutor = this._batchEngineTaskItemDelegateExecutorFactory.create(batchEngineTaskItemDelegate, this._companyLocalService.getCompany(batchEngineImportTask.getCompanyId()), parameters, this._userLocalService.getUser(batchEngineImportTask.getUserId()));
            ArrayList<Object> items = new ArrayList<Object>();
            Class itemClass = this._itemClassRegistry.getItemClass(batchEngineTaskItemDelegate);
            int processedItemsCount = 0;
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                try {
                    Object item = this._readItem(batchEngineImportTask, batchEngineImportTaskItemReader, batchEngineImportTask.getFieldNameMapping(), itemClass);
                    if (item == null) break;
                    items.add(item);
                    ItemIndexThreadLocal.add(++processedItemsCount);
                }
                catch (Exception exception) {
                    this._handleException(batchEngineImportTask, exception, ++processedItemsCount);
                }
                if ((long)items.size() != batchEngineImportTask.getBatchSize()) continue;
                this._commitItems(batchEngineImportTask, batchEngineTaskItemDelegateExecutor, items, processedItemsCount);
                items.clear();
                ItemIndexThreadLocal.clear();
            }
            if (!items.isEmpty()) {
                this._commitItems(batchEngineImportTask, batchEngineTaskItemDelegateExecutor, items, processedItemsCount);
            }
        }
        return null;
    }

    private Object _readItem(BatchEngineImportTask batchEngineImportTask, BatchEngineImportTaskItemReader batchEngineImportTaskItemReader, Map<String, Serializable> fieldNameMapping, Class<?> itemClass) throws Exception {
        Map<String, Object> fieldNameValueMap = batchEngineImportTaskItemReader.read();
        if (fieldNameValueMap == null) {
            return null;
        }
        return BatchEngineImportTaskItemReaderUtil.convertValue(batchEngineImportTask, itemClass, BatchEngineImportTaskItemReaderUtil.mapFieldNames(fieldNameMapping, fieldNameValueMap), this._itemReaderPostActions.toList());
    }

    private void _updateBatchEngineImportTask(BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus, BatchEngineImportTask batchEngineImportTask, Throwable throwable) {
        batchEngineImportTask.setEndTime(new Date());
        batchEngineImportTask.setErrorMessage(ErrorMessageUtil.getErrorMessage(throwable, batchEngineImportTask.getUserId()));
        batchEngineImportTask.setExecuteStatus(batchEngineTaskExecuteStatus.toString());
        batchEngineImportTask = this._batchEngineImportTaskLocalService.updateBatchEngineImportTask(batchEngineImportTask);
        BatchEngineTaskCallbackUtil.sendCallback(batchEngineImportTask.getCallbackURL(), batchEngineImportTask.getExecuteStatus(), batchEngineImportTask.getBatchEngineImportTaskId());
    }
}

