/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.CSVBatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.JSONBatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.JSONLBatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.XLSBatchEngineImportTaskItemReader;
import java.io.InputStream;
import java.util.zip.ZipInputStream;

public class BatchEngineImportTaskItemReaderFactory {
    private final String _csvFileColumnDelimiter;

    public BatchEngineImportTaskItemReaderFactory(String csvFileColumnDelimiter) {
        this._csvFileColumnDelimiter = csvFileColumnDelimiter;
    }

    public BatchEngineImportTaskItemReader create(BatchEngineTaskContentType batchEngineTaskContentType, InputStream inputStream) throws Exception {
        inputStream = this._getZipInputStream(inputStream);
        if (batchEngineTaskContentType == BatchEngineTaskContentType.CSV) {
            return new CSVBatchEngineImportTaskItemReader(this._csvFileColumnDelimiter, inputStream);
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.JSON) {
            return new JSONBatchEngineImportTaskItemReader(inputStream);
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.JSONL) {
            return new JSONLBatchEngineImportTaskItemReader(inputStream);
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.XLS || batchEngineTaskContentType == BatchEngineTaskContentType.XLSX) {
            return new XLSBatchEngineImportTaskItemReader(inputStream);
        }
        throw new IllegalArgumentException("Unknown batch engine task content type " + batchEngineTaskContentType);
    }

    private InputStream _getZipInputStream(InputStream inputStream) throws Exception {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        zipInputStream.getNextEntry();
        return zipInputStream;
    }
}

