/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.archived.modules.upgrade.internal;

import com.liferay.archived.modules.upgrade.internal.ArchivedModulesUpgradeConfiguration;
import com.liferay.archived.modules.upgrade.internal.UpgradeChat;
import com.liferay.archived.modules.upgrade.internal.UpgradeInvitation;
import com.liferay.archived.modules.upgrade.internal.UpgradeMailReader;
import com.liferay.archived.modules.upgrade.internal.UpgradePrivateMessaging;
import com.liferay.archived.modules.upgrade.internal.UpgradeShopping;
import com.liferay.archived.modules.upgrade.internal.UpgradeTwitter;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import java.util.Map;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.archived.modules.upgrade.internal.ArchivedModulesUpgradeConfiguration"}, immediate=true, service={UpgradeStepRegistrator.class})
public class ArchivedModulesUpgrade
implements UpgradeStepRegistrator {
    private ArchivedModulesUpgradeConfiguration _archivedModulesUpgradeConfiguration;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private ReleaseLocalService _releaseLocalService;

    public void register(UpgradeStepRegistrator.Registry registry) {
        try {
            this._removeModuleData(this._archivedModulesUpgradeConfiguration::removeChatModuleData, "com.liferay.chat.service", UpgradeChat::new);
            this._removeModuleData(this._archivedModulesUpgradeConfiguration::removeInvitationModuleData, "com.liferay.invitation.web", UpgradeInvitation::new);
            this._removeModuleData(this._archivedModulesUpgradeConfiguration::removeMailReaderModuleData, "com.liferay.mail.reader.service", UpgradeMailReader::new);
            this._removeModuleData(this._archivedModulesUpgradeConfiguration::removePrivateMessagingModuleData, "com.liferay.social.privatemessaging.service", () -> new UpgradePrivateMessaging(this._mbThreadLocalService));
            this._removeModuleData(this._archivedModulesUpgradeConfiguration::removeShoppingModuleData, "com.liferay.shopping.service", () -> new UpgradeShopping(this._imageLocalService));
            this._removeModuleData(this._archivedModulesUpgradeConfiguration::removeTwitterModuleData, "com.liferay.twitter.service", UpgradeTwitter::new);
        }
        catch (UpgradeException ue) {
            ReflectionUtil.throwException((Throwable)ue);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._archivedModulesUpgradeConfiguration = (ArchivedModulesUpgradeConfiguration)ConfigurableUtil.createConfigurable(ArchivedModulesUpgradeConfiguration.class, properties);
    }

    private void _removeModuleData(Supplier<Boolean> booleanSupplier, String servletContextName, Supplier<UpgradeProcess> upgradeProcessSupplier) throws UpgradeException {
        Release release;
        if (booleanSupplier.get().booleanValue() && (release = this._releaseLocalService.fetchRelease(servletContextName)) != null) {
            UpgradeProcess upgradeProcess = upgradeProcessSupplier.get();
            upgradeProcess.upgrade();
            CacheRegistryUtil.clear();
        }
    }
}

