/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.user.personal.site.permissions.internal.model.listener;

import com.liferay.application.list.PanelApp;
import com.liferay.application.list.PanelAppRegistry;
import com.liferay.application.list.display.context.logic.PanelCategoryHelper;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={ModelListener.class})
public class CompanyModelListener
extends BaseModelListener<Company> {
    private static final Log _log = LogFactoryUtil.getLog(CompanyModelListener.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private PanelAppRegistry _panelAppRegistry;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    private ServiceTracker<PanelApp, PanelApp> _serviceTracker;

    public void onAfterCreate(Company company) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            PanelCategoryHelper panelCategoryHelper = new PanelCategoryHelper(this._panelAppRegistry);
            List portlets = TransformUtil.transform((Collection)panelCategoryHelper.getAllPanelApps("site_administration"), panelApp -> this._portletLocalService.getPortletById(panelApp.getPortletId()));
            this._initPermissions(company.getCompanyId(), portlets);
            return null;
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        String filter = StringBundler.concat((String[])new String[]{"(&(objectClass=", PanelApp.class.getName(), ")(panel.category.key=", "site_administration", "*))"});
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, (String)filter, (ServiceTrackerCustomizer)new PanelAppServiceTrackerCustomizer(bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private Role _getPowerUserRole(long companyId) {
        try {
            return this._roleLocalService.getRole(companyId, "Power User");
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to get power user role in company " + companyId), (Throwable)portalException);
            return null;
        }
    }

    private Group _getUserPersonalSiteGroup(long companyId) {
        try {
            return this._groupLocalService.getUserPersonalSiteGroup(companyId);
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to get user personal site group in company " + companyId), (Throwable)portalException);
            return null;
        }
    }

    private void _initPermissions(Company company, Portlet portlet) {
        long companyId = company.getCompanyId();
        Role powerUserRole = this._getPowerUserRole(companyId);
        if (powerUserRole == null) {
            return;
        }
        Group userPersonalSiteGroup = this._getUserPersonalSiteGroup(companyId);
        if (userPersonalSiteGroup == null) {
            return;
        }
        try {
            if (companyId == portlet.getCompanyId()) {
                this._initPermissions(companyId, powerUserRole.getRoleId(), portlet.getRootPortletId(), userPersonalSiteGroup.getGroupId());
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to initialize user personal site permissions for ", "portlet ", portlet.getPortletId(), " in company ", company.getCompanyId()}), (Throwable)portalException);
        }
    }

    private void _initPermissions(long companyId, List<Portlet> portlets) {
        Role powerUserRole = this._getPowerUserRole(companyId);
        if (powerUserRole == null) {
            return;
        }
        Group userPersonalSiteGroup = this._getUserPersonalSiteGroup(companyId);
        if (userPersonalSiteGroup == null) {
            return;
        }
        for (Portlet portlet : portlets) {
            try {
                if (companyId != portlet.getCompanyId()) continue;
                this._initPermissions(companyId, powerUserRole.getRoleId(), portlet.getRootPortletId(), userPersonalSiteGroup.getGroupId());
            }
            catch (PortalException portalException) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to initialize user personal site permissions ", "for portlet ", portlet.getPortletId(), " in company ", companyId}), (Throwable)portalException);
            }
        }
    }

    private void _initPermissions(long companyId, long powerUserRoleId, String rootPortletId, long userPersonalSiteGroupId) throws PortalException {
        String modelName;
        String primaryKey = String.valueOf(userPersonalSiteGroupId);
        int count = this._resourcePermissionLocalService.getResourcePermissionsCount(companyId, rootPortletId, 2, primaryKey);
        if (count == 0) {
            List portletActionIds = ResourceActionsUtil.getPortletResourceActions((String)rootPortletId);
            this._resourcePermissionLocalService.setResourcePermissions(companyId, rootPortletId, 2, String.valueOf(userPersonalSiteGroupId), powerUserRoleId, portletActionIds.toArray(new String[0]));
        }
        if (Validator.isBlank((String)(modelName = ResourceActionsUtil.getPortletRootModelResource((String)rootPortletId)))) {
            return;
        }
        count = this._resourcePermissionLocalService.getResourcePermissionsCount(companyId, modelName, 2, primaryKey);
        if (count == 0) {
            List modelActionIds = ResourceActionsUtil.getModelResourceActions((String)modelName);
            this._resourcePermissionLocalService.setResourcePermissions(companyId, modelName, 2, String.valueOf(userPersonalSiteGroupId), powerUserRoleId, modelActionIds.toArray(new String[0]));
        }
    }

    private void _initPermissions(Portlet portlet) {
        this._companyLocalService.forEachCompany(company -> this._initPermissions((Company)company, portlet));
    }

    private class PanelAppServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PanelApp, PanelApp> {
        private final BundleContext _bundleContext;

        public PanelAppServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public PanelApp addingService(ServiceReference<PanelApp> serviceReference) {
            PanelApp panelApp = (PanelApp)this._bundleContext.getService(serviceReference);
            try {
                Portlet portlet = panelApp.getPortlet();
                if (portlet == null) {
                    portlet = CompanyModelListener.this._portletLocalService.getPortletById(panelApp.getPortletId());
                }
                if (portlet == null) {
                    Class panelAppClass = panelApp.getClass();
                    _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to get portlet ", panelApp.getPortletId(), " for panel app ", panelAppClass.getName()}));
                    return panelApp;
                }
                CompanyModelListener.this._initPermissions(portlet);
                return panelApp;
            }
            catch (Throwable throwable) {
                this._bundleContext.ungetService(serviceReference);
                throw throwable;
            }
        }

        public void modifiedService(ServiceReference<PanelApp> serviceReference, PanelApp panelApp) {
        }

        public void removedService(ServiceReference<PanelApp> serviceReference, PanelApp panelApp) {
            this._bundleContext.ungetService(serviceReference);
        }
    }
}

