/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.user.personal.site.permissions.internal;

import com.liferay.application.list.PanelApp;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={UserPersonalSitePermissions.class})
public class UserPersonalSitePermissions {
    private static final Log _log = LogFactoryUtil.getLog(UserPersonalSitePermissions.class);
    private BundleContext _bundleContext;
    private CompanyLocalService _companyLocalService;
    private GroupLocalService _groupLocalService;
    private PortletLocalService _portletLocalService;
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    private RoleLocalService _roleLocalService;
    private ServiceTracker<PanelApp, PanelApp> _serviceTracker;

    public void initPermissions(List<Company> companies, Portlet portlet) {
        String rootPortletId = portlet.getRootPortletId();
        for (Company company : companies) {
            Group userPersonalSiteGroup;
            long companyId = company.getCompanyId();
            Role powerUserRole = this.getPowerUserRole(companyId);
            if (powerUserRole == null || (userPersonalSiteGroup = this.getUserPersonalSiteGroup(companyId)) == null) continue;
            try {
                this.initPermissions(companyId, powerUserRole.getRoleId(), rootPortletId, userPersonalSiteGroup.getGroupId());
            }
            catch (PortalException pe) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to initialize user personal site permissions ", "for portlet ", portlet.getPortletId(), " in company ", companyId}), (Throwable)pe);
            }
        }
    }

    public void initPermissions(long companyId, List<Portlet> portlets) {
        Role powerUserRole = this.getPowerUserRole(companyId);
        if (powerUserRole == null) {
            return;
        }
        Group userPersonalSiteGroup = this.getUserPersonalSiteGroup(companyId);
        if (userPersonalSiteGroup == null) {
            return;
        }
        for (Portlet portlet : portlets) {
            try {
                this.initPermissions(companyId, powerUserRole.getRoleId(), portlet.getRootPortletId(), userPersonalSiteGroup.getGroupId());
            }
            catch (PortalException pe) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to initialize user personal site permissions ", "for portlet ", portlet.getPortletId(), " in company ", companyId}), (Throwable)pe);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        String filter = StringBundler.concat((String[])new String[]{"(&(objectClass=", PanelApp.class.getName(), ")", "(panel.category.key=", "site_administration", "*))"});
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, (String)filter, (ServiceTrackerCustomizer)new PanelAppServiceTrackerCustomizer());
    }

    protected void deactivated() {
        this._serviceTracker.close();
    }

    protected Role getPowerUserRole(long companyId) {
        try {
            return this._roleLocalService.getRole(companyId, "Power User");
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to get power user role in company " + companyId), (Throwable)pe);
            return null;
        }
    }

    protected Group getUserPersonalSiteGroup(long companyId) {
        try {
            return this._groupLocalService.getUserPersonalSiteGroup(companyId);
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to get user personal site group in company " + companyId), (Throwable)pe);
            return null;
        }
    }

    protected void initPermissions(long companyId, long powerUserRoleId, String rootPortletId, long userPersonalSiteGroupId) throws PortalException {
        String modelName;
        String primaryKey = String.valueOf(userPersonalSiteGroupId);
        int count = this._resourcePermissionLocalService.getResourcePermissionsCount(companyId, rootPortletId, 2, primaryKey);
        if (count == 0) {
            List portletActionIds = ResourceActionsUtil.getPortletResourceActions((String)rootPortletId);
            this._resourcePermissionLocalService.setResourcePermissions(companyId, rootPortletId, 2, String.valueOf(userPersonalSiteGroupId), powerUserRoleId, portletActionIds.toArray(new String[0]));
        }
        if (Validator.isBlank((String)(modelName = ResourceActionsUtil.getPortletRootModelResource((String)rootPortletId)))) {
            return;
        }
        count = this._resourcePermissionLocalService.getResourcePermissionsCount(companyId, modelName, 2, primaryKey);
        if (count == 0) {
            List modelActionIds = ResourceActionsUtil.getModelResourceActions((String)modelName);
            this._resourcePermissionLocalService.setResourcePermissions(companyId, modelName, 2, String.valueOf(userPersonalSiteGroupId), powerUserRoleId, modelActionIds.toArray(new String[0]));
        }
    }

    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this._portletLocalService = portletLocalService;
    }

    @Reference(unbind="-")
    protected void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this._resourcePermissionLocalService = resourcePermissionLocalService;
    }

    @Reference(unbind="-")
    protected void setRoleLocalService(RoleLocalService roleLocalService) {
        this._roleLocalService = roleLocalService;
    }

    private class PanelAppServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PanelApp, PanelApp> {
        private PanelAppServiceTrackerCustomizer() {
        }

        public PanelApp addingService(ServiceReference<PanelApp> reference) {
            PanelApp panelApp = (PanelApp)UserPersonalSitePermissions.this._bundleContext.getService(reference);
            try {
                Portlet portlet = panelApp.getPortlet();
                if (portlet == null) {
                    portlet = UserPersonalSitePermissions.this._portletLocalService.getPortletById(panelApp.getPortletId());
                }
                if (portlet == null) {
                    Class<?> panelAppClass = panelApp.getClass();
                    _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to get portlet ", panelApp.getPortletId(), " for panel app ", panelAppClass.getName()}));
                    return panelApp;
                }
                UserPersonalSitePermissions.this.initPermissions(UserPersonalSitePermissions.this._companyLocalService.getCompanies(), portlet);
                return panelApp;
            }
            catch (Throwable t) {
                UserPersonalSitePermissions.this._bundleContext.ungetService(reference);
                throw t;
            }
        }

        public void modifiedService(ServiceReference<PanelApp> serviceReference, PanelApp panelApp) {
            this.removedService(serviceReference, panelApp);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<PanelApp> serviceReference, PanelApp panelApp) {
            UserPersonalSitePermissions.this._bundleContext.ungetService(serviceReference);
        }
    }
}

