/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.app.builder.service.impl;

import com.liferay.app.builder.model.AppBuilderAppVersion;
import com.liferay.app.builder.service.base.AppBuilderAppVersionLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Date;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.app.builder.model.AppBuilderAppVersion"}, service={AopService.class})
public class AppBuilderAppVersionLocalServiceImpl
extends AppBuilderAppVersionLocalServiceBaseImpl {
    private static final String _VERSION_DEFAULT = "1.0";

    public AppBuilderAppVersion addAppBuilderAppVersion(long groupId, long companyId, long userId, long appBuilderAppId, long ddlRecordSetId, long ddmStructureId, long ddmStructureLayoutId) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        AppBuilderAppVersion appBuilderApp = this.appBuilderAppVersionPersistence.create(this.counterLocalService.increment());
        appBuilderApp.setGroupId(groupId);
        appBuilderApp.setCompanyId(companyId);
        appBuilderApp.setUserId(user.getUserId());
        appBuilderApp.setUserName(user.getFullName());
        appBuilderApp.setCreateDate(new Date());
        appBuilderApp.setModifiedDate(new Date());
        appBuilderApp.setAppBuilderAppId(appBuilderAppId);
        appBuilderApp.setDdlRecordSetId(ddlRecordSetId);
        appBuilderApp.setDdmStructureId(ddmStructureId);
        appBuilderApp.setDdmStructureLayoutId(ddmStructureLayoutId);
        appBuilderApp.setVersion(this._getNextVersion(appBuilderAppId));
        return (AppBuilderAppVersion)this.appBuilderAppVersionPersistence.update((BaseModel)appBuilderApp);
    }

    public void deleteAppBuilderAppVersions(long appBuilderAppId) {
        this.appBuilderAppVersionPersistence.removeByAppBuilderAppId(appBuilderAppId);
    }

    public AppBuilderAppVersion fetchLatestAppBuilderAppVersion(long appBuilderAppId) {
        return this.appBuilderAppVersionPersistence.fetchByAppBuilderAppId_First(appBuilderAppId, null);
    }

    public AppBuilderAppVersion getAppBuilderAppVersion(long appBuilderAppId, String version) throws PortalException {
        return this.appBuilderAppVersionPersistence.findByA_V(appBuilderAppId, version);
    }

    public AppBuilderAppVersion getLatestAppBuilderAppVersion(long appBuilderAppId) throws PortalException {
        return this.appBuilderAppVersionPersistence.findByAppBuilderAppId_First(appBuilderAppId, null);
    }

    private String _getNextVersion(long appBuilderAppId) throws PortalException {
        AppBuilderAppVersion latestAppBuilderAppVersion = this.fetchLatestAppBuilderAppVersion(appBuilderAppId);
        if (latestAppBuilderAppVersion == null) {
            return _VERSION_DEFAULT;
        }
        int[] versionParts = StringUtil.split((String)latestAppBuilderAppVersion.getVersion(), (String)".", (int)0);
        Object[] objectArray = new Object[3];
        versionParts[0] = versionParts[0] + 1;
        objectArray[0] = versionParts[0];
        objectArray[1] = ".";
        objectArray[2] = versionParts[1];
        return StringBundler.concat((Object[])objectArray);
    }
}

