/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.app.builder.model.impl;

import com.liferay.app.builder.model.AppBuilderAppVersion;
import com.liferay.app.builder.model.AppBuilderAppVersionModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the AppBuilderAppVersion service. Represents a row in the &quot;AppBuilderAppVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>AppBuilderAppVersionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AppBuilderAppVersionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AppBuilderAppVersionImpl
 * @generated
 */
public class AppBuilderAppVersionModelImpl
	extends BaseModelImpl<AppBuilderAppVersion>
	implements AppBuilderAppVersionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a app builder app version model instance should use the <code>AppBuilderAppVersion</code> interface instead.
	 */
	public static final String TABLE_NAME = "AppBuilderAppVersion";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR}, {"appBuilderAppVersionId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"appBuilderAppId", Types.BIGINT}, {"ddlRecordSetId", Types.BIGINT},
		{"ddmStructureId", Types.BIGINT},
		{"ddmStructureLayoutId", Types.BIGINT}, {"version", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("appBuilderAppVersionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("appBuilderAppId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ddlRecordSetId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ddmStructureId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ddmStructureLayoutId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("version", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table AppBuilderAppVersion (uuid_ VARCHAR(75) null,appBuilderAppVersionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,appBuilderAppId LONG,ddlRecordSetId LONG,ddmStructureId LONG,ddmStructureLayoutId LONG,version VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP =
		"drop table AppBuilderAppVersion";

	public static final String ORDER_BY_JPQL =
		" ORDER BY appBuilderAppVersion.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY AppBuilderAppVersion.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long APPBUILDERAPPID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VERSION_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public AppBuilderAppVersionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _appBuilderAppVersionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setAppBuilderAppVersionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _appBuilderAppVersionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return AppBuilderAppVersion.class;
	}

	@Override
	public String getModelClassName() {
		return AppBuilderAppVersion.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<AppBuilderAppVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<AppBuilderAppVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<AppBuilderAppVersion, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((AppBuilderAppVersion)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<AppBuilderAppVersion, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<AppBuilderAppVersion, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(AppBuilderAppVersion)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<AppBuilderAppVersion, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<AppBuilderAppVersion, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<AppBuilderAppVersion, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<AppBuilderAppVersion, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<AppBuilderAppVersion, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<AppBuilderAppVersion, Object>>();
		Map<String, BiConsumer<AppBuilderAppVersion, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<AppBuilderAppVersion, ?>>();

		attributeGetterFunctions.put("uuid", AppBuilderAppVersion::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<AppBuilderAppVersion, String>)
				AppBuilderAppVersion::setUuid);
		attributeGetterFunctions.put(
			"appBuilderAppVersionId",
			AppBuilderAppVersion::getAppBuilderAppVersionId);
		attributeSetterBiConsumers.put(
			"appBuilderAppVersionId",
			(BiConsumer<AppBuilderAppVersion, Long>)
				AppBuilderAppVersion::setAppBuilderAppVersionId);
		attributeGetterFunctions.put(
			"groupId", AppBuilderAppVersion::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<AppBuilderAppVersion, Long>)
				AppBuilderAppVersion::setGroupId);
		attributeGetterFunctions.put(
			"companyId", AppBuilderAppVersion::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<AppBuilderAppVersion, Long>)
				AppBuilderAppVersion::setCompanyId);
		attributeGetterFunctions.put("userId", AppBuilderAppVersion::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<AppBuilderAppVersion, Long>)
				AppBuilderAppVersion::setUserId);
		attributeGetterFunctions.put(
			"userName", AppBuilderAppVersion::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<AppBuilderAppVersion, String>)
				AppBuilderAppVersion::setUserName);
		attributeGetterFunctions.put(
			"createDate", AppBuilderAppVersion::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<AppBuilderAppVersion, Date>)
				AppBuilderAppVersion::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", AppBuilderAppVersion::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<AppBuilderAppVersion, Date>)
				AppBuilderAppVersion::setModifiedDate);
		attributeGetterFunctions.put(
			"appBuilderAppId", AppBuilderAppVersion::getAppBuilderAppId);
		attributeSetterBiConsumers.put(
			"appBuilderAppId",
			(BiConsumer<AppBuilderAppVersion, Long>)
				AppBuilderAppVersion::setAppBuilderAppId);
		attributeGetterFunctions.put(
			"ddlRecordSetId", AppBuilderAppVersion::getDdlRecordSetId);
		attributeSetterBiConsumers.put(
			"ddlRecordSetId",
			(BiConsumer<AppBuilderAppVersion, Long>)
				AppBuilderAppVersion::setDdlRecordSetId);
		attributeGetterFunctions.put(
			"ddmStructureId", AppBuilderAppVersion::getDdmStructureId);
		attributeSetterBiConsumers.put(
			"ddmStructureId",
			(BiConsumer<AppBuilderAppVersion, Long>)
				AppBuilderAppVersion::setDdmStructureId);
		attributeGetterFunctions.put(
			"ddmStructureLayoutId",
			AppBuilderAppVersion::getDdmStructureLayoutId);
		attributeSetterBiConsumers.put(
			"ddmStructureLayoutId",
			(BiConsumer<AppBuilderAppVersion, Long>)
				AppBuilderAppVersion::setDdmStructureLayoutId);
		attributeGetterFunctions.put(
			"version", AppBuilderAppVersion::getVersion);
		attributeSetterBiConsumers.put(
			"version",
			(BiConsumer<AppBuilderAppVersion, String>)
				AppBuilderAppVersion::setVersion);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getAppBuilderAppVersionId() {
		return _appBuilderAppVersionId;
	}

	@Override
	public void setAppBuilderAppVersionId(long appBuilderAppVersionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_appBuilderAppVersionId = appBuilderAppVersionId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getAppBuilderAppId() {
		return _appBuilderAppId;
	}

	@Override
	public void setAppBuilderAppId(long appBuilderAppId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_appBuilderAppId = appBuilderAppId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalAppBuilderAppId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("appBuilderAppId"));
	}

	@Override
	public long getDdlRecordSetId() {
		return _ddlRecordSetId;
	}

	@Override
	public void setDdlRecordSetId(long ddlRecordSetId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ddlRecordSetId = ddlRecordSetId;
	}

	@Override
	public long getDdmStructureId() {
		return _ddmStructureId;
	}

	@Override
	public void setDdmStructureId(long ddmStructureId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ddmStructureId = ddmStructureId;
	}

	@Override
	public long getDdmStructureLayoutId() {
		return _ddmStructureLayoutId;
	}

	@Override
	public void setDdmStructureLayoutId(long ddmStructureLayoutId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ddmStructureLayoutId = ddmStructureLayoutId;
	}

	@Override
	public String getVersion() {
		if (_version == null) {
			return "";
		}
		else {
			return _version;
		}
	}

	@Override
	public void setVersion(String version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalVersion() {
		return getColumnOriginalValue("version");
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(AppBuilderAppVersion.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), AppBuilderAppVersion.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public AppBuilderAppVersion toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, AppBuilderAppVersion>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		AppBuilderAppVersionImpl appBuilderAppVersionImpl =
			new AppBuilderAppVersionImpl();

		appBuilderAppVersionImpl.setUuid(getUuid());
		appBuilderAppVersionImpl.setAppBuilderAppVersionId(
			getAppBuilderAppVersionId());
		appBuilderAppVersionImpl.setGroupId(getGroupId());
		appBuilderAppVersionImpl.setCompanyId(getCompanyId());
		appBuilderAppVersionImpl.setUserId(getUserId());
		appBuilderAppVersionImpl.setUserName(getUserName());
		appBuilderAppVersionImpl.setCreateDate(getCreateDate());
		appBuilderAppVersionImpl.setModifiedDate(getModifiedDate());
		appBuilderAppVersionImpl.setAppBuilderAppId(getAppBuilderAppId());
		appBuilderAppVersionImpl.setDdlRecordSetId(getDdlRecordSetId());
		appBuilderAppVersionImpl.setDdmStructureId(getDdmStructureId());
		appBuilderAppVersionImpl.setDdmStructureLayoutId(
			getDdmStructureLayoutId());
		appBuilderAppVersionImpl.setVersion(getVersion());

		appBuilderAppVersionImpl.resetOriginalValues();

		return appBuilderAppVersionImpl;
	}

	@Override
	public int compareTo(AppBuilderAppVersion appBuilderAppVersion) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), appBuilderAppVersion.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof AppBuilderAppVersion)) {
			return false;
		}

		AppBuilderAppVersion appBuilderAppVersion =
			(AppBuilderAppVersion)object;

		long primaryKey = appBuilderAppVersion.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<AppBuilderAppVersion> toCacheModel() {
		AppBuilderAppVersionCacheModel appBuilderAppVersionCacheModel =
			new AppBuilderAppVersionCacheModel();

		appBuilderAppVersionCacheModel.uuid = getUuid();

		String uuid = appBuilderAppVersionCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			appBuilderAppVersionCacheModel.uuid = null;
		}

		appBuilderAppVersionCacheModel.appBuilderAppVersionId =
			getAppBuilderAppVersionId();

		appBuilderAppVersionCacheModel.groupId = getGroupId();

		appBuilderAppVersionCacheModel.companyId = getCompanyId();

		appBuilderAppVersionCacheModel.userId = getUserId();

		appBuilderAppVersionCacheModel.userName = getUserName();

		String userName = appBuilderAppVersionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			appBuilderAppVersionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			appBuilderAppVersionCacheModel.createDate = createDate.getTime();
		}
		else {
			appBuilderAppVersionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			appBuilderAppVersionCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			appBuilderAppVersionCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		appBuilderAppVersionCacheModel.appBuilderAppId = getAppBuilderAppId();

		appBuilderAppVersionCacheModel.ddlRecordSetId = getDdlRecordSetId();

		appBuilderAppVersionCacheModel.ddmStructureId = getDdmStructureId();

		appBuilderAppVersionCacheModel.ddmStructureLayoutId =
			getDdmStructureLayoutId();

		appBuilderAppVersionCacheModel.version = getVersion();

		String version = appBuilderAppVersionCacheModel.version;

		if ((version != null) && (version.length() == 0)) {
			appBuilderAppVersionCacheModel.version = null;
		}

		return appBuilderAppVersionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<AppBuilderAppVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<AppBuilderAppVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<AppBuilderAppVersion, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(AppBuilderAppVersion)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<AppBuilderAppVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<AppBuilderAppVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<AppBuilderAppVersion, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((AppBuilderAppVersion)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, AppBuilderAppVersion>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					AppBuilderAppVersion.class, ModelWrapper.class);

	}

	private String _uuid;
	private long _appBuilderAppVersionId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _appBuilderAppId;
	private long _ddlRecordSetId;
	private long _ddmStructureId;
	private long _ddmStructureLayoutId;
	private String _version;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<AppBuilderAppVersion, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((AppBuilderAppVersion)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"appBuilderAppVersionId", _appBuilderAppVersionId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("appBuilderAppId", _appBuilderAppId);
		_columnOriginalValues.put("ddlRecordSetId", _ddlRecordSetId);
		_columnOriginalValues.put("ddmStructureId", _ddmStructureId);
		_columnOriginalValues.put(
			"ddmStructureLayoutId", _ddmStructureLayoutId);
		_columnOriginalValues.put("version", _version);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("uuid_", 1L);

		columnBitmasks.put("appBuilderAppVersionId", 2L);

		columnBitmasks.put("groupId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("appBuilderAppId", 256L);

		columnBitmasks.put("ddlRecordSetId", 512L);

		columnBitmasks.put("ddmStructureId", 1024L);

		columnBitmasks.put("ddmStructureLayoutId", 2048L);

		columnBitmasks.put("version", 4096L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private AppBuilderAppVersion _escapedModel;

}