/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.app.builder.model.impl;

import com.liferay.app.builder.model.AppBuilderApp;
import com.liferay.app.builder.service.AppBuilderAppLocalServiceUtil;

/**
 * The extended model base implementation for the AppBuilderApp service. Represents a row in the &quot;AppBuilderApp&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AppBuilderAppImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AppBuilderAppImpl
 * @see AppBuilderApp
 * @generated
 */
public abstract class AppBuilderAppBaseImpl
	extends AppBuilderAppModelImpl implements AppBuilderApp {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a app builder app model instance should use the <code>AppBuilderApp</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			AppBuilderAppLocalServiceUtil.addAppBuilderApp(this);
		}
		else {
			AppBuilderAppLocalServiceUtil.updateAppBuilderApp(this);
		}
	}

}