/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.app.builder.internal.upgrade.v2_0_0;

import com.liferay.app.builder.internal.upgrade.v2_0_0.util.AppBuilderAppTable;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

/**
 * @author Rafael Praxedes
 */
public class UpgradeAppBuilderApp extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		if (!hasColumn("AppBuilderApp", "active_")) {
			alter(
				AppBuilderAppTable.class,
				new AlterTableAddColumn("active_", "BOOLEAN"));

			try (PreparedStatement ps1 = connection.prepareStatement(
					"select appBuilderAppId, status from AppBuilderApp");
				PreparedStatement ps2 =
					AutoBatchPreparedStatementUtil.concurrentAutoBatch(
						connection,
						"update AppBuilderApp set active_ = ? where " +
							"appBuilderAppId = ?");
				ResultSet rs = ps1.executeQuery()) {

				while (rs.next()) {
					ps2.setBoolean(
						1, (rs.getInt("status") == 0) ? true : false);
					ps2.setLong(2, rs.getLong("appBuilderAppId"));

					ps2.addBatch();
				}

				ps2.executeBatch();
			}
		}

		if (hasColumn("AppBuilderApp", "status")) {
			alter(AppBuilderAppTable.class, new AlterTableDropColumn("status"));
		}
	}

}