/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.app.builder.internal.upgrade;

import com.liferay.app.builder.internal.upgrade.v2_2_0.UpgradeSchema;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Rafael Praxedes
 */
@Component(immediate = true, service = UpgradeStepRegistrator.class)
public class AppBuilderServiceUpgrade implements UpgradeStepRegistrator {

	@Override
	public void register(Registry registry) {
		registry.register(
			"1.0.0", "2.0.0",
			new com.liferay.app.builder.internal.upgrade.v2_0_0.
				UpgradeAppBuilderApp());

		registry.register(
			"2.0.0", "2.1.0",
			new com.liferay.app.builder.internal.upgrade.v2_1_0.
				UpgradeAppBuilderApp());

		registry.register(
			"2.1.0", "2.2.0",
			new com.liferay.app.builder.internal.upgrade.v2_2_0.
				UpgradeAppBuilderApp(
					_ddlRecordSetLocalService, _ddmStructureLocalService),
			new UpgradeSchema(_counterLocalService));
	}

	@Reference
	private CounterLocalService _counterLocalService;

	@Reference
	private DDLRecordSetLocalService _ddlRecordSetLocalService;

	@Reference
	private DDMStructureLocalService _ddmStructureLocalService;

}