/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.antivirus.clamd.scanner.internal;

import com.liferay.antivirus.clamd.scanner.internal.configuration.ClamdAntivirusScannerConfiguration;
import com.liferay.document.library.kernel.antivirus.AntivirusScanner;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import fi.solita.clamav.ClamAVClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(configurationPid={"com.liferay.antivirus.clamd.scanner.internal.configuration.ClamdAntivirusScannerConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={AntivirusScanner.class})
public class ClamdAntivirusScanner
implements AntivirusScanner {
    private ClamAVClient _clamdClient;

    public boolean isActive() {
        return true;
    }

    public void scan(byte[] bytes) throws AntivirusScannerException {
        try {
            if (!ClamAVClient.isCleanReply((byte[])this._clamdClient.scan(bytes))) {
                throw new AntivirusScannerException("Virus detected in byte array", 2);
            }
        }
        catch (IOException ioException) {
            throw new AntivirusScannerException(1, (Throwable)ioException);
        }
    }

    public void scan(File file) throws AntivirusScannerException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            if (!ClamAVClient.isCleanReply((byte[])this._clamdClient.scan((InputStream)inputStream))) {
                throw new AntivirusScannerException("Virus detected in " + file.getAbsolutePath(), 2);
            }
        }
        catch (IOException ioException) {
            throw new AntivirusScannerException(1, (Throwable)ioException);
        }
    }

    public void scan(InputStream inputStream) throws AntivirusScannerException {
        try {
            if (!ClamAVClient.isCleanReply((byte[])this._clamdClient.scan(inputStream))) {
                throw new AntivirusScannerException("Virus detected in input stream", 2);
            }
        }
        catch (IOException ioException) {
            throw new AntivirusScannerException(1, (Throwable)ioException);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        ClamdAntivirusScannerConfiguration clamdAntivirusScannerConfiguration = (ClamdAntivirusScannerConfiguration)ConfigurableUtil.createConfigurable(ClamdAntivirusScannerConfiguration.class, properties);
        this._clamdClient = new ClamAVClient(clamdAntivirusScannerConfiguration.hostname(), clamdAntivirusScannerConfiguration.port(), clamdAntivirusScannerConfiguration.timeout());
    }
}

