/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.arquillian;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class WebArchiveBuilder {
    private static final Logger _logger = Logger.getLogger(WebArchiveBuilder.class);

    public static WebArchive build() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("ant", "direct-deploy", "-Dapp.server.deploy.dir=" + tempDir.getAbsolutePath(), "-Dauto.deploy.unpack.war=false");
            Process process = processBuilder.start();
            process.waitFor();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedReader.readLine();
            while (line != null) {
                _logger.debug((Object)line);
                line = bufferedReader.readLine();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Project project = WebArchiveBuilder._getProject();
        File warFile = new File(tempDir.getAbsolutePath(), project.getProperty("plugin.name") + ".war");
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)warFile);
    }

    private static Project _getProject() {
        Project project = new Project();
        File buildFile = new File("build.xml");
        project.setUserProperty("ant.file", buildFile.getAbsolutePath());
        project.init();
        ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
        project.addReference("ant.projectHelper", (Object)projectHelper);
        projectHelper.parse(project, (Object)buildFile);
        return project;
    }
}

