/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.cms.rest.client.serdes.v1_0;

import com.liferay.analytics.cms.rest.client.dto.v1_0.Metric;
import com.liferay.analytics.cms.rest.client.json.BaseJSONParser;
import com.liferay.analytics.cms.rest.client.serdes.v1_0.TrendSerDes;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class MetricSerDes {
    public static Metric toDTO(String json) {
        MetricJSONParser metricJSONParser = new MetricJSONParser();
        return (Metric)metricJSONParser.parseToDTO(json);
    }

    public static Metric[] toDTOs(String json) {
        MetricJSONParser metricJSONParser = new MetricJSONParser();
        return (Metric[])metricJSONParser.parseToDTOs(json);
    }

    public static String toJSON(Metric metric) {
        if (metric == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (metric.getMetricType() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"metricType\": ");
            sb.append("\"");
            sb.append(MetricSerDes._escape(metric.getMetricType()));
            sb.append("\"");
        }
        if (metric.getPreviousValue() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"previousValue\": ");
            sb.append(metric.getPreviousValue());
        }
        if (metric.getPreviousValueKey() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"previousValueKey\": ");
            sb.append("\"");
            sb.append(MetricSerDes._escape(metric.getPreviousValueKey()));
            sb.append("\"");
        }
        if (metric.getTrend() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"trend\": ");
            sb.append(String.valueOf(metric.getTrend()));
        }
        if (metric.getValue() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"value\": ");
            sb.append(metric.getValue());
        }
        if (metric.getValueKey() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"valueKey\": ");
            sb.append("\"");
            sb.append(MetricSerDes._escape(metric.getValueKey()));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        MetricJSONParser metricJSONParser = new MetricJSONParser();
        return metricJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(Metric metric) {
        if (metric == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (metric.getMetricType() == null) {
            map.put("metricType", null);
        } else {
            map.put("metricType", String.valueOf(metric.getMetricType()));
        }
        if (metric.getPreviousValue() == null) {
            map.put("previousValue", null);
        } else {
            map.put("previousValue", String.valueOf(metric.getPreviousValue()));
        }
        if (metric.getPreviousValueKey() == null) {
            map.put("previousValueKey", null);
        } else {
            map.put("previousValueKey", String.valueOf(metric.getPreviousValueKey()));
        }
        if (metric.getTrend() == null) {
            map.put("trend", null);
        } else {
            map.put("trend", String.valueOf(metric.getTrend()));
        }
        if (metric.getValue() == null) {
            map.put("value", null);
        } else {
            map.put("value", String.valueOf(metric.getValue()));
        }
        if (metric.getValueKey() == null) {
            map.put("valueKey", null);
        } else {
            map.put("valueKey", String.valueOf(metric.getValueKey()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            sb.append(MetricSerDes._toJSON(value));
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _toJSON(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Map) {
            return MetricSerDes._toJSON((Map)value);
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            StringBuilder sb = new StringBuilder("[");
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                sb.append(MetricSerDes._toJSON(values[i]));
                if (i + 1 >= values.length) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
        if (value instanceof String) {
            return "\"" + MetricSerDes._escape(value) + "\"";
        }
        return String.valueOf(value);
    }

    public static class MetricJSONParser
    extends BaseJSONParser<Metric> {
        @Override
        protected Metric createDTO() {
            return new Metric();
        }

        protected Metric[] createDTOArray(int size) {
            return new Metric[size];
        }

        @Override
        protected boolean parseMaps(String jsonParserFieldName) {
            if (Objects.equals(jsonParserFieldName, "metricType")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "previousValue")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "previousValueKey")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "trend")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "value")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "valueKey")) {
                return false;
            }
            return false;
        }

        @Override
        protected void setField(Metric metric, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "metricType")) {
                if (jsonParserFieldValue != null) {
                    metric.setMetricType((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "previousValue")) {
                if (jsonParserFieldValue != null) {
                    metric.setPreviousValue(Double.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "previousValueKey")) {
                if (jsonParserFieldValue != null) {
                    metric.setPreviousValueKey((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "trend")) {
                if (jsonParserFieldValue != null) {
                    metric.setTrend(TrendSerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "value")) {
                if (jsonParserFieldValue != null) {
                    metric.setValue(Double.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "valueKey") && jsonParserFieldValue != null) {
                metric.setValueKey((String)jsonParserFieldValue);
            }
        }
    }
}

