/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.cms.rest.client.resource.v1_0;

import com.liferay.analytics.cms.rest.client.dto.v1_0.Overview;
import com.liferay.analytics.cms.rest.client.http.HttpInvoker;
import com.liferay.analytics.cms.rest.client.problem.Problem;
import com.liferay.analytics.cms.rest.client.serdes.v1_0.OverviewSerDes;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface OverviewResource {
    public static Builder builder() {
        return new Builder();
    }

    public Overview getContentOverview(String var1, Integer var2, Integer var3) throws Exception;

    public HttpInvoker.HttpResponse getContentOverviewHttpResponse(String var1, Integer var2, Integer var3) throws Exception;

    public Overview getFileOverview(String var1, Integer var2, Integer var3) throws Exception;

    public HttpInvoker.HttpResponse getFileOverviewHttpResponse(String var1, Integer var2, Integer var3) throws Exception;

    public static class Builder {
        private String _contextPath = "";
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login;
        private String _password;
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public Builder bearerToken(String token) {
            return this.header("Authorization", "Bearer " + token);
        }

        public OverviewResource build() {
            return new OverviewResourceImpl(this);
        }

        public Builder contextPath(String contextPath) {
            this._contextPath = contextPath;
            return this;
        }

        public Builder endpoint(String address, String scheme) {
            String[] addressParts = address.split(":");
            String host = addressParts[0];
            int port = 443;
            if (addressParts.length > 1) {
                String portString = addressParts[1];
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse port from " + portString);
                }
            }
            return this.endpoint(host, port, scheme);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder endpoint(URL url) {
            return this.endpoint(url.getHost(), url.getPort(), url.getProtocol());
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }

    public static class OverviewResourceImpl
    implements OverviewResource {
        private static final Logger _logger = Logger.getLogger(OverviewResource.class.getName());
        private Builder _builder;

        @Override
        public Overview getContentOverview(String languageId, Integer rangeKey, Integer spaceId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getContentOverviewHttpResponse(languageId, rangeKey, spaceId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return OverviewSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getContentOverviewHttpResponse(String languageId, Integer rangeKey, Integer spaceId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (languageId != null) {
                httpInvoker.parameter("languageId", String.valueOf(languageId));
            }
            if (rangeKey != null) {
                httpInvoker.parameter("rangeKey", String.valueOf(rangeKey));
            }
            if (spaceId != null) {
                httpInvoker.parameter("spaceId", String.valueOf(spaceId));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/analytics-cms-rest/v1.0/content-overview");
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Overview getFileOverview(String languageId, Integer rangeKey, Integer spaceId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getFileOverviewHttpResponse(languageId, rangeKey, spaceId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return OverviewSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getFileOverviewHttpResponse(String languageId, Integer rangeKey, Integer spaceId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (languageId != null) {
                httpInvoker.parameter("languageId", String.valueOf(languageId));
            }
            if (rangeKey != null) {
                httpInvoker.parameter("rangeKey", String.valueOf(rangeKey));
            }
            if (spaceId != null) {
                httpInvoker.parameter("spaceId", String.valueOf(spaceId));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/analytics-cms-rest/v1.0/file-overview");
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        private OverviewResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }
}

