/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.site.initializer.internal.workflow.kaleo.runtime.node;

import com.liferay.ai.hub.site.initializer.internal.workflow.kaleo.runtime.node.util.InputVariablesUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import com.liferay.portal.kernel.workflow.WorkflowNodeManager;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoNodeSetting;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.node.BaseNodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.service.KaleoNodeSettingLocalService;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.vertexai.gemini.VertexAiGeminiStreamingChatModel;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.TokenStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={NodeExecutor.class})
public class LLMNodeExecutor
extends BaseNodeExecutor {
    @Reference
    protected WorkflowInstanceManager workflowInstanceManager;
    @Reference
    protected WorkflowTaskManager workflowTaskManager;
    @Reference
    private KaleoNodeSettingLocalService _kaleoNodeSettingLocalService;
    @Reference
    private WorkflowNodeManager _workflowNodeManager;

    public NodeType getNodeType() {
        return NodeType.LLM;
    }

    protected boolean doEnter(KaleoNode currentKaleoNode, ExecutionContext executionContext) {
        return true;
    }

    protected void doExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) {
        VertexAiGeminiStreamingChatModel vertexAiGeminiStreamingChatModel = VertexAiGeminiStreamingChatModel.builder().project("ai-hub-liferay").location("us-central1").modelName("gemini-2.5-flash-lite").build();
        HashMap<String, String> kaleoNodeSettingValues = new HashMap<String, String>();
        List kaleoNodeSettings = this._kaleoNodeSettingLocalService.getKaleoNodeSettings(currentKaleoNode.getKaleoNodeId());
        for (KaleoNodeSetting kaleoNodeSetting : kaleoNodeSettings) {
            kaleoNodeSettingValues.put(kaleoNodeSetting.getName(), kaleoNodeSetting.getValue());
        }
        WritingAssistant writingAssistant = (WritingAssistant)AiServices.builder(WritingAssistant.class).systemMessageProvider(object -> InputVariablesUtil.applyInputVariables(executionContext, "prompt", kaleoNodeSettingValues)).streamingChatModel((StreamingChatModel)vertexAiGeminiStreamingChatModel).build();
        writingAssistant.rewrite(InputVariablesUtil.applyInputVariables(executionContext, "userMessage", kaleoNodeSettingValues)).onCompleteResponse(response -> this._completeResponse((ChatResponse)response, executionContext, vertexAiGeminiStreamingChatModel)).onError(throwable -> vertexAiGeminiStreamingChatModel.close()).start();
    }

    protected void doExit(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        KaleoTransition kaleoTransition = null;
        kaleoTransition = Validator.isNull((String)executionContext.getTransitionName()) ? currentKaleoNode.getDefaultKaleoTransition() : currentKaleoNode.getKaleoTransition(executionContext.getTransitionName());
        remainingPathElements.add(new PathElement(null, kaleoTransition.getTargetKaleoNode(), new ExecutionContext(executionContext.getKaleoInstanceToken(), executionContext.getWorkflowContext(), executionContext.getServiceContext())));
    }

    private void _completeResponse(ChatResponse chatResponse, ExecutionContext executionContext, VertexAiGeminiStreamingChatModel vertexAiGeminiStreamingChatModel) {
        Map workflowContext = executionContext.getWorkflowContext();
        AiMessage aiMessage = chatResponse.aiMessage();
        workflowContext.put("rewrittenText", aiMessage.text());
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        try {
            BiConsumer biConsumer = (BiConsumer)workflowContext.get("broadcast");
            biConsumer.accept(aiMessage.text(), String.valueOf(kaleoInstanceToken.getKaleoInstanceId()));
            this.workflowInstanceManager.updateWorkflowContext(kaleoInstanceToken.getCompanyId(), kaleoInstanceToken.getKaleoInstanceId(), workflowContext);
            this._workflowNodeManager.completeWorkflowNode(kaleoInstanceToken.getCompanyId(), kaleoInstanceToken.getUserId(), kaleoInstanceToken.getKaleoInstanceTokenId(), "end", workflowContext, false);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
        finally {
            vertexAiGeminiStreamingChatModel.close();
        }
    }

    public static interface WritingAssistant {
        public TokenStream rewrite(String var1);
    }
}

